/********************************** (C) COPYRIGHT *******************************
* File Name          : CH957x_adc.c
* Author             : WCH
* Version            : V1.0
* Date               : 2018/12/15
* Description 
*******************************************************************************/

#include "CH957x_common.h"


/*******************************************************************************
* Function Name  : ADC_DataCalib_Rough
* Description    : ݴֵ,ȡƫֵ
*                  ע⣬ʹôֵУ׼뱣֤ PA5(AIN1)ΪģʽܽⲿҪеѹ
* Input          : None
* Return         : ƫֵ
*******************************************************************************/
signed short ADC_DataCalib_Rough( void )        // ݴֵ,ȡƫֵ
{
    UINT16  i;
    UINT32  sum=0;
    UINT8  ch=0;        // ͨ
    UINT8   ctrl=0;     // ݿƼĴ
    
    ch = R8_ADC_CHANNEL;
    ctrl = R8_ADC_CFG;
    
    ADC_ChannelCfg( 1 );
    R8_ADC_CFG |= RB_ADC_OFS_TEST;      // ģʽ
    R8_ADC_CONVERT = RB_ADC_START;
    while( R8_ADC_CONVERT & RB_ADC_START );
    for(i=0; i<16; i++)
    {
        R8_ADC_CONVERT = RB_ADC_START;
        while( R8_ADC_CONVERT & RB_ADC_START );
        sum += (~R16_ADC_DATA)&RB_ADC_DATA;
    }    
    sum = (sum+8)>>4;
    R8_ADC_CFG &= ~RB_ADC_OFS_TEST;      // رղģʽ
    
    
    R8_ADC_CHANNEL = ch;
    R8_ADC_CFG = ctrl;
    return (2048 - sum); 
}

void ADC_DataCalib_Fine( PUINT16 dat, ADC_SignalPGATypeDef ga )        // ϸ
{
    UINT32  d = (UINT32)*dat;
    
	switch( ga )
	{
        case ADC_PGA_1_4:         // y=0.973x+55.188  
            *dat = (996*d + 56513 + 512)>>10;
			break;
			
		case ADC_PGA_1_2:         // y=0.974x+55.26 
            *dat = (997*d + 56586 + 512)>>10;
			break;
        
		case ADC_PGA_0:         // y=0.975x+53.63  
            *dat = (998*d + 54917 + 512)>>10;
			break;
			
		case ADC_PGA_2:         // y=0.975x+51.58  
            *dat = (998*d + 52818 + 512)>>10;
			break;
	}    
}

/*******************************************************************************
* Function Name  : ADC_ExtSingleChSampInit
* Description    : ⲿźŵͨʼ
* Input          : sp:
					refer to ADC_SampClkTypeDef
				   ga:
					refer to ADC_SignalPGATypeDef
* Return         : None
*******************************************************************************/
void ADC_ExtSingleChSampInit( ADC_SampClkTypeDef sp, ADC_SignalPGATypeDef ga )
{
    R8_ADC_CFG = RB_ADC_POWER_ON			\
                |RB_ADC_BUF_EN				\
                |( sp<<6 )					\
                |( ga<<4 )	;               
}

/*******************************************************************************
* Function Name  : ADC_ExtDiffChSampInit
* Description    : ⲿźŲͨʼ
* Input          : sp:
					refer to ADC_SampClkTypeDef
				   ga:
					refer to ADC_SignalPGATypeDef
* Return         : None
*******************************************************************************/
void ADC_ExtDiffChSampInit( ADC_SampClkTypeDef sp, ADC_SignalPGATypeDef ga )
{
    R8_ADC_CFG = RB_ADC_POWER_ON			\
                |RB_ADC_DIFF_EN             \
                |( sp<<6 )					\
                |( ga<<4 )	;
}

/*******************************************************************************
* Function Name  : ADC_InterTSSampInit
* Description    : ¶ȴʼ
* Input          : None
* Return         : None
*******************************************************************************/
void ADC_InterTSSampInit( void )
{
    R8_TEM_SENSOR |= RB_TEM_SEN_PWR_ON;
    R8_ADC_CHANNEL = CH_INTE_VTEMP;
    R8_ADC_CFG = RB_ADC_POWER_ON			\
                |( 2<<4 )	;
}

/*******************************************************************************
* Function Name  : ADC_InterBATSampInit
* Description    : õصѹʼ
* Input          : None
* Return         : None
*******************************************************************************/
void ADC_InterBATSampInit( void )
{
    R8_ADC_CHANNEL = CH_INTE_VBAT;
    R8_ADC_CFG = RB_ADC_POWER_ON			\
                |RB_ADC_BUF_EN				\
                |( 0<<4 )	;       // ʹ-12dBģʽ
}


/*******************************************************************************
* Function Name  : TouchKey_ChSampInit
* Description    : ͨʼ
* Input          : None
* Return         : None
*******************************************************************************/
void TouchKey_ChSampInit( void )
{
    R8_ADC_CFG = RB_ADC_POWER_ON | RB_ADC_BUF_EN | ( 2<<4 );
    R8_TKEY_CTRL = RB_TKEY_PWR_ON;
}

/*******************************************************************************
* Function Name  : ADC_ExcutSingleConver
* Description    : ADCִеת
* Input          : None
* Return         : ADCת
*******************************************************************************/
UINT16 ADC_ExcutSingleConver( void )
{
    R8_ADC_CONVERT = RB_ADC_START;
    while( R8_ADC_CONVERT & RB_ADC_START );

    return ( R16_ADC_DATA&RB_ADC_DATA );
}

/*******************************************************************************
* Function Name  : TouchKey_ExcutSingleConver
* Description    : TouchKeyת
* Input          : d:  Touchkeyŵʱ䣬4bit-ŵʱ䣬8bit-ʱ
* Return         : ǰTouchKeyЧ
*******************************************************************************/
UINT16 TouchKey_ExcutSingleConver( UINT8 d )
{
    R8_TKEY_CTRL = RB_TKEY_PWR_ON;
    R8_TKEY_CNT = d;
    while( R8_TKEY_CTRL &  RB_TKEY_ACTION );

    return ( R16_ADC_DATA&RB_ADC_DATA );
}


/*******************************************************************************
* Function Name  : ADC_GetCurrentTS
* Description    : ȡǰ¶ֵ棩
* Input          : ts_vǰ¶ȴ
* Return         : ת¶ֵ棩
*******************************************************************************/
UINT8 ADC_GetCurrentTS( UINT16 ts_v )
{
    UINT16  vol_ts;
    UINT16  D85_tem, D85_vol, D25;
    
    vol_ts = (ts_v*1060)>>11;
    D85_tem = (UINT16)((*((PUINT32)ROM_TMP_85C_ADDR)>>16)&0x00ff); 
    D85_vol = *((PUINT16)ROM_TMP_85C_ADDR);
    D25 = *((PUINT32)ROM_TMP_25C_ADDR);
    
    
    return ( D85_tem - ( D85_vol - vol_ts + 8 ) * 16 / D25 );

}



