/********************************** (C) COPYRIGHT *******************************
* File Name          : CH957x_clk.c
* Author             : WCH
* Version            : V1.0
* Date               : 2018/12/15
* Description 
*******************************************************************************/

#include "CH957x_common.h"

/*******************************************************************************
* Function Name  : SystemInit
* Description    : ϵͳʱĬϳʼ
* Input          : None			   				
* Return         : None
*******************************************************************************/
void SystemInit(void)
{
    R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		
    R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;
    R16_CLK_SYS_CFG = (2<<6)|0x08;			// 32M -> Fsys
    R8_SAFE_ACCESS_SIG = 0;
}

/*******************************************************************************
* Function Name  : SetSysClock
* Description    : ϵͳʱ
* Input          : sc: ϵͳʱԴѡ
					refer to SYS_CLKTypeDef
* Return         : None
*******************************************************************************/
void SetSysClock( SYS_CLKTypeDef sc)
{	
    switch( sc )
    {
        case CLK_SOURCE_LSI:
        	R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		
    		R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;
            R8_CK32K_CONFIG &= ~RB_CLK_OSC32K_XT;
            R16_CLK_SYS_CFG = (3<<6)|0x08;
            break;
        case CLK_SOURCE_LSE:
        	R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		
    		R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;
            R8_CK32K_CONFIG |= RB_CLK_OSC32K_XT;
            R16_CLK_SYS_CFG = (3<<6)|0x08;
            break;
        case CLK_SOURCE_HSE_32MHz:
        	R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		
    		R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;
            R16_CLK_SYS_CFG = RB_CLK_OSC32M_XT|(2<<6)|0x08;
            break;
        case CLK_SOURCE_HSE_16MHz:
        	R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		
    		R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;
            R16_CLK_SYS_CFG = RB_CLK_OSC32M_XT|(0<<6)|0x02;
            break;
        case CLK_SOURCE_HSE_8MHz:
        	R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		
    		R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;
            R16_CLK_SYS_CFG = RB_CLK_OSC32M_XT|(0<<6)|0x04;
            break;
        case CLK_SOURCE_HSI_32MHz:
        	R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		
    		R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;
            R16_CLK_SYS_CFG = (2<<6)|0x08;
            break;
        case CLK_SOURCE_HSI_16MHz:
        	R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		
    		R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;
            R16_CLK_SYS_CFG = (0<<6)|0x02;
            break;
        case CLK_SOURCE_HSI_8MHz:
        	R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		
    		R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;
            R16_CLK_SYS_CFG = (0<<6)|0x04;
            break;
        case CLK_SOURCE_PLL_40MHz:
        	R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		
    		R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;
            R16_CLK_SYS_CFG = RB_CLK_OSC32M_XT|(1<<6)|12;
            break;
        case CLK_SOURCE_PLL_32MHz:
        	R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		
    		R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;
            R16_CLK_SYS_CFG = RB_CLK_OSC32M_XT|(1<<6)|15;
            break;
        case CLK_SOURCE_PLL_24MHz:
        	R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		
    		R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;
            R16_CLK_SYS_CFG = RB_CLK_OSC32M_XT|(1<<6)|20;
            break;
        case CLK_SOURCE_PLL_20MHz:
        	R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		
    		R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;
            R16_CLK_SYS_CFG = RB_CLK_OSC32M_XT|(1<<6)|24;
            break;
        case CLK_SOURCE_PLL_16MHz:
        	R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		
    		R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;
            R16_CLK_SYS_CFG = RB_CLK_OSC32M_XT|(1<<6)|30;
            break;
        default :
            break;		
    }	
    R8_SAFE_ACCESS_SIG = 0;
}

/*******************************************************************************
* Function Name  : GetSysClock
* Description    : ȡǰϵͳʱ
* Input          : None
* Return         : Hz
*******************************************************************************/
UINT32 GetSysClock( void )
{
	UINT16  rev;
	
	rev = R16_CLK_SYS_CFG & 0xff;		
	if( (rev & RB_CLK_SYS_MOD) == (2<<6) ){				// 32MƵ
	    return (32000000);
	}
	else if( (rev & RB_CLK_SYS_MOD) == (1<<6) ){		// PLLзƵ
	    return (480000000/(rev&0x1f));		
	}
	else if( (rev & RB_CLK_SYS_MOD) == (0<<6) ){		// 32MзƵ
		return (32000000/(rev&0x1f));	
	}
	else {												// 32KƵ
		return (32000);
	}	
}

/*******************************************************************************
* Function Name  : HClk32M_Select
* Description    : 32M ƵʱԴ
* Input          : hc: 
					Clk32M_HSI   -   ѡڲ32M
					Clk32M_HSE   -   ѡⲿ32M
* Return         : None
*******************************************************************************/
void HClk32M_Select( HClk32MTypeDef hc)
{
    R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		
    R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;	
    if( hc == Clk32M_HSI)
        R16_CLK_SYS_CFG &= ~RB_CLK_OSC32M_XT;
    else
        R16_CLK_SYS_CFG |= RB_CLK_OSC32M_XT;
    R8_SAFE_ACCESS_SIG = 0;
}

/*******************************************************************************
* Function Name  : LClk32K_Select
* Description    : 32K ƵʱԴ
* Input          : hc: 
					Clk32K_LSI   -   ѡڲ32K
					Clk32K_LSE   -   ѡⲿ32K
* Return         : None
*******************************************************************************/
void LClk32K_Select( LClk32KTypeDef hc)
{
    R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		
    R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;	
    if( hc == Clk32K_LSI)
        R8_CK32K_CONFIG &= ~RB_CLK_OSC32K_XT;
    else
        R8_CK32K_CONFIG |= RB_CLK_OSC32K_XT;
    R8_SAFE_ACCESS_SIG = 0;
}

/*******************************************************************************
* Function Name  : GetCalibrationBaseValue
* Description    : ȡڲ32KУ׼ֵ
* Input          : None
* Return         : Hz
*******************************************************************************/
UINT16 GetCalibrationBaseValue( void )
{
	UINT16  rev;
    UINT32  calv;
	
	rev = R16_CLK_SYS_CFG & 0xff;	

	if( (rev & RB_CLK_SYS_MOD) == (2<<6) ){				// 32MƵ
	    calv = ((5*32000000+(CAB_LSIFQ>>1))/CAB_LSIFQ);
	}
	else if( (rev & RB_CLK_SYS_MOD) == (1<<6) ){		// PLLзƵ
	    calv = (((UINT32)5*480000000/(rev&0x1f)+(CAB_LSIFQ>>1))/CAB_LSIFQ);		
	}
	else if( (rev & RB_CLK_SYS_MOD) == (0<<6) ){		// 32MзƵ
		calv = ((5*32000000/(rev&0x1f)+(CAB_LSIFQ>>1))/CAB_LSIFQ);	
	}
	else {												// 32KƵ
		calv = (5);
	}	

    return( calv &0xfff );
}

/*******************************************************************************
* Function Name  : Calibration_LSI
* Description    : У׼ڲ32Kʱ
* Input          : None
* Return         : None
*******************************************************************************/
void Calibration_LSI( void )
{
	UINT16  a1, a2, a, cnt, basev;
	
	basev = GetCalibrationBaseValue();
	cnt = 0;
	a = 0;
    a2 = 0;
    while(1)
    {  
    	cnt ++;
        a1 = a2;
        SingleCalibrat(3, basev);     // ֵ
        a2 = R16_INT32K_TUNE;   
        if((a1>a2)?((a1-a2)<=3):((a2-a1)<=3)) a++;
        else    a = 0;
        if( a>3 || cnt>5 )   break;
    }             
    
    cnt = 0;
    while(1)
    {  
    	cnt ++;
        a1 = a2;
        SingleCalibrat(1, basev);     // ΢
        a2 = R16_INT32K_TUNE;    
        if((a1>a2)?((a1-a2)<=1):((a2-a1)<=1)) a++;
        else    a = 0;
        if( a>2 || cnt>5 )   break;
    }                    
}

/*******************************************************************************
* Function Name  : SingleCalibrat
* Description    : У׼
* Input          : stepС
* Return         : None
*******************************************************************************/
void SingleCalibrat( UINT8 step, UINT16 v )
{
    UINT16  i, j;
    UINT16  c1, c2;
    UINT8   st = step;

	j = v;

    /* У׼ */
    R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		
    R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;
    R8_OSC_CAL_CTRL = RB_OSC_CNT_EN;
    c2 = 0xfff;

    while(1)
    {	
        while(!(R8_OSC_CAL_CTRL&RB_OSC_CNT_HALT));
        i = R16_OSC_CAL_CNT;			// ʵʱУ׼ֵ

        while(R8_OSC_CAL_CTRL&RB_OSC_CNT_HALT);		
        while(!(R8_OSC_CAL_CTRL&RB_OSC_CNT_HALT));
        i = R16_OSC_CAL_CNT;			// ʵʱУ׼ֵ		

        R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		
        R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;        
        if( i > j )
        {
            R16_INT32K_TUNE += st;			// ˵ RC Ƶƫ
            c1 = c2;
            c2 = i-j;
        }
        else
        {
            R16_INT32K_TUNE -= st;			// ˵ RC Ƶƫ
            c1 = c2;
            c2 = j-i;
        }

        if(c1 < c2)
        {
            R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		
            R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;
            if( i > j )     R16_INT32K_TUNE -= st;			// Уȥ
            else            R16_INT32K_TUNE += st;			// Уȥ			
            break;
        }
    }

    R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		
    R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;
    R8_OSC_CAL_CTRL = 0;
    R8_SAFE_ACCESS_SIG = 0;
}



/*******************************************************************************
* Function Name  : RTCInitTime
* Description    : RTCʱӳʼǰʱ
* Input          : h: ʱ - Сʱ
					MAX_H = 393192
				   m: ʱ - 
					MAX_M = 59
				   s: ʱ - 
				    MAX_S = 59
* Return         : None
*******************************************************************************/
void RTC_InitTime( UINT32 h, UINT16 m, UINT16 s )
{
    UINT32  t;
    UINT16  day, sec2, t32k;

    day = h/24;
    sec2 = (h%24)*1800+m*30+s/2;
    t32k = (s&1)?(0x8000):(0);
    t = sec2;
    t = t<<16 | t32k;

    R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		// 밲ȫģʽ
    R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;		
    R32_RTC_TRIG = day;
    R8_RTC_MODE_CTRL |= RB_RTC_LOAD_HI;
    R32_RTC_TRIG = t;	
    R8_RTC_MODE_CTRL |= RB_RTC_LOAD_LO;
    R8_SAFE_ACCESS_SIG = 0;
}

/*******************************************************************************
* Function Name  : RTC_GetTime
* Description    : ȡǰʱ
* Input          : ph: ȡʱ - Сʱ
					MAX_H = 393192
				   pm: ȡʱ - 
					MAX_M = 59
				   ps: ȡʱ - 
				    MAX_S = 59
* Return         : None
*******************************************************************************/
void RTC_GetTime( PUINT32 ph, PUINT16 pm, PUINT16 ps )
{
    UINT32  t;
    UINT16  day, sec2, t32k;

    day = R32_RTC_CNT_DAY & 0x3FFF;
    sec2 = R16_RTC_CNT_2S; 
    t32k = R16_RTC_CNT_32K;

    t = sec2*2 + ((t32k<0x8000)?0:1);		// 
    *ph = day*24 + t/3600;
    *pm = t%3600/60;
    *ps = t%60;
}

/*******************************************************************************
* Function Name  : RTC_SetCycle32k
* Description    : LSE/LSIʱӣõǰRTC 
* Input          : cyc: ڼֵ - cycle
					MAX_CYC = 0xA8BFFFFF = 2831155199
* Return         : None
*******************************************************************************/
void RTC_SetCycle32k( UINT32 cyc )
{
    R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		
    R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;   
    R32_RTC_TRIG = cyc;
    R8_RTC_MODE_CTRL |= RB_RTC_LOAD_LO;
    R8_SAFE_ACCESS_SIG = 0;
}

/*******************************************************************************
* Function Name  : RTC_GetCycle32k
* Description    : LSE/LSIʱӣȡǰRTC 
* Input          : None
* Return         : صǰMAX_CYC = 0xA8BFFFFF = 2831155199
*******************************************************************************/
UINT32 RTC_GetCycle32k( void )
{
    UINT32 i;
    
    do{
    	i = R32_RTC_CNT_32K;
    }while( i != R32_RTC_CNT_32K );
    
    return (i);
}

/*******************************************************************************
* Function Name  : RTC_TMRFunCfg
* Description    : RTCʱģʽ
* Input          : t: 
					refer to RTC_TMRCycTypeDef
* Return         : None
*******************************************************************************/
void RTC_TMRFunCfg( RTC_TMRCycTypeDef t )
{
    R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		
    R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;
    R8_RTC_MODE_CTRL &= ~(RB_RTC_TMR_EN|RB_RTC_TMR_MODE);
    R8_RTC_MODE_CTRL |= RB_RTC_TMR_EN | (t);
    R8_SAFE_ACCESS_SIG = 0;
}

/*******************************************************************************
* Function Name  : RTC_TRIGFunCfg
* Description    : RTCʱ䴥ģʽ
* Input          : cyc: ԵǰʱĴʱ䣬LSE/LSIʱ
* Return         : None
*******************************************************************************/
void RTC_TRIGFunCfg( UINT32 cyc )
{
    UINT32 t;

    t = RTC_GetCycle32k() + cyc;
    if( t&0xFFFF )	t = t+0x10000;

    R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		
    R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;
    R32_RTC_TRIG = t;
    R8_RTC_MODE_CTRL |= RB_RTC_TRIG_EN;
    R8_SAFE_ACCESS_SIG = 0;
}

/*******************************************************************************
* Function Name  : RTC_ModeFunDisable
* Description    : RTC ģʽܹر
* Input          : m: Ҫرյĵǰģʽ
* Return         : None
*******************************************************************************/
void RTC_ModeFunDisable( RTC_MODETypeDef m )
{
    UINT8  i=0;
    
    if( m & RTC_TRIG_MODE )    i |= RB_RTC_TRIG_EN;
    if( m & RTC_TMR_MODE )     i |= RB_RTC_TMR_EN;
    
    R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG1;		
    R8_SAFE_ACCESS_SIG = SAFE_ACCESS_SIG2;
    R8_RTC_MODE_CTRL &= ~(i);
    R8_SAFE_ACCESS_SIG = 0;
}

/*******************************************************************************
* Function Name  : RTC_GetITFlag
* Description    : ȡRTCжϱ־
* Input          : f: 
					refer to RTC_EVENTTypeDef
* Return         : жϱ־״̬:
					0     -  	δ¼
				   (!0)   -  	¼
*******************************************************************************/
UINT8 RTC_GetITFlag( RTC_EVENTTypeDef f )
{
    if( f == RTC_TRIG_EVENT )
        return ( R8_RTC_FLAG_CTRL & RB_RTC_TRIG_FLAG );
    else 
        return ( R8_RTC_FLAG_CTRL & RB_RTC_TMR_FLAG );
}

/*******************************************************************************
* Function Name  : RTC_ClearITFlag
* Description    : RTCжϱ־
* Input          : f: 
					refer to RTC_EVENTTypeDef
* Return         : None
*******************************************************************************/
void RTC_ClearITFlag( RTC_EVENTTypeDef f )
{
    switch( f ) 
    {
        case RTC_TRIG_EVENT:
            R8_RTC_FLAG_CTRL = RB_RTC_TRIG_CLR;
            break;
        case RTC_TMR_EVENT:
            R8_RTC_FLAG_CTRL = RB_RTC_TMR_CLR;
            break;
        default :
            break;
    }
}





