


#ifndef __CH57x_ADC_H__
#define __CH57x_ADC_H__

#ifdef __cplusplus
 extern "C" {
#endif

#include "CH579SFR.h"
#include "core_cm0.h"

     
#define ROM_TMP_85C_ADDR    0x40634
#define ROM_TMP_25C_ADDR    0x40638
     

/**
  * @brief  adc single channel define
  */
typedef enum
{
	CH_EXTIN_0 = 0,			// ADC ⲿģͨ 0
	CH_EXTIN_1,				// ADC ⲿģͨ 1
	CH_EXTIN_2,				// ADC ⲿģͨ 2
	CH_EXTIN_3,				// ADC ⲿģͨ 3
	CH_EXTIN_4,				// ADC ⲿģͨ 4
	CH_EXTIN_5,				// ADC ⲿģͨ 5
	CH_EXTIN_6,				// ADC ⲿģͨ 6
	CH_EXTIN_7,				// ADC ⲿģͨ 7
	CH_EXTIN_8,				// ADC ⲿģͨ 8
	CH_EXTIN_9,				// ADC ⲿģͨ 9
	CH_EXTIN_10,			// ADC ⲿģͨ 10
	CH_EXTIN_11,			// ADC ⲿģͨ 11
	CH_EXTIN_12,			// ADC ⲿģͨ 12
	CH_EXTIN_13,			// ADC ⲿģͨ 13
	
	CH_INTE_VBAT,			// ADC ڲؼͨ
	CH_INTE_VTEMP,			// ADC ڲ¶ȴͨ

}ADC_SingleChannelTypeDef;

/**
  * @brief  adc differential channel define
  */
typedef enum
{
	CH_DIFF_0_2 = 0,			// ADC ͨ #0-#2
	CH_DIFF_1_3,				// ADC ͨ #1-#3

}ADC_DiffChannelTypeDef;

/**
  * @brief  adc sampling clock
  */
typedef enum
{
	SampleFreq_3_2 = 0,			// 3.2M Ƶ
	SampleFreq_2_67,			// 2.67M Ƶ
	SampleFreq_5_33,			// 5.33M Ƶ
	SampleFreq_4,				// 4M Ƶ
}ADC_SampClkTypeDef;


/**
  * @brief  adc signal PGA
  */
typedef enum
{
	ADC_PGA_1_4 = 0,			// -12dB, 1/4
	ADC_PGA_1_2,				// -6dB, 1/2
	ADC_PGA_0,					// 0dB, 1
	ADC_PGA_2,					// 6dB, 2
}ADC_SignalPGATypeDef;


// refer to ADC_SingleChannelTypeDef
#define		ADC_ChannelCfg( d )		(R8_ADC_CHANNEL = d)												/*  ADC ͨ */
// refer to ADC_SampClkTypeDef
#define		ADC_SampClkCfg( d )		(R8_ADC_CFG=R8_ADC_CFG&(~RB_ADC_CLK_DIV)|(d<<6))					/*  ADC ʱ */
// refer to ADC_SignalPGATypeDef
#define		ADC_PGACfg( d )			(R8_ADC_CFG=R8_ADC_CFG&(~RB_ADC_PGA_GAIN)|(d<<4))				/*  ADC ź */
#define		ADC_TempCalibCfg( d )	(R8_TEM_SENSOR=R8_TEM_SENSOR&(~RB_TEM_SEN_CALIB)|d)				/* ڲ¶ȴУ׼ֵ */

void ADC_ExtSingleChSampInit( ADC_SampClkTypeDef sp, ADC_SignalPGATypeDef ga );						/* ⲿźŵͨʼ */
void ADC_ExtDiffChSampInit( ADC_SampClkTypeDef sp, ADC_SignalPGATypeDef ga );						/* ⲿźŲͨʼ */
void TouchKey_ChSampInit( void );                                                                   /* ͨʼ */
void ADC_InterTSSampInit( void );																	/* ¶ȴʼ */
void ADC_InterBATSampInit( void );																	/* õصѹʼ */

UINT16 ADC_ExcutSingleConver( void );																/* ADCִеת */
signed short ADC_DataCalib_Rough( void ); 
void ADC_DataCalib_Fine( PUINT16 dat, ADC_SignalPGATypeDef ga );
UINT16 TouchKey_ExcutSingleConver( UINT8 d );														/* TouchKeyת */
UINT8 ADC_GetCurrentTS( UINT16 ts_v );                                                              /* ȡǰ¶ֵ棩 */

#define ADC_ReadConverValue()       (R16_ADC_DATA)                                                  /* ȡתֵ */
#define ADC_StartUp()               (R8_ADC_CONVERT = RB_ADC_START)									/* ADCת */
#define ADC_GetITStatus()           ( R8_ADC_INT_FLAG & RB_ADC_IF_EOC )								/* ȡADCתɱ־ */
#define ADC_ClearITFlag()           (R8_ADC_CONVERT = 0)											/* ADCתɱ־ */

#define TouchKey_GetITStatus()      ( R8_ADC_INT_FLAG & RB_ADC_IF_EOC )							    /* ȡTouchKeyתɱ־ */
#define TouchKey_ClearITFlag()      (R8_TKEY_CTRL |= RB_TKEY_PWR_ON)								/* TouchKeyתɱ־ */

	 
#ifdef __cplusplus
}
#endif

#endif  // __CH57x_ADC_H__	

