


#ifndef __CH57x_CLK_H__
#define __CH57x_CLK_H__

#ifdef __cplusplus
 extern "C" {
#endif

#include "CH579SFR.h"
#include "core_cm0.h"

typedef enum
{
	CLK_SOURCE_LSI = 0,
	CLK_SOURCE_LSE,
	CLK_SOURCE_HSE_32MHz,
	CLK_SOURCE_HSE_16MHz,
	CLK_SOURCE_HSE_8MHz,
	CLK_SOURCE_HSI_32MHz,				//ϵĬ	
	CLK_SOURCE_HSI_16MHz,
	CLK_SOURCE_HSI_8MHz,
	CLK_SOURCE_PLL_40MHz,
	CLK_SOURCE_PLL_32MHz,
	CLK_SOURCE_PLL_24MHz,
	CLK_SOURCE_PLL_20MHz,
	CLK_SOURCE_PLL_16MHz,
	
}SYS_CLKTypeDef;


typedef enum
{
	Clk32M_HSI = 0,
	Clk32M_HSE,
	
}HClk32MTypeDef;

typedef enum
{
	Clk32K_LSI = 0,
	Clk32K_LSE,
	
}LClk32KTypeDef;


#define  MAX_DAY		0x00004000 
#define	 MAX_2_SEC		0x0000A8C0
//#define	 MAX_SEC		0x545FFFFF	


/**
  * @brief  rtc timer mode period define
  */
typedef enum
{
	Period_0_125_S = 0,			// 0.125s 
	Period_0_25_S,				// 0.25s 
	Period_0_5_S,				// 0.5s 
	Period_1_S,					// 1s 
	Period_2_S,					// 2s 
	Period_4_S,					// 4s 
	Period_8_S,					// 8s 
	Period_16_S,				// 16s 
}RTC_TMRCycTypeDef;	 
	 

/**
  * @brief  rtc interrupt event define
  */
typedef enum
{
	RTC_TRIG_EVENT = 0,			// RTC ¼
	RTC_TMR_EVENT,				// RTC ڶʱ¼

}RTC_EVENTTypeDef;	 

/**
  * @brief  rtc interrupt event define
  */
typedef enum
{
	RTC_TRIG_MODE = 0,			// RTC ģʽ
	RTC_TMR_MODE,				// RTC ڶʱģʽ

}RTC_MODETypeDef;


void SystemInit(void);							/* ϵͳʱӳʼ */	 
void SetSysClock( SYS_CLKTypeDef sc);			/* ϵͳʱ */
UINT32 GetSysClock( void );						/* ȡǰϵͳʱ */	
UINT16 GetCalibrationBaseValue( void );			/* ȡڲ32KУ׼ֵ */
void HClk32M_Select( HClk32MTypeDef hc);		/* 32M ƵʱԴ */
void LClk32K_Select( LClk32KTypeDef hc);		/* 32K ƵʱԴ */
void SingleCalibrat( UINT8 step, UINT16 v );	/* У׼ */
void Calibration_LSI( void );				/* ⲿ32MʱУ׼ڲ32Kʱ */


/* ڲ 32KHz ʱУ׼ */
/* ⲿ 32KHz ʱг */
/* ڲ 32MHz ʱУ׼ */
/* ⲿ 32MHz ʱг */
/* PLL  */	 
	 
	 
void RTC_InitTime( UINT32 h, UINT16 m, UINT16 s );			/* RTCʱӳʼǰʱ */
void RTC_GetTime( PUINT32 ph, PUINT16 pm, PUINT16 ps );		/* ȡǰʱ */
	 
void RTC_SetCycle32k( UINT32 cyc );							/* LSE/LSIʱӣõǰRTC  */	 
UINT32 RTC_GetCycle32k( void );				                /* LSE/LSIʱӣȡǰRTC  */

void RTC_TRIGFunCfg( UINT32 cyc );							/* RTCģʽüʱ,LSE/LSIʱӣƥ */
void RTC_TMRFunCfg( RTC_TMRCycTypeDef t );					/* RTCʱģʽ */
void RTC_ModeFunDisable( RTC_MODETypeDef m );               /* RTC ģʽܹر */

UINT8 RTC_GetITFlag( RTC_EVENTTypeDef f );					/* ȡRTCжϱ־ */	 
void RTC_ClearITFlag( RTC_EVENTTypeDef f );					/* RTCжϱ־ */ 

	 

	 
#ifdef __cplusplus
}
#endif

#endif  // __CH57x_CLK_H__	

