


#ifndef __CH57x_SYS_H__
#define __CH57x_SYS_H__

#ifdef __cplusplus
 extern "C" {
#endif

#include "CH579SFR.h"
#include "core_cm0.h"

	 
	 
/**
  * @brief  rtc interrupt event define
  */
typedef enum
{
	RST_STATUS_SW = 0,			// λ
	RST_STATUS_RPOR,			// ϵ縴λ
	RST_STATUS_WTR,				// Źʱλ
	RST_STATUS_MR,				// ⲿֶλ
	RST_STATUS_LRM0,			// Ѹλ-λ
	RST_STATUS_GPWSM,			// µģʽѸλ
	RST_STATUS_LRM1,			//	Ѹλ-Ź
	RST_STATUS_LRM2,			//	Ѹλ-ֶλ

}SYS_ResetStaTypeDef;

/**
  * @brief  rtc interrupt event define
  */
typedef enum
{
	INFO_ROM_READ = 0,			// FlashROM  Ƿɶ
	INFO_RESET_EN = 2,			// RST#ⲿֶλ빦Ƿ
	INFO_BOOT_EN,				// ϵͳ BootLoader Ƿ
	INFO_DEBUG_EN,				// ϵͳԽӿǷ
	INFO_LOADER,				// ǰϵͳǷBootloader 
	STA_SAFEACC_ACT,			// ǰϵͳǷڰȫ״̬RWA򲻿ɷ

}SYS_InfoStaTypeDef;
	 

#define SYS_GetChipID()				R8_CHIP_ID									/* ȡоƬID࣬һΪ̶ֵ */
#define SYS_GetAccessID()			R8_SAFE_ACCESS_ID							/* ȡȫIDһΪ̶ֵ */
UINT8 SYS_GetInfoSta( SYS_InfoStaTypeDef i );									/* ȡǰϵͳϢ״̬ */
// refer to SYS_ResetStaTypeDef
#define SYS_GetLastResetSta()		(R8_RESET_STATUS&RB_RESET_FLAG)				/* ȡϵͳϴθλ״̬ */
void SYS_ResetExecute( void );													/* ִϵͳλ */
#define SYS_ResetKeepBuf( d )		(R8_GLOB_RESET_KEEP = d)					/* ֶλ λ ŹλͨѸλӰ */

void SYS_DisableAllIrq( PUINT32 pirqv);									        /* رжϣǰжֵ */
void SYS_RecoverIrq( UINT32 irq_status );									    /* ָ֮ǰرյжֵ */
UINT32 SYS_GetSysTickCnt( void );												/* ȡǰϵͳ(SYSTICK)ֵ */

#define  WWDG_SetCounter( c )		(R8_WDOG_COUNT = c)							/* ؿŹֵ */
void  WWDG_ITCfg( UINT8 s );							/* Źжʹ */
void  WWDG_ResetCfg( UINT8 s );							/* Źλʹ */
#define  WWDG_GetFlowFlag()			(R8_RST_WDOG_CTRL&RB_WDOG_INT_FLAG)			/* ȡǰŹʱ־ */
void WWDG_ClearFlag(void);														/* Źжϱ־¼ؼֵҲ */


void mDelayuS( UINT16 t );		/* uS ʱ */
void mDelaymS( UINT16 t );		/* mS ʱ */



#ifdef __cplusplus
}
#endif

#endif  // __CH57x_SYS_H__	

