/********************************** (C) COPYRIGHT *******************************
* File Name          : CH57x_adc.c
* Author             : WCH
* Version            : V1.1
* Date               : 2020/04/01
* Description 
*******************************************************************************/

#include "CH57x_common.h"


/*******************************************************************************
* Function Name  : ADC_DataCalib_Rough
* Description    : ݴֵ,ȡƫֵ
* Input          : None
* Return         : ƫֵ
*******************************************************************************/
signed short ADC_DataCalib_Rough( void )        // ݴֵ,ȡƫֵ
{
    UINT16  i;
    UINT32  sum=0;
    UINT8  ch=0;        // ͨ
    UINT8   ctrl=0;     // ݿƼĴ
    
    ch = R8_ADC_CHANNEL;
    ctrl = R8_ADC_CFG;

    R8_ADC_CFG = 0;
    ADC_ChannelCfg( 6 );		// 6/7/10/11 ѡ
    R8_ADC_CFG |= RB_ADC_OFS_TEST|RB_ADC_POWER_ON|(2<<4);      // ģʽ
    R8_ADC_CONVERT = RB_ADC_START;
    while( R8_ADC_CONVERT & RB_ADC_START );
    for(i=0; i<16; i++)
    {
        R8_ADC_CONVERT = RB_ADC_START;
        while( R8_ADC_CONVERT & RB_ADC_START );
        sum += (~R16_ADC_DATA)&RB_ADC_DATA;
    }    
    sum = (sum+8)>>4;
    R8_ADC_CFG &= ~RB_ADC_OFS_TEST;      // رղģʽ
    
    R8_ADC_CHANNEL = ch;
    R8_ADC_CFG = ctrl;
    return (2048 - sum); 
}

/*******************************************************************************
* Function Name  : ADC_ExtSingleChSampInit
* Description    : ⲿźŵͨʼ
* Input          : sp:
					refer to ADC_SampClkTypeDef
				   ga:
					refer to ADC_SignalPGATypeDef
* Return         : None
*******************************************************************************/
void ADC_ExtSingleChSampInit( ADC_SampClkTypeDef sp, ADC_SignalPGATypeDef ga )
{
	R8_TKEY_CFG &= ~RB_TKEY_PWR_ON;
    R8_ADC_CFG = RB_ADC_POWER_ON			\
                |RB_ADC_BUF_EN				\
                |( sp<<6 )					\
                |( ga<<4 )	;               
}

/*******************************************************************************
* Function Name  : ADC_ExtDiffChSampInit
* Description    : ⲿźŲͨʼ
* Input          : sp:
					refer to ADC_SampClkTypeDef
				   ga:
					refer to ADC_SignalPGATypeDef
* Return         : None
*******************************************************************************/
void ADC_ExtDiffChSampInit( ADC_SampClkTypeDef sp, ADC_SignalPGATypeDef ga )
{
	R8_TKEY_CFG &= ~RB_TKEY_PWR_ON;
    R8_ADC_CFG = RB_ADC_POWER_ON			\
                |RB_ADC_DIFF_EN             \
                |( sp<<6 )					\
                |( ga<<4 )	;
}

/*******************************************************************************
* Function Name  : ADC_InterTSSampInit
* Description    : ¶ȴʼ
* Input          : None
* Return         : None
*******************************************************************************/
void ADC_InterTSSampInit( void )
{
	R8_TKEY_CFG &= ~RB_TKEY_PWR_ON;
    R8_TEM_SENSOR = RB_TEM_SEN_PWR_ON;
    R8_ADC_CHANNEL = CH_INTE_VTEMP;
    R8_ADC_CFG = RB_ADC_POWER_ON			\
                |RB_ADC_DIFF_EN             \
                |( 3<<4 )	;
}

/*******************************************************************************
* Function Name  : ADC_InterBATSampInit
* Description    : õصѹʼ
* Input          : None
* Return         : None
*******************************************************************************/
void ADC_InterBATSampInit( void )
{
	R8_TKEY_CFG &= ~RB_TKEY_PWR_ON;
    R8_ADC_CHANNEL = CH_INTE_VBAT;
    R8_ADC_CFG = RB_ADC_POWER_ON			\
                |RB_ADC_BUF_EN				\
                |( 0<<4 )	;       // ʹ-12dBģʽ
}


/*******************************************************************************
* Function Name  : TouchKey_ChSampInit
* Description    : ͨʼ
* Input          : None
* Return         : None
*******************************************************************************/
void TouchKey_ChSampInit( void )
{
    R8_ADC_CFG = RB_ADC_POWER_ON | RB_ADC_BUF_EN | ( 2<<4 );
    R8_TKEY_CFG |= RB_TKEY_PWR_ON;
}

/*******************************************************************************
* Function Name  : ADC_ExcutSingleConver
* Description    : ADCִеת
* Input          : None
* Return         : ADCת
*******************************************************************************/
UINT16 ADC_ExcutSingleConver( void )
{
    R8_ADC_CONVERT = RB_ADC_START;
    while( R8_ADC_CONVERT & RB_ADC_START );

    return ( R16_ADC_DATA&RB_ADC_DATA );
}

/*******************************************************************************
* Function Name  : TouchKey_ExcutSingleConver
* Description    : TouchKeyת
* Input          : charg:  Touchkeyʱ,5bitsЧ, t=charg*Tadc
*                  disch    Touchkeyŵʱ,3bitsЧ, t=disch*Tadc
* Return         : ǰTouchKeyЧ
*******************************************************************************/
UINT16 TouchKey_ExcutSingleConver( UINT8 charg, UINT8 disch )
{
	R8_TKEY_COUNT = (disch<<5)|(charg&0x1f);
	R8_TKEY_CONVERT = RB_TKEY_START;
	while( R8_TKEY_CONVERT &  RB_TKEY_START );
    return ( R16_ADC_DATA&RB_ADC_DATA );
}


/*******************************************************************************
* Function Name  : ADC_GetCurrentTS
* Description    : ȡǰ¶ֵ棩
* Input          : ts_vǰ¶ȴ
* Return         : ת¶ֵ棩
*******************************************************************************/
int ADC_GetCurrentTS( UINT16 ts_v )
{
  UINT32 C25_Data[2];
  int  cal;

  FLASH_EEPROM_CMD( CMD_GET_ROM_INFO, ROM_CFG_TMP_25C, C25_Data, 0 );
  cal = ( ( (ts_v * 1050) + 2048 ) >> 12 ) + ( 1050 >> 1 );
  cal = 25 + ((cal - (int)(C25_Data[0]&0xFFFF))*10/14);
  return (  cal );
}



