


#ifndef __CH57x_SPI_H__
#define __CH57x_SPI_H__

#ifdef __cplusplus
 extern "C" {
#endif


/**
  * @brief  SPI0 interrupt bit define
  */

#define	SPI0_IT_FST_BYTE 		RB_SPI_IE_FST_BYTE				// ӻģʽֽģʽ£յֽж
#define	SPI0_IT_FIFO_OV			RB_SPI_IE_FIFO_OV				// FIFO 
#define	SPI0_IT_DMA_END 		RB_SPI_IE_DMA_END				// DMA 
#define	SPI0_IT_FIFO_HF 		RB_SPI_IE_FIFO_HF				// FIFO ʹù
#define	SPI0_IT_BYTE_END		RB_SPI_IE_BYTE_END				// ֽڴ
#define	SPI0_IT_CNT_END 		RB_SPI_IE_CNT_END				// ȫֽڴ	 
	 
	 
	 
/**
  * @brief  Configuration data mode
  */
typedef enum
{
	Mode0_LowBitINFront = 0,					// ģʽ0λǰ
	Mode0_HighBitINFront,						// ģʽ0λǰ
	Mode3_LowBitINFront,						// ģʽ3λǰ
	Mode3_HighBitINFront,						// ģʽ3λǰ
}ModeBitOrderTypeDef;


/**
  * @brief  Configuration SPI0 slave mode
  */
typedef enum
{
	Mode_DataStream = 0,				// ģʽ
	Mose_FirstCmd,						// ֽģʽ
}Slave_ModeTypeDef;
	 
	 
/**************** SPI0 */	 
void SPI0_MasterDefInit( void );                            /* ģʽĬϳʼģʽ0+3ȫ˫+8MHz */
void SPI0_CLKCfg( UINT8 c );                                /* SPI0 ׼ʱã= d*Tsys */ 	 
void SPI0_DataMode( ModeBitOrderTypeDef m );                /* ģʽ */	 

void SPI0_MasterSendByte( UINT8 d );                        /* ͵ֽ (buffer) */
UINT8 SPI0_MasterRecvByte( void );                          /* յֽ (buffer) */

void SPI0_MasterTrans( UINT8 *pbuf, UINT16 len );           /* ʹFIFOͶֽ */	 
void SPI0_MasterRecv( UINT8 *pbuf, UINT16 len );            /* ʹFIFOնֽ */

void SPI0_MasterDMATrans( PUINT8 pbuf, UINT16 len);			/* DMAʽ   */
void SPI0_MasterDMARecv( PUINT8 pbuf, UINT16 len);			/* DMAʽ  */


void SPI0_SlaveInit( void );			                    /* 豸ģʽĬϳʼMISOGPIOӦΪģʽ */
#define SetFirstData(d)			(R8_SPI0_SLAVE_PRE = d)		/* ֽ */
void SPI0_SlaveSendByte( UINT8 d );			                /* ӻģʽһֽ */
UINT8 SPI0_SlaveRecvByte( void );			                /* ӻģʽһֽ */

void SPI0_SlaveTrans( UINT8 *pbuf, UINT16 len );            /* ӻģʽͶֽ */
void SPI0_SlaveRecv( PUINT8 pbuf, UINT16 len );             /* ӻģʽնֽ  */

void SPI0_SlaveDMATrans( PUINT8 pbuf, UINT16 len);          /* ӻģʽDMAʽͶֽ */
void SPI0_SlaveDMARecv( PUINT8 pbuf, UINT16 len);           /* ӻģʽDMAʽնֽ */

// refer to SPI0 interrupt bit define
#define SPI0_ITCfg(s,f)			((s)?(R8_SPI0_INTER_EN|=f):(R8_SPI0_INTER_EN&=~f))
#define SPI0_GetITFlag(f)		(R8_SPI0_INT_FLAG&f)		/* ȡжϱ־״̬0-δλ(!0)- */
#define SPI0_ClearITFlag(f)		(R8_SPI0_INT_FLAG = f)		/* ǰжϱ־ */


	 
#ifdef __cplusplus
}
#endif

#endif  // __CH57x_SPI_H__	

