


#ifndef __CH56x_SYS_H__
#define __CH56x_SYS_H__

#ifdef __cplusplus
 extern "C" {
#endif

#include "CH56xSFR.h"


/**
  * @brief  SYSTEM Information State
  */
typedef enum
{
	INFO_RESET_EN = 2,			// RST#ⲿֶλ빦Ƿ
	INFO_BOOT_EN,				// ϵͳ BootLoader Ƿ
	INFO_DEBUG_EN,				// ϵͳԽӿǷ
	INFO_LOADER,				// ǰϵͳǷBootloader 
}SYS_InfoStaTypeDef;


#define SYS_GetChipID()				R8_CHIP_ID									/* ȡоƬID࣬һΪ̶ֵ */
#define SYS_GetAccessID()			R8_SAFE_ACCESS_ID							/* ȡȫIDһΪ̶ֵ */
UINT8 SYS_GetInfoSta( SYS_InfoStaTypeDef i );									/* ȡǰϵͳϢ״̬ */

void Delay_Init(uint32_t systemclck);
void mDelayuS(uint32_t n);
void mDelaymS(uint32_t n);

//refer to SYS_ResetStaTypeDef
#define SYS_GetLastResetSta()		(R8_RST_BOOT_STAT&RB_RESET_FLAG)				/* ȡϵͳϴθλ״̬ */
void SYS_ResetExecute( void );													/* ִϵͳλ */
#define SYS_ResetKeepBuf( d )		(R8_GLOB_RESET_KEEP = d)					/* ֶλ λ ŹλͨѸλӰ */

//WWDG
#define  WWDG_SetCounter( c )		(R8_WDOG_COUNT = c)							/* ؿŹֵ */
void  WWDG_ITCfg( UINT8 s );							/* Źжʹ */
void  WWDG_ResetCfg( UINT8 s );							/* Źλʹ */
#define  WWDG_GetFlowFlag()			(R8_RST_WDOG_CTRL&RB_WDOG_INT_FLAG)			/* ȡǰŹʱ־ */
void WWDG_ClearFlag(void);														/* Źжϱ־¼ؼֵҲ */



#ifdef __cplusplus
}
#endif

#endif  // __CH56x_SYS_H__	

