/********************************** (C) COPYRIGHT *******************************
* File Name          : CH56x_dvp.c
* Author             : WCH
* Version            : V1.0
* Date               : 2020/07/31
* Description 
*******************************************************************************/

#include "CH56x_common.h"


/*******************************************************************************
* Function Name  : DVP_INTCfg
* Description    : DVPж
* Input          : s:  жϿ״̬
					ENABLE  - ʹӦж
					DISABLE - رӦж
				   i:  ж
					RB_DVP_IE_STP_FRM  - ֡ж
					RB_DVP_IE_FIFO_OV  - FIFOж
					RB_DVP_IE_FRM_DONE - ֡ж
					RB_DVP_IE_ROW_DONE - нж
					RB_DVP_IE_STR_FRM  - ֡ʼж
* Return         : None
*******************************************************************************/
void DVP_INTCfg( UINT8 s,  UINT8 i )
{
    if(s){
    	R8_DVP_INT_EN |= i;
    }
    else{
    	R8_DVP_INT_EN &= ~i;
    }
}

/*******************************************************************************
* Function Name  : DVP_Mode
* Description    : DVPģʽ
* Input          : s:  λ
					RB_DVP_D8_MOD  - 8λģʽ
					RB_DVP_D10_MOD - 10λģʽ
					RB_DVP_D12_MOD - 12λģʽ
				   i:  ѹģʽ
					Video_Mode - ʹƵģʽ
					JPEG_Mode  - ʹJPEGģʽ
* Return         : None
*******************************************************************************/
void DVP_Mode( UINT8 s,  DVP_Data_ModeTypeDef i)
{
	R8_DVP_CR0 &= ~RB_DVP_MSK_DAT_MOD;   //ָĬģʽ8bitģʽ

    if(s){
    	R8_DVP_CR0 |= s;
    }
    else{
    	R8_DVP_CR0 &= ~(3<<4);
    }

    if(i){
    	R8_DVP_CR0 |= RB_DVP_JPEG;
    }
    else{
    	R8_DVP_CR0 &= ~RB_DVP_JPEG;
    }
}

/*******************************************************************************
* Function Name  : DVP_Cfg
* Description    : DVP
* Input          : s:  DMAʹܿ
					DVP_DMA_Enable  - DMAʹ
					DVP_DMA_Disable - DMAʧ
				   i:  ־FIFO
					DVP_FLAG_FIFO_RESET_Enable  - λ־FIFO
                    DVP_FLAG_FIFO_RESET_Disable - ȡλ
				   j:  ߼λ
					DVP_RX_RESET_Enable - λ߼·
					DVP_RX_RESET_Disable - ȡλ
* Return         : None
*******************************************************************************/
void DVP_Cfg( DVP_DMATypeDef s,  DVP_FLAG_FIFO_RESETTypeDef i, DVP_RX_RESETTypeDef j)
{
    switch( s )
    {
        case DVP_DMA_Enable:
        	R8_DVP_CR1 |= RB_DVP_DMA_EN;
            break;
        case DVP_DMA_Disable:
        	R8_DVP_CR1 &= ~RB_DVP_DMA_EN;
            break;
        default:
            break;
    }

    switch( i )
    {
        case DVP_RX_RESET_Enable:
        	R8_DVP_CR1 |= RB_DVP_ALL_CLR;
            break;
        case DVP_RX_RESET_Disable:
        	R8_DVP_CR1 &= ~RB_DVP_ALL_CLR;
            break;
        default:
            break;
    }

    switch( j )
    {
        case DVP_RX_RESET_Enable:
        	R8_DVP_CR1 |= RB_DVP_RCV_CLR;
            break;
        case DVP_RX_RESET_Disable:
        	R8_DVP_CR1 &= ~RB_DVP_RCV_CLR;
            break;
        default:
            break;
    }

}
