/********************************** (C) COPYRIGHT *******************************
* File Name          : CH56x_pwm.c
* Author             : WCH
* Version            : V1.0
* Date               : 2020/07/31
* Description 
*******************************************************************************/

#include "CH56x_common.h"


/*******************************************************************************
* Function Name  : PWMX_CycleCfg
* Description    : PWM0-PWM3׼ʱ
* Input          : cyc:
					refer to PWMX_CycleTypeDef
* Return         : None
*******************************************************************************/
void PWMX_CycleCfg( PWMX_CycleTypeDef cyc )
{
    switch( cyc )
    {
        case PWMX_Cycle_256:
        	R8_PWM_CTRL_CFG &= ~RB_PWM_CYCLE_SEL;    //PWM ÿƼĴ,ʱѡ
            break;

        case PWMX_Cycle_255:
        	R8_PWM_CTRL_CFG |= RB_PWM_CYCLE_SEL;
            break;

        default :
            break;
    }
}

/*******************************************************************************
* Function Name  : PWMX_ACTOUT
* Description    : PWM0-PWM3ͨ
* Input          : ch:	select channel of pwm
					refer to channel of PWM define
				   da:	effective pulse width
				   pr:  select wave polar
					refer to PWMX_PolarTypeDef
				   s :  control pwmx function
					ENABLE  - PWM
					DISABLE - رPWM
* Return         : None
*******************************************************************************/
void PWMX_ACTOUT( UINT8 ch, UINT8 da, PWMX_PolarTypeDef pr, UINT8 s)
{
    UINT8 i;

    if(s == DISABLE)	R8_PWM_CTRL_MOD &= ~(ch);                        //жPWMǷʹ
    else
    {

    	(pr)?(R8_PWM_CTRL_MOD|=(ch<<4)):(R8_PWM_CTRL_MOD&=~(ch<<4));     //PWMԿ       1ĬϸߵƽЧ0Ĭϵ͵ƽЧ
        for(i=0; i<4; i++)
        {
            if((ch>>i)&1)		*((PUINT8V)((&R8_PWM0_DATA)+i)) = da;
        }
        R8_PWM_CTRL_MOD |= (ch);
    }
}





