#include <stdint.h>
#include "usb_des.h"

const uint8_t device_descriptor[] =
{
	0x12,
	0x01,
	0x10,
	0x02,
	0x00,
	0x00, 	// device sub-class
	0x00, 	// vendor specific protocol
	0x40, 	// max packet size 512B
	0x86, 	// vendor id-0x1A86(qinheng)
	0x1A,
	0x37, 	// product id 0x8080
	0x55,
	0x00, 	//bcdDevice 0x0111
	0x11,
	0x01, 	// manufacturer index stringc
	0x02, 	// product index string
	0x00, 	// serial number index string
	0x01
//        0X12,0X01,
//        0X00,0X03,
//        0X00,
//        0X00,
//        0X00,
//        0x40,
//        0X51,0X09,
//        0X66,0X16,0X00,0X01,
//        0X01,0X02,0X03,0X01
};

const uint8_t config_descriptor[] =
{

    0X09,0X02,0X20,0X00,0X01,0X01,0X00,0X80,0X3f,

    0X09,0X04,0X00,0X00,0X02,0X08,0X06,0X50,0X00,

	0x07,	// length of this endpoint descriptor
	0x05,	// ENDPOINT (5)
	0x81,	// endpoint direction (80 is in) and address
	0x02,	// transfer type - 00 = control, 01 = iso, 10 = bulk, 11 = int
	0x00,	// max packet size - 512 bytes
	0x02,	// max packet size - high
	0x00, 	// polling interval in milliseconds (1 for iso)

	0x07,	// length of this endpoint descriptor
	0x05,	// ENDPOINT (5)
	0x02,	// endpoint direction (80 is in) and address
	0x02,	// transfer type - 00 = control, 01 = iso, 10 = bulk, 11 = int
	0x00,	// max packet size - 512 bytes
	0x02,	// max packet size - high
	0x00 	// polling interval in milliseconds (1 for iso)
};	
// ====================================
// ===== String Descriptor Lang ID=====
// ====================================
const uint8_t string_descriptor0[] =
{
	0x04,	// this descriptor length
	0x03,	// descriptor type
	0x09,	// Language ID 0 low byte
	0x04	// Language ID 0 high byte
};


// ====================================
// =====   String Descriptor 1    =====
// ====================================
const uint8_t string_descriptor1[] =
{		
    0x08,	// length of this descriptor 
	0x03,
	'W',  
	0x00,
	'C',  
	0x00,
	'H',  
	0x00
};	      
         
// ====================================
// =====   String Descriptor 2    =====
// ====================================
const uint8_t string_descriptor2[] =
{
	0x1e,	// length of this descriptor 
	0x03,
	'U',  
	0x00,
    'S',  
    0x00,
    'B',  
    0x00,
    '3',
    0x00,
    '.',  
    0x00,
    '0',  
    0x00,
    ' ',  
    0x00,
    'D',
	0x00,
    'E',
    0x00,
    'V',
    0x00,
    'I',
    0x00,
    'C',
    0x00,
    'E',
    0x00,
    ' ',
    0x00
};
  
const uint8_t bos_descriptor[] =
{
	0x05,   // length of this descriptor                                                        
	0x0f,   // CONFIGURATION (2)                                                                
	0x16,   // total length includes endpoint descriptors (should be 1 more than last address)
	0x00,   // total length high byte                                                           
	0x02,   	// number of device cap

//};
//const uint8_t dev_cap_descriptor1[] =
//{
	0x07,
	0x10,	// DEVICE CAPABILITY type
	0x02,	// USB2.0 EXTENSION
	0x02,
	0x00,
	0x00,
	0x00,
//};
//const uint8_t dev_cap_descriptor2[] =
//{
	0x0a,	// length of this descriptor 
	0x10,	// DEVICE CAPABILITY type
	0x03,	// superspeed usb device capability
	0x00,	// 
	0x0e,	// ss/hs/fs
	0x00,
	0x01,	// the lowest speed is full speed
	0x0a,	// u1 exit latency is 10us
	0xff,	// u1 exit latency is 8us
	0x07
};


/********************************  ģ CH372  - ȫ  *****************************************/
/* 豸 */
const uint8_t MyDevDescr_CH372[ ] = {
        0x12, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x40,
        0x51, 0x09, 0x66, 0x16,                           /* IDͲƷID */
        0x00, 0x01, 0x01, 0x02, 0x03, 0x01 };

/* ȫ */
const uint8_t My_FS_CfgDescr_CH372[ ] = { 0X09,0X02,0X20,0X00,0X01,0X01,0X00,0X80,0X3f,
                                          0X09,0X04,0X00,0X00,0X02,0X08,0X06,0X50,0X00,

                                  0x07, 0x05, 0x82, 0x02, 0x40, 0x00, 0x00,
                                  0x07, 0x05, 0x02, 0x02, 0x40, 0x00, 0x00,

};

/* , ȹ̶Ϊ  512Byte */
const uint8_t My_HS_CfgDescr_CH372[ ] = { 0X09,0X02,0X20,0X00,0X01,0X01,0X00,0X80,0X96,
                                          0X09,0X04,0X00,0X00,0X02,0X08,0X06,0X50,0X00,

                                  0x07, 0x05, 0x81, 0x02, 0x00, 0x02, 0x00,
                                  0x07, 0x05, 0x02, 0x02, 0x00, 0x02, 0x00,

};


/* Global Variable */
#define DevEP0SIZE	0x40

/* Device Descriptor */
const uint8_t  MyDevDescr[] = {
	0x12, 0x01, 0x10, 0x01,0xFF, 0x80, 0x55, DevEP0SIZE,
	0x48, 0x43, 0x37, 0x55,
	0x00, 0x01, 0x01, 0x02, 0x00, 0x01,
};

/* Configration Descriptor */
const uint8_t  MyCfgDescr[] = {
	0x09, 0x02, 0x4A, 0x00, 0x01, 0x01, 0x00, 0x80, 0x32,
	0x09, 0x04, 0x00, 0x00, 0x08, 0xFF, 0x80, 0x55, 0x00,
	0x07, 0x05, 0x84, 0x02, 0x40, 0x00, 0x00,
	0x07, 0x05, 0x04, 0x02, 0x40, 0x00, 0x00,
	0x07, 0x05, 0x83, 0x02, 0x40, 0x00, 0x00,
	0x07, 0x05, 0x03, 0x02, 0x40, 0x00, 0x00,
	0x07, 0x05, 0x82, 0x02, 0x40, 0x00, 0x00,
	0x07, 0x05, 0x02, 0x02, 0x40, 0x00, 0x00,
	0x07, 0x05, 0x81, 0x02, 0x40, 0x00, 0x00,
	0x07, 0x05, 0x01, 0x02, 0x40, 0x00, 0x00,
};


