/********************************** (C) COPYRIGHT *******************************
* File Name          : usbhs_device.c
* Author             : WCH
* Version            : V1.0.0
* Date               : 2020/12/29
* Description        : USB2.0жϴ
*******************************************************************************/
#include "CH56x_common.h"
#include "usbhs.h"
#include "usb_des.h"
#include "uddisk.h"
#include "usb30_porp.h"
//USBHS 2.0

extern UINT8V link_sta;
UINT8 set_address_status =0;
UINT8 get_config_status =0;
UINT8 device_addr;
BOOL Ttog=1;
UINT8V restlen;
UINT32V curWaddr_U2 = 0,curRaddr_U2 = 0;
UINT8V RWsta_U2 = 0xff;


extern void cmd12( void );
void USBHS_IRQHandler(void) __attribute__((interrupt("WCH-Interrupt-fast")));
/*******************************************************************************
* Function Name  : USB20_endp_init
* Description    : USB2.0˵ʼ
* Input          : None
* Return         : None
*******************************************************************************/
void USB20_endp_init () // USBHS device endpoint initial
{
    USBHS->USB_BUF_MODE = 0xccccccc;
    USBHS->UEP0_MAX_LEN = 64;
    USBHS->UEP1_MAX_LEN = 512;
    USBHS->UEP2_MAX_LEN = 512;


    USBHS->UEP0_DMA    = (UINT32)(UINT8 *)endp0buff;
    USBHS->UEP1_TX_DMA = (UINT32)(UINT8 *)endp0buff;
    USBHS->UEP1_RX_DMA = (UINT32)(UINT8 *)endp0buff;
    USBHS->UEP2_TX_DMA = (UINT32)(UINT8 *)endp0buff;
    USBHS->UEP2_RX_DMA = (UINT32)(UINT8 *)endp0buff;

    USBHS->UEP0_CTRL = 0;
    USBHS->UEP1_CTRL = 0x20200000;
    USBHS->UEP2_CTRL = 0x20200000;
}
/*******************************************************************************
* Function Name  : USB20_dev_init
* Description    : USB2.0豸ʼ
* Input          : ENABLEʹ   DISABLEر
* Return         : None
*******************************************************************************/
void USB20_dev_init ( FunctionalState sta )  // USBSS device initial
{
    if(sta){
        USB20_endp_init();
        USBHS->USB_CONTROL = 0;
        USBHS->USB_CONTROL =  HIGH_SPEED | INT_BUSY_EN | DMA_EN | DEV_PU_EN | USB2_SETUP_EN | USB2_ACT_EN | USB2_DETECT_EN | USB2_SUSP_EN;
    }
    else{
        USBHS->USB_CONTROL = USB_ALL_CLR | USB_FORCE_RST;
    }
}

/*******************************************************************************
* Function Name  : USB20_set_address
* Description    : USB2.0豸ַ
* Input          : ַ
* Return         : None
*******************************************************************************/
void USB20_set_address( UINT32 address )
{
    USBHS->USB_CONTROL &= 0x00ffffff;
    USBHS->USB_CONTROL |= address<<24; // SET ADDRESS

}


void csw_U2(void){
//    printf("csw\n");
    USBHS->UEP1_TX_DMA = (UINT32)(UINT8 *)CSW_PARAMETER;
    USBHS->UEP1_CTRL = EP_T_RES_ACK | 13|(Ttog?(EP_T_TOG_0):(EP_T_TOG_1));

}


/*******************************************************************************
* Function Name  : DevEP1_OUT_Deal
* Description    : Deal device Endpoint 1 OUT.
* Input          : l: Data length.
* Return         : None
*******************************************************************************/
void DevEP1_OUT_Deal( UINT32 l )
{
    //EP1 RX data Deal

}

/*******************************************************************************
* Function Name  : write_start_U2
* Description    : EMMCд
* Input          : pReqnumд   Lbaaddrʼַ       cmden±־
* Return         : None
*******************************************************************************/
void write_start_U2( UINT16V pReqnum, UINT32 Lbaaddr,UINT8 cmden){
    UINT16 sdtran = 0, usbtran = 0;
    UINT8 sdstep=0, usbstep=0, flag = 0;
    UINT8 sta;
    UINT8 errflag=0;
    UINT32 timecnt=0;
//    while(!(R32_EMMC_STATUS & (1<<17))){     //EMMC
//        timecnt++;
//        if(timecnt>TIME_OVER_SET)     //ʱ˳Դ
//            break;
//    }
//    if(cmden){
//        USBHS->UEP2_CTRL =  EP_R_RES_ACK | (USBHS->UEP2_CTRL & ~EP_R_RES_MASK) ;
//        EMMCSendCmd((UINT32)Lbaaddr,(UINT16)(RB_EMMC_CKIDX|RB_EMMC_CKCRC|RESP_TYPE_48|EMMC_CMD25));//д
//        R32_EMMC_TRAN_MODE = RB_EMMC_DMA_DIR;              //ʼemmc
//        R32_EMMC_DMA_BEG1 =(UINT32)(UINT8 *)endp0buff;
//        while(!(R8_USB_INT_FG & RB_USB_IF_TRANSFER));     //ȴUSB
//        USBHS->UEP2_CTRL =  EP_R_RES_NAK | (USBHS->UEP2_CTRL & ~EP_R_RES_MASK);
//        timecnt=0;
//        while(!(R16_EMMC_INT_FG & RB_EMMC_IF_CMDDONE)){   //ж
//            timecnt++;
//            if(timecnt>TIME_OVER_SET){                         //ʱλEMMC
//                R16_EMMC_CLK_DIV=0;
//                R32_EMMC_BLOCK_CFG = 0;
//                EMMCIO0Init();
//                EMMCCardConfig( &TF_EMMCParam );
//                EMMCSendCmd((UINT32)Lbaaddr,(UINT16)(RB_EMMC_CKIDX|RB_EMMC_CKCRC|RESP_TYPE_48|EMMC_CMD25));//д
//                R32_EMMC_TRAN_MODE = RB_EMMC_DMA_DIR;              //ʼemmc
//                R32_EMMC_DMA_BEG1 =(UINT32)(UINT8 *)endp0buff;
//            }
//        }
//        R16_EMMC_INT_FG = RB_EMMC_IF_CMDDONE;             //ж
//        R32_EMMC_BLOCK_CFG = (512<<16) | pReqnum;
//    }
//    else{
//        USBHS->UEP2_CTRL =  EP_R_RES_ACK | (USBHS->UEP2_CTRL & ~EP_R_RES_MASK) ;
//        R32_EMMC_TRAN_MODE = RB_EMMC_DMA_DIR;             //ʼemmc
//        R32_EMMC_DMA_BEG1 =(UINT32)(UINT8 *)endp0buff;
//        while(!(R8_USB_INT_FG & RB_USB_IF_TRANSFER));
//        USBHS->UEP2_CTRL =  EP_R_RES_NAK | (USBHS->UEP2_CTRL & ~EP_R_RES_MASK) ;
//        R32_EMMC_BLOCK_CFG = (512<<16) | pReqnum;
//    }
////      printf("Write start\n");
//    timecnt=0;
//    while(1){
//        if( R8_USB_INT_FG & RB_USB_IF_TRANSFER ){
//            timecnt = 0;
//            USBHS->UEP2_CTRL =  EP_R_RES_NAK | (USBHS->UEP2_CTRL & ~EP_R_RES_MASK) ;
//            R8_USB_INT_FG = RB_USB_IF_TRANSFER;
//            usbtran++;
//            usbstep++;
//            //                  printf("a:%d\n",usbtran);
//            if( usbstep == MAX_BUF_BLOCK )  usbstep = 0;
//            USBHS->UEP2_RX_DMA = (UINT32)(UINT8 *)( endp0buff + usbstep * 512 );
//            if( ( usbtran - sdtran ) == MAX_BUF_BLOCK ){     /* رս */
//                USBHS->UEP2_CTRL =EP_R_RES_NAK | (USBHS->UEP2_CTRL & ~EP_R_RES_MASK & ~EP_T_RES_MASK) ;
//            }
//            else{
//                USBHS->UEP2_CTRL =  EP_R_RES_ACK | (USBHS->UEP2_CTRL & ~EP_R_RES_MASK) ;
//            }
//            if( flag ){
//                R32_EMMC_DMA_BEG1 = (UINT32)(UINT8 *)( endp0buff + sdstep * 512 );   /*  */
//                flag = 0;
//            }
//        }
//
//      if(R16_EMMC_INT_FG & RB_EMMC_IF_BKGAP)
//      {
//          timecnt = 0;
//          R16_EMMC_INT_FG = RB_EMMC_IF_BKGAP;
////                  printf("b\n");
//          sdtran++;
//          sdstep++;
//          if( sdstep == MAX_BUF_BLOCK ){     //
//              sdstep = 0;
//          }
//          if(sdtran < usbtran){              /* дһ */
//              R32_EMMC_DMA_BEG1 = (UINT32)(UINT8 *)( endp0buff + sdstep * 512 );
//          }
//          else{
//              flag = 1;
//          }
//          USBHS->UEP2_CTRL =  EP_R_RES_ACK | (USBHS->UEP2_CTRL & ~EP_R_RES_MASK & ~EP_T_RES_MASK);          /* 򿪽 */
//      }
//      else if(R16_EMMC_INT_FG & RB_EMMC_IF_TRANDONE)
//      {
//          R16_EMMC_INT_FG = RB_EMMC_IF_TRANDONE;
////                  printf("c\n");
//          USBHS->UEP2_CTRL = EP_T_RES_NAK| EP_R_RES_NAK | (USBHS->UEP2_CTRL & ~EP_R_RES_MASK & ~EP_T_RES_MASK) ;
//          break;
//      }
//      timecnt++;
//        if(timecnt>TIME_OVER_SET){
//            printf("TO\n");
//            timecnt = 0;
//            if(( usbtran - sdtran ) == MAX_BUF_BLOCK){   //USBemmcס
//                R16_EMMC_CLK_DIV=0;
//                R32_EMMC_BLOCK_CFG = 0;
//                EMMCIO0Init();
//                EMMCCardConfig( &TF_EMMCParam ); //൱ڸλEMMC
//                EMMCSendCmd((UINT32)Lbaaddr+sdtran,(UINT16)(RB_EMMC_CKIDX|RB_EMMC_CKCRC|RESP_TYPE_48|EMMC_CMD25));//д
//                R32_EMMC_TRAN_MODE = RB_EMMC_DMA_DIR|(1<<6);                //ô䷽
//                R32_EMMC_DMA_BEG1 =(UINT32)(UINT8 *)( endp0buff + sdstep * 512 ); //дһ
//                timecnt = 0;
//                while(!(R16_EMMC_INT_FG & RB_EMMC_IF_CMDDONE)){      //ȴ
//                    timecnt++;
//                    if(timecnt>TIME_OVER_SET){//ʱλEMMC
//                        timecnt=0;
//                        break;
//                    }
//                }
//                R16_EMMC_INT_FG = RB_EMMC_IF_CMDDONE;                //ж
//                R32_EMMC_BLOCK_CFG = 512<<16 | (pReqnum-sdtran)  ;            //USB֮ԴEMMC
//            }
//        }
//    }
//    USBHS->UEP2_RX_DMA = (UINT32)(UINT8 *)( endp0buff  );
}

void read_start_U2( UINT16 pReqnum, UINT32 Lbaaddr,UINT8 cmden){
        UINT16V  sdtran = 0, usbtran = 0;
        UINT8V   sdstep=0, usbstep=0;
        UINT8V  lock = 0, flag = 1;
        UINT32 timecnt = 0;    //ʱ־
//        R32_EMMC_DMA_BEG1 = (UINT32)(UINT8 *)endp0buff; //޸DMAַ
//        if(cmden){          //  printf("cmd18\n");
//            R32_EMMC_TRAN_MODE = (UINT32)((1<<4)|(1<<1));
//            R32_EMMC_BLOCK_CFG = (512<<16) | pReqnum;      //д봫Ŀ
//            EMMCSendCmd((UINT32)Lbaaddr,(UINT16)(RB_EMMC_CKIDX|RB_EMMC_CKCRC|RESP_TYPE_48|EMMC_CMD18));    //
//        }
//        else{  //ҪCMDֱstopλ
//            R32_EMMC_BLOCK_CFG = (512<<16) | pReqnum;      //д봫Ŀ
//            R32_EMMC_TRAN_MODE = (UINT32)((1<<4));
//            R32_EMMC_TRAN_MODE = (UINT32)((1<<4)|(1<<1));
//        }
////        printf("read start\n");
//        while( 1 )
//        {
//            if( ( usbtran < (sdtran-1) ) &&  ( (R8_USB_INT_FG & RB_USB_IF_TRANSFER)|| flag ) ){
////                printf("U\n");
//                USBHS->UEP1_CTRL = EP_T_RES_NAK;//ֹϴ
//                R8_USB_INT_FG = RB_USB_IF_TRANSFER;  //ϴж
//                USBHS->UEP1_TX_DMA = (UINT32)(UINT8 *)( endp0buff + usbstep * 512 );  //޸DMAָ
//                USBHS->UEP1_CTRL = EP_T_RES_ACK | 512 | (Ttog?(EP_T_TOG_0):(EP_T_TOG_1));
//                Ttog^=1;
//                usbtran+=1;
//                usbstep+=1;
//                if( usbstep == MAX_BUF_BLOCK ){  usbstep = 0;  }
//                flag = 0;
//                if( lock ){
//                    lock = 0;
//                    R32_EMMC_TRAN_MODE = (UINT32)(1<<4);    //鴫ģʽ
//                }
//                timecnt=0;
//            }
//
//            if( R16_EMMC_INT_FG & RB_EMMC_IF_BKGAP ){  //鴫
////                printf("E\n");
//                R16_EMMC_INT_FG = RB_EMMC_IF_BKGAP;    //ж
//                sdtran++;
//                sdstep++;
//                if( sdstep == MAX_BUF_BLOCK )
//                {
//                    sdstep = 0;
//                }
//                R32_EMMC_DMA_BEG1 =(UINT32)(UINT8 *)(endp0buff + sdstep*512);   //޸DMAַ
//                if((sdtran-usbtran)<(MAX_BUF_BLOCK-2))
//                {
//                    R32_EMMC_TRAN_MODE = (UINT32)(1<<4);    //
//                }
//                else   { lock = 1;}// printf("lock\n");}
//                timecnt=0;
//            }
//            else if( R16_EMMC_INT_FG & RB_EMMC_IF_TRANDONE ){
//                R16_EMMC_INT_FG = RB_EMMC_IF_TRANDONE | RB_EMMC_IF_CMDDONE;  //ж
//                sdtran++;
//                sdstep++;
//                break;   //˳ѭһwhileʣϴUSB
//            }
//            timecnt++;
//            if(timecnt>2*TIME_OVER_SET){      //ʱ
//                printf("to\n");
//                R16_EMMC_CLK_DIV=0;
//                R32_EMMC_BLOCK_CFG = 0;
//                EMMCIO0Init();
//                EMMCCardConfig( &TF_EMMCParam ); //൱ڸλEMMC
//                R32_EMMC_DMA_BEG1 =(UINT32)(UINT8 *)(endp0buff + sdstep*512);   //޸DMAַ
//                R32_EMMC_TRAN_MODE = (UINT32)((1<<4)|(1<<1));
//                R32_EMMC_BLOCK_CFG = (512<<16) | (pReqnum-sdtran);      //д봫Ŀ
//                EMMCSendCmd((UINT32)Lbaaddr+sdtran,(UINT16)(RB_EMMC_CKIDX|RB_EMMC_CKCRC|RESP_TYPE_48|EMMC_CMD18));    //
//                timecnt=0;
//            }
//        }
////        printf("usb:%d sd:%d \n",usbtran,sdtran);
//        while( 1 )
//        {
//            if(( R8_USB_INT_FG & RB_USB_IF_TRANSFER)|| flag  )  //пôᵼif
//            {
//                flag = 0;
//                USBHS->UEP1_CTRL = EP_T_RES_NAK;//ֹϴ
//                R8_USB_INT_FG = RB_USB_IF_TRANSFER;  //ϴж
////                printf("bw\n");
//                USBHS->UEP1_TX_DMA = (UINT32)(UINT8 *)( endp0buff + usbstep * 512 );  //޸DMAָ
//                USBHS->UEP1_CTRL = EP_T_RES_ACK | 512 | (Ttog?(EP_T_TOG_0):(EP_T_TOG_1));
//                Ttog^=1;
//                usbtran+=1;
//                usbstep+=1;
//
//                if( usbstep == MAX_BUF_BLOCK ){
//                    usbstep = 0;
//                }
//                if( usbtran == sdtran ){
//                    while(!(R8_USB_INT_FG & RB_USB_IF_TRANSFER));//ȴһ
//                    USBHS->UEP1_CTRL = EP_T_RES_NAK;//ֹϴ
//                    R8_USB_INT_FG = RB_USB_IF_TRANSFER;
//                    break;
//                }
//            }
//        }
}

/*******************************************************************************
* Function Name  : DevEP2_OUT_Deal
* Description    : Deal device Endpoint 2 OUT.
* Input          : l: Data length.
* Return         : None
*******************************************************************************/
void DevEP2_OUT_Deal( UINT32 l )
{
    UINT16  i;
    UINT8 *p;
    UINT16 len;
    UINT8 s;
    UINT32 LBAaddr_U2;
    UINT16 writeblocknum_U2 = 0;
    UINT16 reqblocknum_U2 = 0;
//    USBHS->UEP2_CTRL = (USBHS->UEP2_CTRL & ~EP_R_RES_MASK) | EP_R_RES_NAK;  //ack
//    USBHS->UEP1_CTRL = (USBHS->UEP1_CTRL & ~EP_T_RES_MASK) | EP_T_RES_NAK;  //ack
    R8_USB_INT_FG = RB_USB_IF_TRANSFER;
    if(*(UINT32 *)endp0buff==0x43425355){//CBW
        *(UINT32 *)&CSW_PARAMETER[4]   = *(UINT32 *)&endp0buff[4];//ֵCSWУ
//        printf("CBW:%02x\n",endp0buff[0xf]);
        switch(endp0buff[0xf]){
            case 0x28:   //
                LBAaddr_U2=(endp0buff[0xf+2]<<24)|(endp0buff[0xf+3]<<16)|(endp0buff[0xf+4]<<8)|(endp0buff[0xf+5]);
                reqblocknum_U2=(endp0buff[0xf+7]<<8)|(endp0buff[0xf+8]);
//                printf("RLBAaddr:%08X\n",LBAaddr_U2);
//                printf("num:%d\n",reqblocknum_U2);
                PFIC_DisableIRQ(USBHS_IRQn);
                read_start_U2(reqblocknum_U2, LBAaddr_U2,1);
                PFIC_EnableIRQ(USBHS_IRQn);
                len=0;
                csw_U2();
                break;
            case 0x2a:  //д
                  LBAaddr_U2=(endp0buff[0xf+2]<<24)|(endp0buff[0xf+3]<<16)|(endp0buff[0xf+4]<<8)|(endp0buff[0xf+5]);
                  writeblocknum_U2=(endp0buff[0xf+7]<<8)|(endp0buff[0xf+8]);
//                  printf("LBAaddr:%08X\n",LBAaddr_U2);
//                  printf("num:%d\n",writeblocknum_U2);
                  PFIC_DisableIRQ(USBHS_IRQn);       //enable USBHS interrupt
                  write_start_U2(writeblocknum_U2, LBAaddr_U2,0);
                  PFIC_EnableIRQ(USBHS_IRQn);       //enable USBHS interrupt
                  len=0;
                  csw_U2();
                break;
            case 0x12:
                if(endp0buff[0xf+4]==0x24){
                    memcpy(endp0buff, (UINT8 *)INQUIRY1,36 );
                    len=36;
                    restlen=1;
                }
                else if(endp0buff[0xf+4]==0x38){
                    memcpy(endp0buff, (UINT8 *)s1238,56 );
                    len=56;
                    restlen=1;
                }
                else if(endp0buff[0xf+4]==0x2f){
                    memcpy(endp0buff, (UINT8 *)LONG_INQUIRY,0x2f );
                    len=0x2f;
                    restlen=1;
                }
                else if(endp0buff[0xf+4]==0x40){
                    memcpy(endp0buff, (UINT8 *)INQUIRY1,0x40 );
                    len=0x40;
                    restlen=1;
                }
                else{
                    memcpy(endp0buff, (UINT8 *)LONG_INQUIRY,255 );
                    len=255;
                    restlen=1;
                }
                break;
            case 0x23:
                memcpy(endp0buff, (UINT8 *)&FORMAT_CAPACITIES.NULL1,12 );
                len=12;
                restlen=1;
                break;
            case 0x25:
                memcpy(endp0buff, (UINT8 *)&READ_CAPACITY.maxblock32,8);
                len=8;
                restlen=1;
                break;
            case 0x1a:
                if(endp0buff[0xf+2]==0x3f){
                    memcpy(endp0buff, (UINT8 *)s1a03,36);
                    len=36;
                    restlen=1;
                }
                else{
                    *(UINT32 *)endp0buff= 0x00000003;
                    len=4;
                    restlen=1;
                }
                break;
            case 0x00:
//                Ttog^=1;
                csw_U2();
                USBHS->UEP2_CTRL = (USBHS->UEP2_CTRL & ~EP_R_RES_MASK) | EP_R_RES_ACK;  // NAK
                len=0;
                break;
            case 0x35:
                csw_U2();
                len=0;
                break;
            case 0x1E:
                csw_U2();
                len=0;
                break;
            case 0x03:
                memcpy(endp0buff, (UINT8 *)s03,18);
                len=18;
                restlen=1;
                break;

        }
        if(len){
             USBHS->UEP1_TX_DMA =(UINT32)(UINT8 *)endp0buff;
             USBHS->UEP1_CTRL = EP_T_RES_ACK | len | (Ttog?(EP_T_TOG_0):(EP_T_TOG_1));
        }
    }
    else{//
        printf("errrr\n");
        for(i=0;i<512;i++)
            printf("%02X\n",endp0buff[i]);
    }
}


/*******************************************************************************
* Function Name  : DevEP2_IN_Deal
* Description    : Deal device Endpoint 1 IN.
* Input          : l: Data length.
* Return         : None
*******************************************************************************/
void DevEP2_IN_Deal(  )
{
    uint16_t s,i;
    //EP1 RX data Deal
    if(restlen == 1){
        restlen = 0 ;
        csw_U2();
    }
    USBHS->UEP2_CTRL = (USBHS->UEP2_CTRL & ~EP_R_RES_MASK) | EP_R_RES_ACK;  // NAK


}


/*******************************************************************************
* Function Name  : USBHS_IRQHandler
* Description    : USB2.0 Interrupt Handler.
* Input          : None
* Return         : None
*******************************************************************************/
void USBHS_IRQHandler (void){
//void USBHSsss(void){
	UINT32 end_num;
	UINT32 rx_token;
	UINT32 rx_len;
	UINT8  *p8;

	UINT32 i,temp,temp1;
	UINT8  send_data_len =0;
	UINT8  bmRequestType;
	UINT8  bRequest;
	UINT8  wValue_l;
	UINT8  wValue_h;
	UINT8  wLength;
	UINT8  config_len;
//	printf("int %x len=%x\n",USBHS->USB_STATUS, USBHS->USB_RX_LEN);

	if( USBHS->USB_STATUS & USB2_ACT_FLAG )    //USB жϱ־
	{
	    USBHS->UEP2_CTRL = (USBHS->UEP2_CTRL & ~EP_R_RES_MASK) | EP_R_RES_NAK;  //ack
	    USBHS->UEP1_CTRL =  EP_T_RES_NAK;  //ack
		end_num =  ((USBHS->USB_STATUS)>>24) & 0xf;  //EPn
		rx_token = ((USBHS->USB_STATUS)>>28) & 0x3; // 00: OUT, 01:SOF, 10:IN, 11:SETUP
		if( end_num == 2 ) //EP2
        {
            if( rx_token == PID_OUT ) // IN - DATA - ACK
            {
//                printf("2out\n");
                DevEP2_OUT_Deal(rx_len);

            }
            else// OUT - DATA - ACK
            {
                printf("2IN_ERR\n");
            }
        }
        else if( end_num == 1 )  //EP1
        {
            if( rx_token == PID_IN ) // IN - DATA - ACK
            {
//                printf("1in\n");
                 Ttog^=1;
                 if(restlen == 1){
                     restlen = 0 ;
                     csw_U2();
                 }
                 else
                     USBHS->UEP2_CTRL = (USBHS->UEP2_CTRL & ~EP_R_RES_MASK) | EP_R_RES_ACK;  // NAK
            }
            else
            {
                printf("1OUT_ERR\n");
            }
        }
		else if( end_num == 0 )   //EP0
		{
			if( rx_token == PID_IN ) // IN
			{
				if( set_address_status )
				{
				    USB20_set_address( device_addr );// SET ADDRESS
					set_address_status = 0;
					USBHS->UEP0_CTRL = 0;
				}
				else if( get_config_status )
				{
				    memcpy(endp0buff, (UINT8 *)config_descriptor+ 64,config_len );
				    USBHS->UEP0_CTRL = EP_T_RES_ACK | EP_T_TOG_0 | config_len; // DATA stage (IN -DATA1-ACK)
					get_config_status = 0;
				}
				else
				{
					USBHS->UEP0_CTRL = EP_R_RES_ACK | EP_R_TOG_1;
				}
			}
			else if( rx_token == PID_OUT ) //OUT
			{
			    USBHS->UEP2_CTRL = (USBHS->UEP2_CTRL & ~EP_R_RES_MASK) | EP_R_RES_ACK;  //ack
				USBHS->UEP0_CTRL = EP_T_RES_ACK | EP_T_TOG_1;
			}
		}
		USBHS->USB_STATUS = USB2_ACT_FLAG;
	 }
	 else if( USBHS->USB_STATUS & USB2_SETUP_FLAG )     //SETUPжϱ־
	     {
	         temp = endp0buff[0]|(endp0buff[1]<<8)|(endp0buff[2]<<16)|(endp0buff[3]<<24);
	         temp1 =  endp0buff[4]|(endp0buff[5]<<8)|(endp0buff[6]<<16)|(endp0buff[7]<<24);
	         bmRequestType =endp0buff[0];
	         bRequest = endp0buff[1];
	         wValue_l = endp0buff[2];
	         wValue_h = endp0buff[3];
	         wLength = (temp1>>16) & 0xffff;
	 //      for(i=0;i<8;i++)
	 //          printf("%02X ",ep0[i]);
	 //      printf("\n");
	 //      printf("temp%08X ",temp);
	 //      printf("temp1%08X ",temp1);
	         if( bmRequestType == 0 ) // without data stage   SETUP
	         {
	             if( bRequest == 0x5 ) // set address
	             {
	                 set_address_status = 1;
	                 device_addr = wValue_l;
	             }
	             else if( bRequest == 0x9 ) // set configuration
	             {

	             }
	             USBHS->UEP0_CTRL = EP_T_RES_ACK | EP_T_TOG_1; // IN -DATA1-ACK( len =0 )
	         }
	         else if( bmRequestType == 0x80 ) // data stage is IN   SETUP
	         {
	             if( bRequest == 0x06 && wValue_h == 0x01 ) // dev desc
	             {
	                 memcpy(endp0buff, (UINT8 *)MyDevDescr_CH372,18);
	                 send_data_len = MyDevDescr_CH372[0];

	             }
	             else if( bRequest == 0x06 && wValue_h == 0x02 ) // config desc
	             {

	                 if( My_FS_CfgDescr_CH372[2] > 64)   // >64
	                 {
	                     memcpy(endp0buff, (UINT8 *)My_HS_CfgDescr_CH372,64);
	                     send_data_len = 64;
	                     get_config_status = 1;

	                     config_len = My_HS_CfgDescr_CH372[2]-64;

	                 }
	                 else // <64
	                 {
	                     memcpy(endp0buff, (UINT8 *)My_HS_CfgDescr_CH372,My_HS_CfgDescr_CH372[2]);
	                     send_data_len = My_HS_CfgDescr_CH372[2];
	                 }

	                 if(wLength<64){send_data_len=wLength;}
	             }
	 //          else if( bRequest == 0x06 && wValue_h == 0x0f )  //BOS  
	 //          {
	 //              if( wLength >= bos_descriptor[2])
	 //              {
	 //                  user2mem_copy( (UINT8 *)bos_descriptor, ep0, bos_descriptor[2] );
	 //                  send_data_len = bos_descriptor[2];
	 //              }
	 //              else
	 //              {
	 //                  user2mem_copy( (UINT8 *)bos_descriptor, ep0, wLength );
	 //                  send_data_len = wLength;
	 //              }
	 //          }
	             else if( bRequest == 0x06 && wValue_h == 0x03 && wValue_l == 0x01  )// string1
	             {
	                 memcpy(endp0buff, (UINT8 *)string_descriptor1, string_descriptor1[0]);
	                 send_data_len = string_descriptor1[0];
	             }
	             else if( bRequest == 0x06 && wValue_h == 0x03 && wValue_l == 0x02  )// string2
	             {
	                 memcpy(endp0buff, (UINT8 *)string_descriptor2, string_descriptor2[0]);
	                 send_data_len = string_descriptor2[0];
	             }
	             else if( bRequest == 0x06 && wValue_h == 0x03  )// string0
	             {
	                 memcpy(endp0buff, (UINT8 *)string_descriptor0, string_descriptor0[0]);
	                 send_data_len = string_descriptor0[0];
	             }

	             USBHS->UEP0_CTRL = EP_T_RES_ACK | EP_T_TOG_1 | send_data_len; // DATA stage  (IN -DATA1-ACK) Send data EP0
	         }
	         else if( (temp & 0xffff) == 0xfea1 ) // ??
	         {
	             *( UINT8*) endp0buff = 0;
	             USBHS->UEP0_CTRL = EP_T_RES_ACK | EP_T_TOG_1 | 1;
	         }
	         else if( (temp & 0xffff) == 0x0102 ) // clear feature
	         {
	             USBHS->UEP0_CTRL = EP_T_RES_ACK | EP_T_TOG_1; // IN -DATA1-ACK( len =0 )
	         }
	         else
	         {
	             USBHS->UEP0_CTRL = EP_T_RES_STALL | EP_R_RES_STALL; // IN - STALL / OUT - DATA - STALL
	         }

	         USBHS->USB_STATUS = USB2_SETUP_FLAG; // clear int flag
	     }

	else if( USBHS->USB_STATUS & USB2_DETECT_FLAG )  //USB߸λ¼жϱ־
	{
		device_addr = 0;
		USB20_endp_init();   //reset ʼ˵
        USB20_set_address( device_addr );
		printf(" bus reset! \n");
		USBHS->USB_STATUS = USB2_DETECT_FLAG;
        {
		    if( link_sta == 1 ){
                PFIC_EnableIRQ(USBSS_IRQn);
                PFIC_EnableIRQ(LINK_IRQn);
                PFIC_EnableIRQ(TMR0_IRQn);
                R8_TMR0_INTER_EN = 1;
                TMR0_TimerInit( 67000000 );   //Լ0.5
                USB30D_init(ENABLE);
		    }
        }
	}

	else if(USBHS->USB_STATUS & USB2_SUSP_FLAG )  //USB߹¼жϱ־
	{
		printf(" bus suspend! \n");
		USBHS->USB_STATUS = USB2_SUSP_FLAG;
	}

}


