/*
 * CH56x_USB30_LIB.h
 *
 *  Created on: Oct 20, 2020
 *      Author: OWNER
 */
#ifndef USB30_CH56X_USB30_LIB_H_
#define USB30_CH56X_USB30_LIB_H_
#include "CH56x_common.h"
extern void U30_BUS_RESET();
/**********device status***********/
typedef enum _DEVICE_STATE
{
  UNCONNECTED,
  ATTACHED,
  POWERED,
  SUSPENDED,
  ADDRESSED,
  CONFIGURED
} DEVICE_STATE;
/*********************/
typedef union
{
  UINT16 w;
  struct BW
  {
    UINT8 bb1; //ֽ
    UINT8 bb0;
  }
  bw;
} UINT16_UINT8;
/**********standard request command***********/
typedef struct __PACKED
{
    UINT8  bRequestType;
    UINT8  bRequest;
    UINT16_UINT8 wValue;
    UINT16_UINT8 wIndex;
    UINT16 wLength;
} *PUSB_SETUP;

#define ENDP0_MAXPACK       512

// status response
#define NRDY             0
#define ACK              0x01
#define STALL            0x02
#define INVALID             0x03

// number of NUMP
#define NUMP_0              0x00
#define NUMP_1              0x01
#define NUMP_2              0x02
#define NUMP_3              0x03
#define NUMP_4              0x04
#define NUMP_5              0x05
#define NUMP_6              0x06


/* USB endpoint direction */
#define OUT          0x00
#define IN             0x80
/* USB endpoint serial number */
#define endp_0              0x00
#define endp_1              0x01
#define endp_2              0x02
#define endp_3              0x03
#define endp_4              0x04
#define endp_5              0x05
#define endp_6              0x06
#define endp_7              0x07

#define USB_DESCR_TYP_BOS       0x0f
#define USB_DESCR_UNSUPPORTED   0xffff
#define INVALID_REQ_CODE 0xFF
/* string descriptor type */
#ifndef USB_DESCR_STRING
#define USB_DESCR_LANGID_STRING    0x00
#define USB_DESCR_VENDOR_STRING    0x01
#define USB_DESCR_PRODUCT_STRING   0x02
#define USB_DESCR_SERIAL_STRING    0x03
#define USB_DESCR_OS_STRING        0xee
#endif
/*******************************************************************************1
* Function Name  : USB30_initDevice
* Description    : USB3.0 Deviceʼ
* Input          : None
* Return         : None
*******************************************************************************/
extern UINT32 USB30_initDevice(void);

/*******************************************************************************2
* Function Name  : USB30_initLIB
* Description    : USB3.0 Deviceӳʼ
* Input          : None
* Return         : None
*******************************************************************************/
extern void USB30_initLIB(void);

/*******************************************************************************4
* Function Name  : USB30_setISOEndp
* Description    : ͬ˵
* Input          : num˵    λ򣬵λΪ˵
*                  Statusenable or disable
* Return         : None
*******************************************************************************/
extern void USB30_setISOEndp(UINT8 num,FunctionalState Status );


/*******************************************************************************6
* Function Name  : USB30_getRxCount
* Description    : ȡ˵ݳ
* Input          : endp˵      nump˵ܹյݰ
*                  len:˵յĳȣͻʾ˵һݳ
* Return         : None
*******************************************************************************/
extern void USB30_getRxCount(UINT8 endp,UINT8 *nump,UINT16 *len,UINT8 *status);

/*******************************************************************************7
* Function Name  : USB30_setRxCtrl
* Description    : ˵
* Input          : endpҪõĶ˵
*                  status
*                  nump: ˵ܽյݰĸ
* Return         : None
*******************************************************************************/
extern void USB30_setRxCtrl(UINT8 endp,UINT8 status,UINT8 nump);

/*******************************************************************************7
* Function Name  : USB30_ClearIT_RxCtrl
* Description    : OUTж,к
* Input          : endpҪõĶ˵
* Return         : None
*******************************************************************************/
extern void USB30_ClearIT_RxCtrl(UINT8 endp);

/*******************************************************************************7
* Function Name  : USB30_ClearPendingIT_RxCtrl
* Description    : OUTжϣ˵
* Input          : endpҪõĶ˵
* Return         : None
*******************************************************************************/
extern void USB30_ClearPendingIT_RxCtrl(UINT8 endp);

/*******************************************************************************7
* Function Name  : USB30_GetRx_ITStatus
* Description    : ȡOUTжϱ־
* Input          : endpҪõĶ˵
* Return         : 1:ж 0:ж
*******************************************************************************/
extern UINT8 USB30_GetRx_ITStatus(UINT8 endp);

/*******************************************************************************7
* Function Name  : USB30_RxCtrl_Status
* Description    : OUT˵״̬
* Input          : endpҪõĶ˵
*                  statusACK_TP,NRDY_TP,STALL,INVALID
* Return         : None
*******************************************************************************/
extern void USB30_RxCtrl_Status(UINT8 endp,UINT8 status);

/*******************************************************************************8
* Function Name  : USB30_setTxCtrl
* Description    : ˵㷢
* Input          : endp˵     status
*                  nump: ˵ܷ͵ݰĸ
*                  TxLen˵㷢ݳ
* Return         : None
*******************************************************************************/
extern void USB30_setTxCtrl(UINT8 endp,FunctionalState lpf,UINT8 status,UINT8 nump,UINT16 TxLen);

/*******************************************************************************8
* Function Name  : USB30_ClearPendingIT_TxCtrl
* Description    : INжϣ˵
* Input          : endp˵
* Return         : None
*******************************************************************************/
extern void USB30_ClearPendingIT_TxCtrl(UINT8 endp);

/*******************************************************************************8
* Function Name  : USB30_ClearIT_TxCtrl
* Description    : INж˵״̬к
* Input          : endp˵
* Return         : None
*******************************************************************************/
extern void USB30_ClearIT_TxCtrl(UINT8 endp);

/*******************************************************************************7
* Function Name  : USB30_GetTx_ITStatus
* Description    : ȡINжϱ־
* Input          : endpҪõĶ˵
* Return         : None
*******************************************************************************/
extern UINT8 USB30_GetTx_ITStatus(UINT8 endp);

/*******************************************************************************7
* Function Name  : USB30_GetTx_ITStatus
* Description    : IN˵״̬
* Input          : endpҪõĶ˵
* Return         : None
*******************************************************************************/
extern void USB30_TxCtrl_Status(UINT8 endp,UINT8 status);

/*******************************************************************************9
* Function Name  : USB30_getTxNump
* Description    : ȡͳ
* Input          : endp˵
* Return         : ͳȣͻһݳ
*******************************************************************************/
extern UINT8 USB30_getTxNump(UINT8 endp);

/*******************************************************************************10
* Function Name  : USB30_setFCCTRL
* Description    : ˵
* Input          : endp˵   λ򣬵λΪ˵
*                  nump:˵ջ͵ݰ
* Return         : None
*******************************************************************************/
extern void USB30_send_ERDY(UINT8 endp,UINT8 nump);

/*******************************************************************************11
* Function Name  : set_device_address
* Description    : 豸ַ
* Input          : addressҪõĵַ
* Return         : None
*******************************************************************************/
extern void set_device_address( UINT32 address );

/*******************************************************************************13
* Function Name  : USB30_enableITP
* Description    : USB ITPʹ
* Input          : Statusenable/disable
* Return         : None
*******************************************************************************/
extern void USB30_enableITP(FunctionalState Status);

/*******************************************************************************14
* Function Name  : USB30_usbssIRQHandler
* Description    : USB3.0жϴ
* Input          : None
* Return         : None
*******************************************************************************/
extern void USB30_usbssIRQHandler();

/*******************************************************************************15
* Function Name  : USB30_StandardReq
* Description    : USB豸ģʽ׼
* Input          : None
* Return         : 豸͵ݳ
*******************************************************************************/
extern UINT16 USB30_StandardReq();

/*******************************************************************************16
* Function Name  : USB30_NonStandardReq
* Description    : USB豸ģʽǱ׼
* Input          : None
* Return         : 豸͵ݳ
*******************************************************************************/
extern UINT16 USB30_NonStandardReq();

/*******************************************************************************17
* Function Name  :  EP0_IN_Callback
* Description    : ˵0 INɻص
* Input          : None
* Return         : һINӦ͵ݳ
*******************************************************************************/
extern UINT16 EP0_IN_Callback();

/*******************************************************************************18
* Function Name  : EP0_OUT_Callback
* Description    : ˵0 OUTɻص
* Input          : None
* Return         : 0
*******************************************************************************/
extern UINT16 EP0_OUT_Callback();

/*******************************************************************************19
* Function Name  : USB30_SetupStatus
* Description    : ƴ״̬׶
* Input          : None
* Return         : None
*******************************************************************************/
extern void USB30_SetupStatus();

/*******************************************************************************20
* Function Name  : ITP_Callback
* Description    : ITPص
* Input          : None
* Return         : None
*******************************************************************************/
extern void  ITP_Callback(UINT32 ITPCounter);

/*******************************************************************************21
* Function Name  : set_ISO_delay( UINT32 dly )
* Description    : ͬӳʱ
* Input          : dlyӳʱ
* Return         : None
*******************************************************************************/
extern void set_ISO_delay( UINT32 dly );


extern void switch_pwr_mode( UINT8 pwr_mode );
/*******************************************************************************22
* Function Name  : EPn_IN_Callback()
* Description    : ˵n INص
* Input          : None
* Return         : None
*******************************************************************************/
extern void  EP1_IN_Callback();
extern void  EP2_IN_Callback();
extern void  EP3_IN_Callback();
extern void  EP4_IN_Callback();
extern void  EP5_IN_Callback();
extern void  EP6_IN_Callback();
extern void  EP7_IN_Callback();

/*******************************************************************************23
* Function Name  : EPn_IN_Callback()
* Description    : ˵n OUTص
* Input          : None
* Return         : None
*******************************************************************************/
extern void  EP1_OUT_Callback();
extern void  EP2_OUT_Callback();
extern void  EP3_OUT_Callback();
extern void  EP4_OUT_Callback();
extern void  EP5_OUT_Callback();
extern void  EP6_OUT_Callback();
extern void  EP7_OUT_Callback();

#endif /* USB30_CH56X_USB30_LIB_H_ */
