/*
 * usb30_callback.c
 *
 *  Created on: Aug 17, 2020
 *      Author: OWNER
 */
#include "CH56x_common.h"
#include "CH56x_USB30_LIB.H"
#include "usb30_porp.h"
#include  "uddisk.h"
#include "USB30.h"
UINT16V reqblocknum = 0;
UINT16V writeblocknum;
UINT8V cswflag=0;
#define BLOCKNUM 180
__attribute__ ((aligned(16))) UINT8 simflash[512*BLOCKNUM] __attribute__((section(".DMADATA"))); //˵0ݷͽջ
#define code_origin 0

void Uinfo_init( void ){

    CSW_PARAMETER[0] = 0x55;   //CSW HEADER
    CSW_PARAMETER[1] = 0x53;
    CSW_PARAMETER[2] = 0x42;
    CSW_PARAMETER[3] = 0x53;

    FORMAT_CAPACITIES.NULL1=0;
    FORMAT_CAPACITIES.NULL2=0;
    FORMAT_CAPACITIES.NULL3=0;
    FORMAT_CAPACITIES.Cap_List_Length=0x08;//б   Ǹֽ֮8ֽ
    FORMAT_CAPACITIES.Block_Num_32_24=0x00;
    FORMAT_CAPACITIES.Block_Num_24_16=0x00;
    FORMAT_CAPACITIES.Block_Num_16_8=0x10;
    FORMAT_CAPACITIES.Block_Num_8_0=0x00;
    FORMAT_CAPACITIES.descriptor_code=0x03;
    FORMAT_CAPACITIES.blocksize24 = (UINT8)(512>>16);
    FORMAT_CAPACITIES.blocksize16 = (UINT8)(512>>8);
    FORMAT_CAPACITIES.blocksize8  = (UINT8)(512);

    READ_CAPACITY.maxblock32 =(UINT8)(  BLOCKNUM>>24  );      //߼ַ
    READ_CAPACITY.maxblock24 = (UINT8)( BLOCKNUM>>16  );
    READ_CAPACITY.maxblock16 = (UINT8)( BLOCKNUM>>8  );
    READ_CAPACITY.maxblock8 = (UINT8)(  BLOCKNUM  );

    READ_CAPACITY.blocksize32 = (UINT8)(512>>24);      //߼С
    READ_CAPACITY.blocksize24 = (UINT8)(512>>16);
    READ_CAPACITY.blocksize16 = (UINT8)(512>>8);
    READ_CAPACITY.blocksize8  = (UINT8)(512);


}


void Ucsw(UINT8 sta){
    CSW_PARAMETER[12] = sta;
    USB30_ClearIT_TxCtrl( endp_1 );
    USBSS->UEP1_TX_DMA  = (UINT32)(UINT8 *)( CSW_PARAMETER );  //޸DMAָ
    USB30_setTxCtrl( endp_1 ,ENABLE, ACK , 1 , 13 );
    USB30_send_ERDY( endp_1 | IN , 1 );
}
 /***************Endpointn IN Transaction Processing*******************/
void EP1_IN_Callback()
{
    uint16_t s,i;
//    printf("IN\n");
    USB30_ClearIT_TxCtrl( endp_1 );
    if(cswflag){    cswflag = 0;    Ucsw(0);    }
    else{
        USB30_ClearIT_RxCtrl(endp_2);
        USB30_setRxCtrl( endp_2 , ACK , 1 );  //ܹ4
        USB30_send_ERDY( endp_2 | OUT , 1 );             //֪ͨȡ4
    }

}


void write_start( UINT16 pReqnum, UINT32 Lbaaddr){
    UINT8 cnt=0;
    UINT32 ramaddr;

    if(pReqnum == 1){
        USBSS->UEP2_RX_DMA = (UINT32)(UINT8 *)( simflash+ Lbaaddr*512);  //޸DMAָ
        USB30_setRxCtrl(endp_2,ACK,1);
        USB30_send_ERDY( endp_2 | OUT, 1 );
        while(!USB30_GetRx_ITStatus(endp_2));
        USB30_ClearIT_RxCtrl( endp_2 );
        USBSS->UEP2_RX_DMA = (UINT32)(UINT8 *)( endp0buff );  //USBʼַ
    }
    else{
        ramaddr =   (UINT32)((UINT32)(512*Lbaaddr)+(UINT32)simflash);
        USBSS->UEP2_RX_DMA = (UINT32)(UINT8 *)( ramaddr);  //޸DMAָ
        USB30_setRxCtrl(endp_2,ACK,1);
        USB30_send_ERDY( endp_2 | OUT, 1 );
        cnt+=2;
        while( 1 )
        {
            if(     USB30_GetRx_ITStatus(endp_2)  ){  //usB
                if((pReqnum-cnt)>1){
                    USB30_ClearIT_RxCtrl( endp_2 );
                    USBSS->UEP2_RX_DMA = (UINT32)(UINT8 *)( ramaddr + cnt*512 );  //޸DMAָ
                    USB30_setRxCtrl(endp_2,ACK,1);
                    USB30_send_ERDY( endp_2 | OUT, 1 );
                    cnt+=2;
                }
                else if((pReqnum-cnt)==1){
                    USB30_ClearIT_RxCtrl( endp_2 );
                    USBSS->UEP2_RX_DMA = (UINT32)(UINT8 *)( ramaddr + cnt*512 );  //޸DMAָ
                    USB30_setRxCtrl(endp_2,ACK,1);
                    USB30_send_ERDY( endp_2 | OUT, 1 );
                    cnt+=1;
                }
                else{
                    USB30_ClearIT_RxCtrl( endp_2 );
                    USBSS->UEP2_RX_DMA = (UINT32)(UINT8 *)( endp0buff );  //USBʼַ
                    break;
                }
            }
        }
    }
}


void read_start( UINT16 pReqnum, UINT32 Lbaaddr){
    UINT8 cnt=0;
    UINT32 ramaddr;

    if(pReqnum == 1){
        USBSS->UEP1_TX_DMA = (UINT32)(UINT8 *)( simflash+ Lbaaddr*512);  //޸DMAָ
        USB30_setTxCtrl(endp_1,ENABLE,ACK,1,512);
        USB30_send_ERDY( endp_1 | IN, 1 );
        while(!USB30_GetTx_ITStatus(endp_1));
        USB30_ClearIT_TxCtrl( endp_1 );
        USBSS->UEP1_TX_DMA = (UINT32)(UINT8 *)( endp0buff );  //USBʼַ
    }
    else{
        ramaddr =   (UINT32)((UINT32)(512*Lbaaddr)+(UINT32)simflash);
        USBSS->UEP1_TX_DMA = (UINT32)(UINT8 *)( ramaddr);  //޸DMAָ
        USB30_setTxCtrl(endp_1,ENABLE,ACK,1,1024);
        USB30_send_ERDY( endp_1 | IN, 1 );
        cnt+=2;
        while( 1 )
        {
            if(     USB30_GetTx_ITStatus(endp_1)  ){  //usB
                if((pReqnum-cnt)>1){
                    USB30_ClearIT_TxCtrl( endp_1 );
                    USBSS->UEP1_TX_DMA = (UINT32)(UINT8 *)( ramaddr + cnt*512 );  //޸DMAָ
                    USB30_setTxCtrl(endp_1,ENABLE,ACK,1,1024);
                    USB30_send_ERDY( endp_1 | IN, 1 );
                    cnt+=2;
                }
                else if((pReqnum-cnt)==1){
                    USB30_ClearIT_TxCtrl( endp_1 );
                    USBSS->UEP1_TX_DMA = (UINT32)(UINT8 *)( ramaddr + cnt*512 );  //޸DMAָ
                    USB30_setTxCtrl(endp_1,ENABLE,ACK,1,512);
                    USB30_send_ERDY( endp_1 | IN, 1 );
                    cnt+=1;
                }
                else{
                    USB30_ClearIT_TxCtrl( endp_1 );
                    USBSS->UEP1_TX_DMA = (UINT32)(UINT8 *)( endp0buff );  //USBʼַ
                    break;
                }
            }
        }
    }
}




void EP2_OUT_Callback()
{
    UINT16 len;
    UINT32 LBAaddr;

    USB30_ClearIT_RxCtrl(endp_2);  //OUTж
    USBSS->UEP2_RX_DMA = (UINT32)(UINT8 *)( endp0buff );  //޸DMAָ

    if(*(UINT32 *)endp0buff == 0x43425355){   //CBW
       *(uint32_t *)&CSW_PARAMETER[4]   = *(uint32_t *)&endp0buff[4];//ֵCSWУ
       printf("cbw:%02X\n",endp0buff[0xf]);
       switch(endp0buff[0xf]){  //жSCSI
           case 0x2a:  //д
                LBAaddr=(endp0buff[0xf+2]<<24)|(endp0buff[0xf+3]<<16)|(endp0buff[0xf+4]<<8)|(endp0buff[0xf+5]);
                writeblocknum=(endp0buff[0xf+7]<<8)|(endp0buff[0xf+8]);
                printf("LBA:%08x\n",LBAaddr);
                printf("Wnum:%d\n",writeblocknum);
                PFIC_DisableIRQ(USBSS_IRQn);
                write_start(writeblocknum, LBAaddr);  //Ҫдcmd
                PFIC_EnableIRQ(USBSS_IRQn);       //enable USBSS interrupt
                len=0;   //csw
                break;
            case 0x28:   //
                LBAaddr=(endp0buff[0xf+2]<<24)|(endp0buff[0xf+3]<<16)|(endp0buff[0xf+4]<<8)|(endp0buff[0xf+5]);
                reqblocknum=(endp0buff[0xf+7]<<8)|(endp0buff[0xf+8]);
                printf("LBA:%08X\n",LBAaddr);
                printf("RNUM:%d\n",reqblocknum);
                PFIC_DisableIRQ(USBSS_IRQn);       //رж
                read_start(reqblocknum, LBAaddr);
                PFIC_EnableIRQ(USBSS_IRQn);        //ж
                len=0;    //csw
                break;
            case 0x12:
                if(endp0buff[0xf+4]==0x24){
                    memcpy(endp0buff, (uint8_t *)INQUIRY1,36 );
                    len=36;
                }
                else if(endp0buff[0xf+4]==0x38){
                    memcpy(endp0buff, (uint8_t *)s1238,56 );
                    len=56;
                }
                else if(endp0buff[0xf+4]==0x40){
                   memcpy(endp0buff, (uint8_t *)INQUIRY1,0x40 );
                   len=0x40;
               }
                else if(endp0buff[0xf+4]==0x2f){
                    memcpy(endp0buff, (uint8_t *)LONG_INQUIRY,255 );
                    len=0x2f;
                }
                else{
                    memcpy(endp0buff, (uint8_t *)LONG_INQUIRY,255 );
                    len=255;
                }
                cswflag = 1;
                break;
            case 0x23:
                memcpy(endp0buff, (uint8_t *)&FORMAT_CAPACITIES,12 );
                len=12;
                cswflag = 1;
                break;
            case 0x25:
                memcpy(endp0buff, (uint8_t *)&READ_CAPACITY,8 );
                len=8;
                cswflag = 1;
                break;
            case 0x1a:
                if(endp0buff[0xf+2]==0x3f){
                    memcpy(endp0buff, (uint8_t *)s1a03,36 );
                    len=36;
                }
                else{
                    *(uint32_t *)endp0buff= 0x00000003;
                    len=4;
                }
                cswflag = 1;
                break;
            case 0x00:
                len=0;
                break;
            case 0x35:
                len=0;
                break;
            case 0x1E:
                len=0;
                break;
            case 0x03:
                memcpy(endp0buff, (uint8_t *)s03,18 );
                len=18;
                cswflag = 1;
                break;

        }
          if(len){
              USBSS->UEP1_TX_DMA = (UINT32)(UINT8 *)( endp0buff );  //޸DMAָ
              USB30_setTxCtrl( endp_1 ,ENABLE, ACK , 1 , len );
              USB30_send_ERDY( endp_1 | IN , 1 );             //֪ͨȡ4
          }
          else{
              Ucsw(0);
          }
    }
    else{//Ӧе
        printf("errr\n");
    }

}
void EP3_OUT_Callback()
{
	;
}
void EP4_OUT_Callback()
{
	;
}
void EP5_OUT_Callback()
{
    ;
}
void EP6_OUT_Callback()
{
	;
}
void EP7_OUT_Callback()
{
	;
}
void EP2_IN_Callback()
{

  ;
}

void EP3_IN_Callback()
{

   ;
}
void EP4_IN_Callback()
{
    ;
}
void EP5_IN_Callback()
{

    ;
}
void EP6_IN_Callback()
{
    ;
}
void EP7_IN_Callback()
{
   ;
}

/***************Endpointn OUT Transaction Processing*******************/
void EP1_OUT_Callback()
{
    ;
}
void  ITP_Callback(UINT32 ITPCounter)
{

}
