/*
 * usb30_porp.c
 *
 *  Created on: Aug 17, 2020
 *      Author: OWNER
 */
#include "CH56x_common.h"
#include "usb30_porp.h"
#include "usb30_desc.h"
#include "CH56x_USB30_LIB.H"
#include "USB30.h"
__attribute__ ((aligned(16))) UINT8	endp0buff[512] __attribute__((section(".DMADATA"))); //˵0ݷͽջ
//__attribute__ ((aligned(16))) UINT8	endp1RTbuff[MAX_BUF_BLOCK*512] __attribute__((section(".DMADATA"))); //˵1ݷͻ
//__attribute__ ((aligned(16))) UINT8	endp2RTbuff[MAX_BUF_BLOCK*512] __attribute__((section(".DMADATA"))); //˵2ݷͻ

#define UsbSetupBuf     ((PUSB_SETUP)endp0buff)//˵0

/*******************************************************************************
* Function Name  : USB30D_init
* Description    : USB3.0豸ʼ
* Input          : None
* Return         : None
*******************************************************************************/
void USB30D_init(FunctionalState sta) {
    UINT16 i;
    if (sta) {
        USB30_initDevice();

        USBSS->UEP0_DMA     = (UINT32)(UINT8 *)endp0buff;
        USBSS->UEP1_TX_DMA  = (UINT32)(UINT8 *)endp0buff;
        USBSS->UEP2_TX_DMA  = (UINT32)(UINT8 *)endp0buff;

        USBSS->UEP1_RX_DMA  = (UINT32)(UINT8 *)endp0buff;
        USBSS->UEP2_RX_DMA  = (UINT32)(UINT8 *)endp0buff;


        USBSS->UEP_CFG = EP0_R_EN | EP0_T_EN | EP1_R_EN | EP1_T_EN | EP2_R_EN | EP2_T_EN | EP3_R_EN | EP3_T_EN
                       | EP4_R_EN | EP4_T_EN | EP5_R_EN | EP5_T_EN | EP6_R_EN | EP6_T_EN | EP7_R_EN | EP7_T_EN;// set end point rx/tx enable

        USB30_setRxCtrl(endp_1, ACK, NUMP_4);    // endpoint1 receive setting
        USB30_setRxCtrl(endp_2, ACK, NUMP_4);
    }
    else {
        switch_pwr_mode(POWER_MODE_3);
        USBSS->LINK_CFG = PIPE_RESET | LFPS_RX_PD;
        USBSS->LINK_CTRL = GO_DISABLED | POWER_MODE_3;
        USBSS->LINK_INT_CTRL = 0;
        USBSS->USB_CONTROL = USB_FORCE_RST | USB_ALL_CLR;
    }
}

static	UINT32		SetupLen=0;
static 	UINT8		SetupReqCode = 0;
static	PUINT8		pDescr;
//static	UINT8     UsbConfig=0;
/******************NonStandard Request Command Process****************************/
UINT16 USB30_NonStandardReq()
{
		SetupReqCode = UsbSetupBuf->bRequest;
		SetupLen = UsbSetupBuf->wLength;
		UINT16 len = 0;
//		printf("0S:%x %x %x %x\n",UsbSetupBuf->bRequestType,SetupReqCode,UsbSetupBuf->wValue.w,UsbSetupBuf->wIndex.bw.bb1);
		switch(SetupReqCode)
		{
		case 0xfe:
		    pDescr = (PUINT8)endp0buff;
		    endp0buff[0]=0;
		    SetupLen = 1;
		    break;
//		 case 0x01:																		//
//			 switch(UsbSetupBuf->wIndex.bw.bb1)
//			 {
//				 case 0x04:																//
//					if(SetupLen>SIZE_CompactId) SetupLen  = SIZE_CompactId;
//					pDescr = (PUINT8)CompactId;
//					break;
//				 case 0x06:case 0x09://
//				 case 0x07:
//				   if(SetupLen>SIZE_MSOS20DescriptorSet) SetupLen  = SIZE_MSOS20DescriptorSet;
//				   pDescr = (PUINT8)MSOS20DescriptorSet;
//					break;
//				case 0x08:																//
//
//					break;
//				default:
//					SetupReqCode = INVALID_REQ_CODE;
//					return USB_DESCR_UNSUPPORTED;
//					break;
//			}
//			break;
		 case 0x02:																		//û
			switch(UsbSetupBuf->wIndex.bw.bb1)
			{
				case 0x05:																//
					 if(SetupLen>SIZE_PropertyHeader) SetupLen  = SIZE_PropertyHeader;
					 pDescr = (PUINT8)PropertyHeader;
					 break;
				default:
					SetupReqCode = INVALID_REQ_CODE;
					return USB_DESCR_UNSUPPORTED;
					break;
			}
			break;
		default:
			printf("stall\n");
			SetupReqCode = INVALID_REQ_CODE;
			return USB_DESCR_UNSUPPORTED;
			break;
		}
		len = SetupLen >= ENDP0_MAXPACK ? ENDP0_MAXPACK : SetupLen;// δ䳤
		memcpy(endp0buff, pDescr,len );		// device  /* ϴ */
		SetupLen -= len;
		pDescr += len;
		return len;
}
/******************Standard Request Command Process****************************/
UINT16 USB30_StandardReq()
{
	SetupReqCode = UsbSetupBuf->bRequest;
	SetupLen = UsbSetupBuf->wLength;
	UINT16 len = 0;
//	printf("S:%x %x %x\n",UsbSetupBuf->bRequestType,SetupReqCode,SetupLen);
	switch(SetupReqCode)
	{
			case USB_GET_DESCRIPTOR:
				switch(UsbSetupBuf->wValue.bw.bb0)
				{
						case USB_DESCR_TYP_DEVICE:
								if(SetupLen>SIZE_DEVICE_DESC) SetupLen  = SIZE_DEVICE_DESC;
								pDescr = (PUINT8)DeviceDescriptor;
								break;
						case	USB_DESCR_TYP_CONFIG:
								if(SetupLen > SIZE_CONFIG_DESC) SetupLen = SIZE_CONFIG_DESC;
								pDescr = (PUINT8)ConfigDescriptor;
								break;
						case USB_DESCR_TYP_BOS:
								if(SetupLen > SIZE_BOS_DESC) SetupLen = SIZE_BOS_DESC;
								pDescr = (PUINT8)BOSDescriptor;
								break;
						case 	USB_DESCR_TYP_STRING:
								switch(UsbSetupBuf->wValue.bw.bb1)
								{
								case USB_DESCR_LANGID_STRING:
									if(SetupLen > SIZE_STRING_LANGID) SetupLen = SIZE_STRING_LANGID;
									pDescr = (PUINT8)StringLangID;
									break;
								case USB_DESCR_VENDOR_STRING:
									if(SetupLen > SIZE_STRING_VENDOR) SetupLen = SIZE_STRING_VENDOR;
									pDescr = (PUINT8)StringVendor;
									break;
								case USB_DESCR_PRODUCT_STRING:
									if(SetupLen > SIZE_STRING_PRODUCT) SetupLen = SIZE_STRING_PRODUCT;
									pDescr = (PUINT8)StringProduct;
									break;
								case USB_DESCR_SERIAL_STRING:
									if(SetupLen > SIZE_STRING_SERIAL) SetupLen = SIZE_STRING_SERIAL;
								    pDescr = (PUINT8)StringSerial;
									break;
								case USB_DESCR_OS_STRING:
									if(SetupLen >SIZE_STRING_OS) SetupLen = SIZE_STRING_OS;
									pDescr = (PUINT8)OSStringDescriptor;
									break;
								default:
									len = USB_DESCR_UNSUPPORTED;								//ֵ֧
									SetupReqCode = INVALID_REQ_CODE;							//Ч
									break;
								}
								break;
						default:
							len = USB_DESCR_UNSUPPORTED;//ֵ֧
							SetupReqCode = INVALID_REQ_CODE;
							break;
				}
				len = SetupLen >= ENDP0_MAXPACK ? ENDP0_MAXPACK : SetupLen;					 // δ䳤
				memcpy(endp0buff, pDescr,len );												 // device  /* ϴ */
				SetupLen -= len;
				pDescr += len;
				break;
			case USB_SET_ADDRESS:
						SetupLen = UsbSetupBuf->wValue.bw.bb1;  							// ݴUSB豸ַ
						break;
			case 0x31:
			            SetupLen = UsbSetupBuf->wValue.bw.bb1;                              // ݴUSB豸ַ////
						break;
			case 0x30:

						break;
			case USB_SET_CONFIGURATION:
						break;
			case USB_GET_STATUS:
						len=2;
						endp0buff[0]=0x01;
						endp0buff[1]=0x00;
						SetupLen = 0;
						break;
			case USB_CLEAR_FEATURE:
						break;
			case USB_SET_FEATURE:
						break;
			case USB_SET_INTERFACE:
						break;
			default:
					len =USB_DESCR_UNSUPPORTED;										//stallֵ֧
					SetupReqCode = INVALID_REQ_CODE;
					printf(" stall \n");
						break;
			}
	return len;
}
/******************IN Transaction Response for Endpoint0 ****************************/
UINT16 EP0_IN_Callback(void)
{

	UINT16 len = 0;
	switch(SetupReqCode)
	{
		case USB_GET_DESCRIPTOR:
			 len = SetupLen >= ENDP0_MAXPACK ? ENDP0_MAXPACK : SetupLen;
			 memcpy(  endp0buff, pDescr,len );
			 SetupLen -= len;
			 pDescr += len;
			 break;
	}
	return len;
}
/******************OUT Transaction  Response for Endpoint0 ****************************/
UINT16 EP0_OUT_Callback()
{
	return 0;
}
/******************Status Stage ****************************/
void USB30_SetupStatus( void)
{
//    printf("s\n");
	switch(SetupReqCode)
	{
		case USB_SET_ADDRESS:
			 set_device_address(SetupLen );// SET ADDRESS
			 break;
		case 0x31:
		    break;
		    //set_ISO_delay(SetupLen);
	}
}
