/********************************** (C) COPYRIGHT *******************************
* File Name          : Main.c
* Author             : WCH
* Version            : V1.0
* Date               : 2020/07/31
* Description 		 : 
*******************************************************************************/
#include "CH56x_common.h"
#include "CH56x_USB30_LIB.h"
#include "usb30_porp.h"
#include "USB30.h"
#include "usbhs.h"
#include "usb_des.h"

#define	UART1_BAUD	921600
UINT8V tx_lmp_port = 0;

UINT8V trans_err_flag = 0;
UINT8V link_sta = 0  ;
extern void Uinfo_init( void );        //UϢʼ
void USBSS_IRQHandler (void) __attribute__((interrupt("WCH-Interrupt-fast")));			//TMR0 interrupt service
void LINK_IRQHandler (void)  __attribute__((interrupt("WCH-Interrupt-fast")));		//TMR1 interrupt service
//void USBHS_IRQHandler(void) __attribute__((interrupt("WCH-Interrupt-fast")));
void TMR0_IRQHandler(void)  __attribute__((interrupt("WCH-Interrupt-fast")));
//extern void USBHSsss(void);
extern void USB20_dev_init ( FunctionalState sta ); // @suppress("Type cannot be resolved")



//extern void read_start(PSD_PARAMETER pEMMCPara, UINT16 pReqnum, PUINT8 pRdatbuf, UINT32 Lbaaddr);
/*******************************************************************************
* Function Name  : DebugInit
* Description    : Initializes the UART1 peripheral.
* Input          : baudrate: UART1 communication baud rate.
* Return         : None
*******************************************************************************/
void DebugInit(UINT32 baudrate)
{
	UINT32 x;
	UINT32 t = FREQ_SYS;
	x = 10 * t * 2 / 16 / baudrate;
	x = ( x + 5 ) / 10;
	R8_UART1_DIV = 1;
	R16_UART1_DL = x;
	R8_UART1_FCR = RB_FCR_FIFO_TRIG | RB_FCR_TX_FIFO_CLR | RB_FCR_RX_FIFO_CLR | RB_FCR_FIFO_EN;
	R8_UART1_LCR = RB_LCR_WORD_SZ;
	R8_UART1_IER = RB_IER_TXD_EN;
	R32_PA_SMT |= (1<<8) |(1<<7);
	R32_PA_DIR |= (1<<8);

    R8_UART0_DIV = 1;
    R16_UART0_DL = x;
    R8_UART0_FCR = RB_FCR_FIFO_TRIG | RB_FCR_TX_FIFO_CLR | RB_FCR_RX_FIFO_CLR | RB_FCR_FIFO_EN;
    R8_UART0_LCR = RB_LCR_WORD_SZ;
    R8_UART0_IER = RB_IER_TXD_EN;
    R32_PA_SMT |= (1<<8) |(1<<7);
    R32_PA_DIR |= (1<<8);
    GPIOB_ModeCfg( GPIO_Pin_6, GPIO_Slowascent_PP_8mA );
}

/*******************************************************************************
* Function Name  : main
* Description    : Main program.
* Input          : None
* Return         : None
*******************************************************************************/
int main()
{
    UINT16 s;
	SystemInit(FREQ_SYS);
	Delay_Init(FREQ_SYS);

/* ôڵ */
	DebugInit(UART1_BAUD);
	printf("Udisk Program(120MHz) !\n");

    Uinfo_init(  );

	R32_USB_CONTROL = 0;
	PFIC_EnableIRQ(USBSS_IRQn);
    PFIC_EnableIRQ(LINK_IRQn);
    PFIC_EnableIRQ(TMR0_IRQn);
    R8_TMR0_INTER_EN = 1;
    TMR0_TimerInit( 67000000 );   //Լ0.5
    USB30D_init(ENABLE);          //USB3.0ʼʼ֮ǰȷUSB3.0жʹ

	while(1);
}

/*******************************************************************************
* Function Name  : TMR0_IRQHandler
* Description    : USB3.0ʧܳʱ
* Input          : None
* Return         : None
*******************************************************************************/
void TMR0_IRQHandler(){
//    printf("link_ov\n");

    R8_TMR0_INTER_EN |= 1;
    PFIC_DisableIRQ(TMR0_IRQn);
    R8_TMR0_CTRL_MOD = RB_TMR_ALL_CLEAR;
    if(link_sta == 1 ){
        link_sta =0;
        PFIC_DisableIRQ(USBSS_IRQn);
        PFIC_DisableIRQ(LINK_IRQn);
        USB30D_init(DISABLE);
        return;
    }
    if(link_sta != 3){
        PFIC_DisableIRQ(USBSS_IRQn);
        PFIC_DisableIRQ(LINK_IRQn);
        USB30D_init(DISABLE);
        PRINT("USB2.0\n");
        R32_USB_CONTROL = 0;
        PFIC_EnableIRQ(USBHS_IRQn);
        USB20_dev_init(ENABLE);
    }
    link_sta=1;
    return;
}


/*******************************************************************************
* Function Name  : U30_BUS_RESET
* Description    : USB3.0߸λѡλʽֻλUSBķʽ⣬ԲøλƬķʽ
* Input          : None
* Return         : None
*******************************************************************************/
void U30_BUS_RESET( ){
//ʽ1   λUSB3.0
    USB30D_init(DISABLE);  //USB3.0ʼ
    mDelaymS(30);
    USB30D_init(ENABLE);  //USB3.0ʼ
//ʽ2   ֱӸλƬ
//    R8_SAFE_ACCESS_SIG = 0x57; // enable safe access mode
//    R8_SAFE_ACCESS_SIG = 0xa8;
//    R8_RST_WDOG_CTRL = 0x40 | RB_SOFTWARE_RESET;
}

/*******************************************************************************
* Function Name  : LINK_IRQHandler
* Description    : USB3.0 Link Interrupt Handler.
* Input          : None
* Return         : None
*******************************************************************************/
void LINK_IRQHandler (void)	          //USBSS link interrupt service
{
    UINT32 temp;
    temp = USBSS->LINK_ERR_STATUS;
    if( USBSSH->LINK_INT_FLAG & LINK_INACT_FLAG )
    {
        USBSSH->LINK_INT_FLAG = LINK_INACT_FLAG;
        switch_pwr_mode(POWER_MODE_2);
        printf("link inactive, error status = %0x\n", temp>>16);
    }
    else if( USBSS->LINK_INT_FLAG & LINK_DISABLE_FLAG ) // GO DISABLED
    {
        USBSSH->LINK_INT_FLAG = LINK_DISABLE_FLAG;
        USBSS->LINK_CTRL = POWER_MODE_2;// GO RX DETECT
//        printf("go disabled \n");
    }
    else if( USBSSH->LINK_INT_FLAG & LINK_RX_DET_FLAG )
    {
        USBSSH->LINK_INT_FLAG = LINK_RX_DET_FLAG;
        switch_pwr_mode(POWER_MODE_2);
//            printf("LINK_RX_DET_FLAG \n");
    }
    else if( USBSSH->LINK_INT_FLAG & TERM_PRESENT_FLAG ) // term present , begin POLLING
    {
        USBSSH->LINK_INT_FLAG = TERM_PRESENT_FLAG;
        if( USBSS->LINK_STATUS & LINK_PRESENT )
        {
            switch_pwr_mode(POWER_MODE_2);
            USBSSH->LINK_CTRL |= POLLING_EN;
            printf("rx term present!\n\n");
        }
        else
        {
            USBSSH->LINK_INT_CTRL = 0;
            printf("link is disconnect !\n\n");
            mDelayuS(2000);
            U30_BUS_RESET();
        }
    }
    else if( USBSSH->LINK_INT_FLAG & LINK_TXEQ_FLAG ) // POLLING SHAKE DONE
    {
        tx_lmp_port = 1;
        USBSSH->LINK_INT_FLAG = LINK_TXEQ_FLAG;
        switch_pwr_mode(POWER_MODE_0);
        printf("link is tx EQ !\n\n");
    }

    else if( USBSSH->LINK_INT_FLAG & LINK_RDY_FLAG ) // POLLING SHAKE DONE
    {
        printf("LR\n");
        USBSSH->LINK_INT_FLAG = LINK_RDY_FLAG;
        if( tx_lmp_port ) // LMP, TX PORT_CAP & RX PORT_CAP
        {
            USBSS->LMP_TX_DATA0 = LINK_SPEED | PORT_CAP | LMP_HP;
            USBSS->LMP_TX_DATA1 = UP_STREAM | NUM_HP_BUF;
            USBSS->LMP_TX_DATA2 = 0x0;
            tx_lmp_port = 0;
        }
        //ɹUSB3.0ͨѶ
        link_sta = 3;
        PFIC_DisableIRQ(TMR0_IRQn);
        R8_TMR0_CTRL_MOD = RB_TMR_ALL_CLEAR;
        PFIC_DisableIRQ(USBHS_IRQn);
        USB20_dev_init(DISABLE);
    }
    else if( USBSS->LINK_INT_FLAG & WARM_RESET_FLAG )
    {
        printf("RX WARM RESET !\n\n");
        USBSS->LINK_INT_FLAG = WARM_RESET_FLAG;
        switch_pwr_mode(POWER_MODE_2);
        USBSS->LINK_CTRL |= TX_WARM_RESET;
        while( USBSS->LINK_STATUS & RX_WARM_RESET );
        USBSS->LINK_CTRL &= ~TX_WARM_RESET;
        mDelayuS(2);
        U30_BUS_RESET();
        set_device_address( 0 );
    }
    else if( USBSS->LINK_INT_FLAG & HOT_RESET_FLAG )
    {
        USBSS->USB_CONTROL |= 1<<31;
        printf("RX HOT RESET !\n\n");
        USBSS->LINK_INT_FLAG = HOT_RESET_FLAG; // HOT RESET begin
        USBSS->UEP0_TX_CTRL = 0;
        USBSS->UEP0_RX_CTRL = 0;
        USBSS->UEP1_TX_CTRL = 0;
        USBSS->UEP2_TX_CTRL = 0;
        USBSS->UEP3_TX_CTRL = 0;
        USBSS->UEP4_TX_CTRL = 0;
        USBSS->UEP5_TX_CTRL = 0;
        USBSS->UEP6_TX_CTRL = 0;
        USBSS->UEP7_TX_CTRL = 0;
        USBSS->UEP1_RX_CTRL = EP_RES_ACK | USB_NUMP_2;
        USBSS->UEP2_RX_CTRL = EP_RES_ACK | USB_NUMP_2;
        USBSS->UEP3_RX_CTRL = EP_RES_ACK | USB_NUMP_2;
        USBSS->UEP4_RX_CTRL = EP_RES_ACK | USB_NUMP_2;
        USBSS->UEP5_RX_CTRL = EP_RES_ACK | USB_NUMP_2;
        USBSS->UEP6_RX_CTRL = EP_RES_ACK | USB_NUMP_2;
        USBSS->UEP7_RX_CTRL = EP_RES_ACK | USB_NUMP_2;

        set_device_address(0);
        printf("DEVICE INIT !\n\n");
        USBSS->LINK_CTRL &= ~TX_HOT_RESET; // HOT RESET end
    }
    else if( USBSS->LINK_INT_FLAG & LINK_GO_U1_FLAG ) // device enter U1
    {
        switch_pwr_mode(POWER_MODE_1);
        USBSS->LINK_INT_FLAG = LINK_GO_U1_FLAG;
        printf("GO U1 !\n\n");

    }
    else if( USBSS->LINK_INT_FLAG & LINK_GO_U2_FLAG ) // device enter U2
    {
        switch_pwr_mode(POWER_MODE_2);
        USBSS->LINK_INT_FLAG = LINK_GO_U2_FLAG;
        printf("GO U2 !\n\n");
    }
    else if( USBSS->LINK_INT_FLAG & LINK_GO_U3_FLAG ) // device enter U2
    {
        switch_pwr_mode(POWER_MODE_2);
        USBSS->LINK_INT_FLAG = LINK_GO_U3_FLAG;
        printf("GO U3 !\n\n");
    }
    else if( USBSS->LINK_INT_FLAG & LINK_Ux_EXIT_FLAG ) // device enter U2
    {
        USBSS->LINK_CFG = CFG_EQ_EN | DEEMPH_CFG | TERM_EN;
        switch_pwr_mode(POWER_MODE_0);
        USBSS->LINK_INT_FLAG = LINK_Ux_EXIT_FLAG;
        printf("BACK TO U0 !\n\n");
    }
}
/*******************************************************************************
* Function Name  : USBSS_IRQHandler
* Description    : USB3.0 Interrupt Handler.
* Input          : None
* Return         : None
*******************************************************************************/
void USBSS_IRQHandler (void)			//USBSS interrupt service
{
	USB30_usbssIRQHandler();
}
