/********************************** (C) COPYRIGHT *******************************
* File Name          : HAL.C
* Author             : MJX
* Version            : V1.00
* Date               : 2020/05/15
* Description        : Ӳײغ   										 
*******************************************************************************/


/******************************************************************************/
/* ͷļ */
#include "MAIN.H"	 															/* ͷļ */

/******************************************************************************/
/*  */		  
UINT8X General_OP_TimeCount = 0x00;                                            /* ͨɨ账ʱ */
UINT8X Key_Press_TimeCount = 0x00;                                             /* ʱʱ */
UINT8X Key_Press_Flag = 0x00;                                                  /* ±־ */

#pragma  NOAREGS

/*******************************************************************************
* Function Name  : System_Init
* Description    : ϵͳʱƵ
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/ 
void System_Init( void )  
{
	/* þƵ */
	SAFE_MOD = 0x55;
	SAFE_MOD = 0xAA;
#if FREQ_SYS == 48000000
	CLOCK_CFG = CLOCK_CFG & ~MASK_SYS_CK_SEL | 0x07;  							/* 48MHz */	
#endif	
#if FREQ_SYS == 32000000	
	CLOCK_CFG = CLOCK_CFG & ~MASK_SYS_CK_SEL | 0x06;  							/* 32MHz */	
#endif	
#if FREQ_SYS == 24000000		
	CLOCK_CFG = CLOCK_CFG & ~MASK_SYS_CK_SEL | 0x05;  							/* 24MHz */	
#endif
#if FREQ_SYS == 16000000		
	CLOCK_CFG = CLOCK_CFG & ~MASK_SYS_CK_SEL | 0x04; 							/* 16MHz */
#endif	
#if FREQ_SYS == 12000000		
	CLOCK_CFG = CLOCK_CFG & ~MASK_SYS_CK_SEL | 0x03;  							/* 12MHz */	
#endif	
#if FREQ_SYS == 3000000	
	CLOCK_CFG = CLOCK_CFG & ~MASK_SYS_CK_SEL | 0x02;  							/* 3MHz */	
#endif
#if FREQ_SYS == 750000	
	CLOCK_CFG = CLOCK_CFG & ~MASK_SYS_CK_SEL | 0x01;  							/* 750KHz */
#endif
#if FREQ_SYS == 187500	
	CLOCK_CFG = CLOCK_CFG & ~MASK_SYS_CK_SEL | 0x00;  							/* 187.5KHz */	
#endif
	SAFE_MOD = 0x00;
}

/*******************************************************************************
* Function Name  : mDelayuS
* Description    : usʱ
* Input          : nʱֵ
* Output         : None
* Return         : None
*******************************************************************************/ 
void mDelayuS( UINT16 n )  
{
#ifdef	FREQ_SYS
#if		FREQ_SYS <= 6000000
		n >>= 2;
#endif
#if		FREQ_SYS <= 3000000
		n >>= 2;
#endif
#if		FREQ_SYS <= 750000
		n >>= 4;
#endif
#endif
	while ( n ) 
	{  
		// total = 12~13 Fsys cycles, 1uS @Fsys=12MHz
		++ SAFE_MOD;  // 2 Fsys cycles, for higher Fsys, add operation here
#ifdef	FREQ_SYS
#if		FREQ_SYS >= 14000000
		++ SAFE_MOD;
#endif
#if		FREQ_SYS >= 16000000
		++ SAFE_MOD;
#endif
#if		FREQ_SYS >= 18000000
		++ SAFE_MOD;
#endif
#if		FREQ_SYS >= 20000000
		++ SAFE_MOD;
#endif
#if		FREQ_SYS >= 22000000
		++ SAFE_MOD;
#endif
#if		FREQ_SYS >= 24000000
		++ SAFE_MOD;
#endif
#if		FREQ_SYS >= 26000000
		++ SAFE_MOD;
#endif
#if		FREQ_SYS >= 28000000
		++ SAFE_MOD;
#endif
#if		FREQ_SYS >= 30000000
		++ SAFE_MOD;
#endif
#if		FREQ_SYS >= 32000000
		++ SAFE_MOD;
#endif
#if		FREQ_SYS >= 48000000
		++ SAFE_MOD;
		++ SAFE_MOD;
		++ SAFE_MOD;
		++ SAFE_MOD;
		++ SAFE_MOD;
		++ SAFE_MOD;
		++ SAFE_MOD;
		++ SAFE_MOD;
#endif
#endif
		-- n;
	}
}

/*******************************************************************************
* Function Name  : mDelayms
* Description    : mSʱ
* Input          : nʱֵ
* Output         : None
* Return         : None
*******************************************************************************/
void mDelaymS( UINT16 n )  
{
	while( n ) 
	{
		mDelayuS( 1000 );
		--n;
	}
}

/*******************************************************************************
* Function Name  : mInitSTDIO
* Description    : CH5450ʼ,ĬʹT1ʷҲʹT2
*                   -T1UART0ĲʷRCLK=0TCLK=0
*                   -T2UART0ĲʷRCLK=1TCLK=1               
* Input          : None
* Return         : None
*******************************************************************************/
void mInitSTDIO( void )
{
	UINT32 x;
	UINT8 x2; 

	/* 0ʹģʽ1 */
	SM0 = 0;
	SM1 = 1;
	SM2 = 0;                                                                 
	
	/* ʹTimer1Ϊʷ */
	RCLK = 0;                                                                  //UART0ʱ
	TCLK = 0;                                                                  //UART0ʱ
	
	PCON |= SMOD;
	x = 10 * FREQ_SYS / UART0_BUAD / 16;                                       //ƵעxֵҪ                            
	x2 = x % 10;
	x /= 10;
	if(x2 >= 5) x++;                                                       //

	TMOD = TMOD & ~ bT1_GATE & ~ bT1_CT & ~ MASK_T1_MOD | bT1_M1;              //0X20Timer1Ϊ8λԶضʱ
	T2MOD = T2MOD | bTMR_CLK | bT1_CLK;                                        //Timer1ʱѡ
	TH1 = 0-x;                                                                 //12MHz,buad/12Ϊʵò
	TR1 = 1;                                                                   //ʱ1
	TI = 1;
	REN = 1;                                                                   //0ʹ
}