/********************************** (C) COPYRIGHT *******************************
* File Name          : MAIN.C
* Author             : WCH
* Version            : V1.00
* Date               : 2022/05/14
* Description        : CH545豸,USBX轫궨DEF_USE_USBX1
*******************************************************************************/


/******************************************************************************/
/* ͷļ */	
#include "MAIN.H"	 															/* ͷļ */
#include "stdlib.h"

/******************************************************************************/
/*  */
UINT8XV  PCx_NumMax = DEX_USBX_NUM_MAX_4;										/* Զ˿ڸֵ */
UINT8XV  PCx_Connect_Check[ 3 ];			  									/* Զ˿ڵǰ״̬Ĵ */
UINT8XV  PCx_Connect_CheckCount = 0x00; 										/* Զ˿ڵǰ״̬ */
UINT8XV  PCx_Connect_CurStatus = 0x00;											/* Զ˿ڵǰ״̬(λ7-4: ״̬,λ3-0: USBö״̬) */
UINT8XV  PCx_Connect_LastStatus = 0x00;											/* Զ˿һ״̬ */
UINT8XV  PCx_ActionNum = 0x00;													/* ǰĵԶ˿ڱ */
UINT8XV  PCx_PassUSB_ActionNum = 0x00;											/* ǰֱͨUSBڶӦļĵԶ˿ڱ */

UINT8XV  PCx_DevX_Status[ 3 ];                                                  /* ǰ豸Dev0-2״̬ */
UINT8XV  PCx_Dev3_Status = 0x00;												/* ǰֱͨ豸3״̬ */
UINT8XV  PCx_Dev3_ResetFlag = 0x00;												/* ǰֱͨ豸3ڸλ־ */
UINT8XV  PCx_UpInt_TimeCount = 0x00;											/* ж֪ͨʱ */

UINT8XV  PCx_SleepStatus[ DEX_USBX_NUM_MAX_4 ];									/* Զ˿˯״̬ */
UINT8XV  PCx_HubStatus[ DEX_USBX_NUM_MAX_4 ];									/* Զ˿HUB״̬ */
UINT16X  PCx_HubChk_TimeCount[ DEX_USBX_NUM_MAX_4 ];							/* Զ˿HUB״̬ʱ */
UINT8XV  PCx_KBSetReport[ DEX_USBX_NUM_MAX_4 ];									/* Զ˿SetReportֵ */
UINT8XV  PCx_TaskStatus[ DEX_USBX_NUM_MAX_4 ];									/* Զ˿ڴ״̬ */
																				/* λ0: 0:; 1: ֪ͨHUB˿0豸Ҫ; 
																			   	   λ1: 0:; 1: ֪ͨHUB˿1豸Ҫ; 
																			       λ2: 0:; 1: ֪ͨHUB˿2豸Ҫ; */
UINT8XV  PCx_HidUpStatus[ DEX_USBX_NUM_MAX_4 ][ 3 ];							/* Զ˿HID豸ϴ״̬ */
UINT16X  PCx_HidUp_TimeCount[ DEX_USBX_NUM_MAX_4 ][ 3 ];						/* Զ˿HID豸ϴ״̬ʱ */

/*******************************************************************************
* Function Name  : Parameter_Init
* Description    : ʼ
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void Parameter_Init( void ) 
{
	UINT8  i, j;

	/* оƬͺжϵǰ2ڻ4(USB豸()),CH544Ϊ2 */	
	PCx_NumMax = DEX_USBX_NUM_MAX_4;
    if( ( GLOBAL_CFG & 0xC0 ) == 0x80 )
	{
		PCx_NumMax = DEX_USBX_NUM_MAX_2;                        	
	}
    
	PCx_Connect_CurStatus = 0x00;
	PCx_Connect_LastStatus = 0x00;
	PCx_ActionNum = 0x00;
	PCx_PassUSB_ActionNum = 0x00;
    for( i = 0; i < 3; i++ )
    {
        PCx_DevX_Status[ i ] = 0x00;
    }
	PCx_Dev3_Status = 0x00;
	for( i = 0; i < DEX_USBX_NUM_MAX_4; i++ )
	{
		PCx_TaskStatus[ i ] = 0x00;
		PCx_KBSetReport[ i ] = 0x00;
		PCx_HubStatus[ i ] = 0x00;						
		PCx_HubChk_TimeCount[ i ] = 0x00;
		PCx_SleepStatus[ i ] = 0x00;
	}	
	for( i = 0; i < TOTAL_ROOT_HUB; i++ )
	{
		memset( &RootHubDev[ i ].bStatus, 0, sizeof( struct _ROOT_HUB_DEVICE ) );
		RootHubDev[ i ].DeviceIndex = 0xFF;
	}
					
	USBH_ReadyTimer = 0x00;												
	USBH_ResetTimer = 0x00;		
	PCx_UpInt_TimeCount = 0x00;										
	for( i = 0; i < TOTAL_ROOT_HUB; i++ )
	{
		memset( &HostCtl[ i ].InterfaceNum, 0, sizeof( struct __HOST_CTL ) );	
	}
	for( i = 0; i < DEX_USBX_NUM_MAX_4; i++ )
	{
		for( j = 0; j < 3; j++ )
		{
			PCx_HidUpStatus[ i ][ j ] = 0x00;
			PCx_HidUp_TimeCount[ i ][ j ] = 0x00;
		} 		
	}

	USBD_Desc[ 0 ].Base_Offset = 0x00;
	USBD_Desc[ 0 ].Desc_Total = 0x00;
	USBD_Desc[ 1 ].Base_Offset = 0x00;
	USBD_Desc[ 1 ].Desc_Total = 0x00;
    USBD_Desc[ 2 ].Base_Offset = 0x00;
	USBD_Desc[ 2 ].Desc_Total = 0x00;
}									

/*******************************************************************************
* Function Name  : Timer2_Init
* Description    : ʱ2ʼ
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void Timer2_Init( void ) 
{
#define		TIMER_US	1000
	ET2 = 0;
	PT2 = 1;
	T2MOD |= bTMR_CLK | bT2_CLK;
	T2COUNT = RCAP2 = 0x10000 - (UINT16)( ( FREQ_SYS / 1000 * TIMER_US + 1000 / 2 ) / 1000 );
    T2CON = 0;
    TR2 = 1;
	ET2 = 1;
}

#pragma	nomodp2
/*******************************************************************************
* Function Name  : Timer2_Interrupt
* Description    : ʱ2жϷ
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void Timer2_Interrupt( void ) interrupt INT_NO_TMR2 //using 1	
{
	UINT8  num;
	UINT8  i, j;

	TF2 = 0;

    if( USBH_ResetTimer ) 
	{  
		USBH_ResetTimer--;
	}
    
    /* ͨɨ账ʱ */
	General_OP_TimeCount++;
    
	/* ж֪ͨʱ */
	PCx_UpInt_TimeCount++;

	/* USB豸˵ݻȡʱ */
	RootHubDev[ 0 ].bChkTimeCount++;
	RootHubDev[ 1 ].bChkTimeCount++;
	RootHubDev[ 2 ].bChkTimeCount++;
	RootHubDev[ 3 ].bChkTimeCount++;
	for( num = 0; num < TOTAL_ROOT_HUB; num++ )
	{
		if( RootHubDev[ num ].bStatus >= ROOT_DEV_SUCCESS )
		{
			if( RootHubDev[ num ].bType == USB_DEV_CLASS_HID )
			{
			    for( i = 0; i < HostCtl[ num ].InterfaceNum; i++ )
			    {
			        for( j = 0; j < HostCtl[ num ].Interface[ i ].InEndpNum; j++ )
			        {
			            HostCtl[ num ].Interface[ i ].InEndpTimeCount[ j ]++;
			        }       
			    }
			}
		}
	}

	/* HUBö״̬ */
	for( i = 0; i < DEX_USBX_NUM_MAX_4; i++ )
	{
		if( PCx_HubStatus[ i ] )
		{
			PCx_HubChk_TimeCount[ i ]++;
			if( PCx_HubChk_TimeCount[ i ] >= 1000 )
			{
				/* õǰUSBӱ־ */
				PCx_Connect_CurStatus |= 1 << ( i );
				PCx_HubStatus[ i ] = 0;				
			}	
		}		
	}
}

#pragma	modp2

/*******************************************************************************
* Function Name  : main
* Description    : 
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void main( void ) 
{
	UINT8  num;
	UINT8  i,j;
	UINT8  status;

    /* ϵͳʱѡ;ϵʱؼ,Եȴڲȶ */ 
	System_Init( );    																	
	mDelaymS( 10 );                                                            
	
    /* ڳʼ */                                                             
	mInitSTDIO( );
    printf("CH545 4 Hosts and 4 USBX Devices Example\n");
	
    /* ʼ */
    Parameter_Init( );															

 	/* USB豸ʼ */
#if ( DEF_USE_USBX == 0x01 )
	USBX_Device_Init( );
#endif
    
	/* USBʼ */
	USBH_Init( ); 			
	
	/* ʱ2ʼ */
	Timer2_Init( );	
	
    /* ʹж */
	IP_EX |= 0x80;	
	ES = 1;  															
	EA = 1;
    
	while( 1 ) 
	{
        #if ( DEF_USE_USBX == 0x01 )
        /**********************************************************/
		/* ͨл⴦ */
		if( General_OP_TimeCount >= DEF_GENERAL_OP_TIME )
        {
            General_OP_TimeCount = 0x00;
            
            if( PIN_PC_SWITCH == 0x00 )
            {
                mDelayuS( 3 );
                if( PIN_PC_SWITCH == 0x00 )
                {
                    Key_Press_TimeCount++;
                    
                    if( Key_Press_TimeCount >= 3 )
                    {
                        Key_Press_Flag = 1;
                    }
                }
            }
            else
            {
                if( Key_Press_Flag )
                {
                    Key_Press_Flag = 0;
                    
                    /* ֱͨ豸лǰPC */
                    if( ( USB_CTRL & bUC_THROUGH ) || ( PCx_Dev3_Status & BIT_DEV3_IS_PASS ) )
                    {
                        for( i = 0; i < TOTAL_ROOT_HUB; i++ )
                        {
                            if( RootHubDev[ i ].DeviceIndex == 3 )
                            {
                                /* λֱͨ豸 */
                                USB_CTRL &= ~bUC_THROUGH;
                                USBH_ResetRootHubPort( i, 0 ); 
                                
                                /* ֱ֪ͨͨڳ */
                                EA = 0;  
                                USBX_SEL = bUSBX_XSFR_OFS | bUSBX_XRAM_OFS | PCx_PassUSB_ActionNum;  
                                USBH_ResetTimer = 0;
                                USB_CTRL &= ~bUC_THROUGH;
                                USBX_ThisHub_EP1IntUp( 0x01 << ( 3 + 1 ) );  
                                PCx_Dev3_Status = 0x00;   
                                X0DevBitFlag[ 3 ] = BIT_PORT_C_CONN;
                                USBX_SEL = 0;
                                EA = 1;																			
                                break;
                            }
                        }						
                    }
                    
                    /* ѡµPC */
                    PCx_ActionNum++;          
                    if( PCx_ActionNum >= 4 )
                    {
                        PCx_ActionNum = 0;
                    }
                    printf("PCx_ActionNum:%x\n",(UINT16)PCx_ActionNum);
                    
                    PCx_PassUSB_ActionNum = PCx_ActionNum;	
				
                    /* ֱͨµPC */
                    if( ( RootHubDev[ i ].DeviceIndex == 3 ) )
                    {               
                        /*  */
                        PCx_Dev3_Status = BIT_DEV3_IS_PASS | i;  					/* Ϊֱͨ豸 */
                        UH_THROUGH = ( ( PCx_Dev3_Status & BIT_DEV3_ROOT_IDX ) << 2 ) | PCx_PassUSB_ActionNum & MASK_UH_THR_UX;
                        USB_CTRL &= ~bUC_THROUGH;  									/* USBֱֹͨ */							
                        USBX_OneHub_EP1IntUp( PCx_PassUSB_ActionNum, 3, BIT_PORT_CONNECT | BIT_PORT_C_CONN );
                    }
                }
            }
            
			/* ˿ڼ(3һ²Ч,ֻϿ) */
			PCx_Connect_Check[ PCx_Connect_CheckCount ] = P2 & 0x0F;
			PCx_Connect_CheckCount++;
			if( PCx_Connect_CheckCount >= 3 )
			{
				PCx_Connect_CheckCount = 0;
				if( ( PCx_Connect_Check[ 0 ] == PCx_Connect_Check[ 1 ] ) &&
					( PCx_Connect_Check[ 1 ] == PCx_Connect_Check[ 2 ] ) )
				{
					PCx_Connect_CurStatus &= PCx_Connect_Check[ 0 ];	
				}
			}

			/* HIDϴʱʱ */	
			for( i = 0; i < DEX_USBX_NUM_MAX_4; i++ )
			{
				for( j = 0; j < 3; j++ )
				{
					if( PCx_HidUpStatus[ i ][ j ] )
					{
						PCx_HidUp_TimeCount[ i ][ j ]++;

						/* 2.0SȻδϴɹ,˵HID豸쳣,Ҫͨ */
						if( PCx_HidUp_TimeCount[ i ][ j ] >= ( 2000 / DEF_GENERAL_OP_TIME ) )
						{
							PCx_HidUpStatus[ i ][ j ] = 0;
							PCx_HidUp_TimeCount[ i ][ j ] = 0;	
							
							/* øõԶӦĸHID豸Ҫͨ */						
							PCx_TaskStatus[ i ] |= ( 1 << j );	
							printf("PC%x-HID%x-Up\n",(UINT16)i, (UINT16)j);
						}
					}
				} 		
			}
		}

		/* ʱ */
		if( ( USBH_ResetTimer == 0 ) && PCx_Dev3_ResetFlag ) 
		{ 
			PCx_Dev3_ResetFlag = 0;
			printf("PC_RST End\n");

			/* 0 */
			if ( PCx_Dev3_Status & BIT_DEV3_IS_PASS ) 
			{
				USBH_ResetRootHubPort( PCx_Dev3_Status & BIT_DEV3_ROOT_IDX, 2 );  // λ */
				UH_THROUGH = ( ( PCx_Dev3_Status & BIT_DEV3_ROOT_IDX ) << 2 ) | PCx_PassUSB_ActionNum & MASK_UH_THR_UX;

				/* ȴUSB, 680uS@12MHz, 170uS@48MHz */
				i = 0;
				while ( ( USB_FREE & 0x0E ) == 0 )
				{
					i++;
					if( i > 100 )
					{
						break;
					}
					mDelayuS( 5 );
				}  
				USB_CTRL |= bUC_THROUGH;  									/* USBֱͨʹ */

				/* ֪ͨǰʹܵļ3#豸 */
				USBX_OneHub_EP1IntUp( PCx_PassUSB_ActionNum, 3, BIT_PORT_CONNECT | BIT_PORT_C_REST );
			}
			PCx_Dev3_Status &= ~BIT_DEV3_PC_RESET;
		}

		/**********************************************************/
		/* жϵԶ˵USBǷвα仯 */
		if( PCx_Connect_CurStatus != PCx_Connect_LastStatus )
		{
			/* 㵱ǰϿĵԶ˿ڱ */
			status = PCx_Connect_CurStatus ^ PCx_Connect_LastStatus;
			for( num = 0; num < PCx_NumMax; num++ )
			{
				if( ( 1 << num ) == status )
				{
					break;
				}
			}

			if( PCx_Connect_CurStatus > PCx_Connect_LastStatus )
			{
				/* ԶUSB */
				printf("PC%x In\n",(UINT16)num);

				/* жǷUSBX豸Ҫͨ */
				for( i = 0; i < TOTAL_ROOT_HUB; i++ )
				{				
					if( RootHubDev[ i ].DeviceIndex == 0x00 ) 
					{
						PCx_TaskStatus[ num ] |= 0x01;
					}
					else if( RootHubDev[ i ].DeviceIndex == 0x01 )
					{
						PCx_TaskStatus[ num ] |= 0x02;
					}
					else if( RootHubDev[ i ].DeviceIndex == 0x03 )
					{
						if( PCx_PassUSB_ActionNum == num )
						{
							PCx_TaskStatus[ num ] |= 0x08;
						}
					}
				}
				PCx_UpInt_TimeCount = 80;								  
				printf("PC%x-Int:%x\n",(UINT16)num,(UINT16)PCx_TaskStatus[ num ]);
			}
			else
			{
 				/* ԶUSBϿ */
				printf("PC%x Out\n",(UINT16)num);
			}
			PCx_Connect_LastStatus = PCx_Connect_CurStatus;
		}
        #endif
        
		/**********************************************************/
		/* USB */
		USBH_Main_Deal( );																			
	}
}

