/*
 * adc.h
 *
 *  Created on: 2022511
 *      Author: DELL
 */

#ifndef BSP_INC_ADC_H_
#define BSP_INC_ADC_H_
/*-----------------------------------------------------------------------------
 Section: Includes
 ----------------------------------------------------------------------------*/
#include "types.h"
#include "ch32v20x_conf.h"
//#include "core_riscv.h"
/*-----------------------------------------------------------------------------
 Section: Macro Definitions
 ----------------------------------------------------------------------------*/
#define ADC_DMA_DATA_POINT          32 /*DMA*/

/*-----------------------------------------------------------------------------
 Section: Type Definitions
 ----------------------------------------------------------------------------*/
typedef enum
{
    E_ADC_CHAN_TEMP = 0,             /**< ¶ͨ */
    E_ADC_CHAN_VG,                   /**< VG */
    E_ADC_CHAN_VOLT_POS,             /**< ѹ */
    E_ADC_CHAN_VOLT_NEG,             /**< ѹ */
    E_ADC_CHAN_VOLT,                 /**< صѹ */
    E_ADC_CHAN_VOLT_2,               /**< صѹ2, */
    E_ADC_CHAN_NUM,                  /**< ADCͨ */
}adc_channel_e;

/*-----------------------------------------------------------------------------
 Section: Function Prototypes
 ----------------------------------------------------------------------------*/
extern status_t
adc_init();

extern status_t
get_adc_value(uint8_t adc_channel, float32_t *value);

extern status_t
get_adc_value_samp(uint16_t *value);

extern float32_t
res_to_temp(float32_t res);

#endif /* BSP_INC_ADC_H_ */
/*--------------------------End of adc.h-----------------------------*/
