/*
 * adc.c
 *
 *  Created on: 2022511
 *      Author: DELL
 */
/*-----------------------------------------------------------------------------
 Section: Includes
 ----------------------------------------------------------------------------*/
#include "../inc/adc.h"
#include "ch32v20x.h"
#include "aid.h"
#include <maths.h>
#include <string.h>
//#include "gpio.h"
/*-----------------------------------------------------------------------------
 Section: Global Variables
 ----------------------------------------------------------------------------*/
void DMA1_Channel1_IRQHandler(void) __attribute__((interrupt("WCH-Interrupt-fast")));
/*-----------------------------------------------------------------------------
 Section: Local Variables
 ----------------------------------------------------------------------------*/

//DMA ADC
static uint16_t s_adc_value[ADC_DMA_DATA_POINT][E_ADC_CHAN_NUM];
//¶
static const uint32_t s_rt_tab[181] =
{
    8964620,    //-55
    8356940,    //-54
    7793360,
    7270520,
    6785320,
    6334910,
    5916640,
    5528100,
    5167040,
    4831420,
    4519330,
    4229010,
    3958870,
    3707390,
    3473220,
    3255090,
    3051810,
    2862320,
    2685610,
    2520770,
    2366930,
    2223320,
    2089200,
    1963910,
    1846810,
    1737340,
    1634960,
    1539180,
    1449530,
    1365600,
    1287000,
    1213350,
    1144320,
    1079610,
    1018910,
    961965,
    908515,
    858331,
    811198,
    766914,
    725293,
    686161,
    649358,
    614732,
    582144,
    551464,
    522571,
    495350,
    469698,
    445515,
    422711,
    401199,
    380900,
    361740,
    343648,
    326560,
    310414,
    295155,
    280730,
    267087,
    254182,
    241970,
    230410,
    219466,
    209100,
    198920,
    189972,
    181150,
    172785,
    164850,
    157322,
    150178,
    143396,
    136956,
    130840,
    125028,
    119506,
    114256,
    109264,
    104516,
    100000,
    95701,
    91610,
    87715,
    84006,
    80472,
    77106,
    73897,
    70838,
    67921,
    65140,
    62486,
    59954,
    57537,
    55230,
    53026,
    50922,
    48912,
    46991,
    45155,
    43399,
    41721,
    40116,
    38580,
    37111,
    35750,
    34359,
    33070,
    31836,
    30654,
    29521,
    28436,
    27396,
    26399,
    25442,
    24525,
    23646,
    22802,
    21992,
    21215,
    20469,
    19752,
    19064,
    18404,
    17769,
    17159,
    16572,
    16009,
    15467,
    14946,
    14445,
    13963,
    13499,
    13053,
    12623,
    12210,
    11812,
    11429,
    11060,
    10704,
    10362,
    10031,
    9713,
    9407,
    9111,
    8826,
    8551,
    8286,
    8030,
    7784,
    7546,
    7316,
    7094,
    6880,
    6673,
    6474,
    6281,
    6094,
    5914,
    5741,
    5573,
    5410,
    5253,
    5101,
    4955,
    4813,
    4675,
    4542,
    4414,
    4290,
    4169,
    4053,
    3940,
    3831,
    3725,
    3623,
    3524,
    3428,
    3335,
    3245,
    3158,  //125
};

/*-----------------------------------------------------------------------------
 Section: Local Function Prototypes
 ----------------------------------------------------------------------------*/
static status_t
adc_dma_init();

/*-----------------------------------------------------------------------------
 Section: Function Definitions
 ----------------------------------------------------------------------------*/
/**
 /**
 ******************************************************************************
 * @brief      ADCóʼ
 * @param[in]  None
 * @param[out] None
 * @retval     None
 * @details    1·: ¶
 *             2·: MOSؿ· VGS
 *             3·: صѹ
 *             4·: BAT+
 *             5·: BAT-
 *             6·: 
 *
 * @note       1. ADCƵ8M41.5  6ͨ  ʵ⣺32 -1378us /64-2720us)
 ******************************************************************************
 */
extern status_t
adc_init()
{
    ADC_InitTypeDef ADC_InitStructure;
    GPIO_InitTypeDef GPIO_InitStructure;

    //ʹADC1ʱ
    RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA, ENABLE);
    RCC_APB2PeriphClockCmd(RCC_APB2Periph_ADC1, ENABLE);

    //The ADC input clock is generated from the PCLK2 clock divided by a prescaler
    RCC_ADCCLKConfig(RCC_PCLK2_Div6);

    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_1 | GPIO_Pin_3 | GPIO_Pin_4 | GPIO_Pin_5 | GPIO_Pin_6 | GPIO_Pin_7;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AIN;
    GPIO_Init(GPIOA, &GPIO_InitStructure);

    ADC_DeInit(ADC1);
    ADC_InitStructure.ADC_Mode = ADC_Mode_Independent;
    ADC_InitStructure.ADC_ScanConvMode = ENABLE;
    ADC_InitStructure.ADC_ContinuousConvMode = ENABLE;
    ADC_InitStructure.ADC_ExternalTrigConv = ADC_ExternalTrigConv_None;
    ADC_InitStructure.ADC_DataAlign = ADC_DataAlign_Right;
    //˳йתADCͨĿ
    ADC_InitStructure.ADC_NbrOfChannel = E_ADC_CHAN_NUM;
    ADC_Init(ADC1, &ADC_InitStructure);

    ADC_RegularChannelConfig(ADC1, ADC_Channel_1 , 1, ADC_SampleTime_41Cycles5);
    ADC_RegularChannelConfig(ADC1, ADC_Channel_3 , 2, ADC_SampleTime_41Cycles5);
    ADC_RegularChannelConfig(ADC1, ADC_Channel_4 , 3, ADC_SampleTime_41Cycles5);
    ADC_RegularChannelConfig(ADC1, ADC_Channel_5 , 4, ADC_SampleTime_41Cycles5);
    ADC_RegularChannelConfig(ADC1, ADC_Channel_6 , 5, ADC_SampleTime_41Cycles5);
    ADC_RegularChannelConfig(ADC1, ADC_Channel_7 , 6, ADC_SampleTime_41Cycles5);

    // ADCDMA֧֣ҪʵDMAܣDMAͨȲ
    memset(s_adc_value, 0x00, sizeof(s_adc_value));
    ADC_DMACmd(ADC1, ENABLE);
    ADC_BufferCmd(ADC1, DISABLE);
    //ʹָADC1
    ADC_Cmd(ADC1, ENABLE);
    ADC_ResetCalibration(ADC1);
    while(ADC_GetResetCalibrationStatus(ADC1));
    ADC_StartCalibration(ADC1);
    while(ADC_GetCalibrationStatus(ADC1));
    ADC_BufferCmd(ADC1, ENABLE);

    adc_dma_init();
    DMA_Cmd(DMA1_Channel1, ENABLE);
    ADC_SoftwareStartConvCmd(ADC1, ENABLE);
//    gpio_write(GPIO_OUT_LED_FAULT_STATE, 0);
    return TEST_OK;
}
/**
 ******************************************************************************
 * @brief      ȡADCֵ
 * @param[in]  adc_channel:ADC ͨ
 *             valueADCֵ
 * @param[out] None
 * @retval     None
 *
 * @details
 *
 * @note
 ******************************************************************************
 */
extern status_t
get_adc_value(uint8_t adc_channel, float32_t *value)
{
    int32_t i = 0;
    float64_t sum = 0;
    uint8_t channel = 0;
    uint16_t buf[ADC_DMA_DATA_POINT];
    uint16_t adc_value[ADC_DMA_DATA_POINT][E_ADC_CHAN_NUM];

    memset(adc_value, 0x00, sizeof(adc_value));

    memcpy(adc_value, s_adc_value, sizeof(s_adc_value));

    for (channel = 0; channel < E_ADC_CHAN_NUM; channel++)
    {
        if ((adc_channel >= E_ADC_CHAN_NUM) || (channel == adc_channel))
        {
            sum = 0;

            for (i = 0; i < ADC_DMA_DATA_POINT; i++)
            {
                buf[i] = adc_value[i][channel];
//                printf("test%d-%d::%d\r\n",i,channel, adc_value[i][channel]);
            }

            //
            sort_uint16(buf, ADC_DMA_DATA_POINT);

            for (i = 0; i < (ADC_DMA_DATA_POINT / 2); i++)
            {
                sum += buf[ADC_DMA_DATA_POINT / 4 + i];
            }

            value[channel] = sum / (ADC_DMA_DATA_POINT / 2);
        }
    }

    return TEST_OK;
}
/**
 ******************************************************************************
 * @brief      ȡE_ADC_NUMͨADC_DMA_DATA_POINTԭʼֵ
 ** @param[in] adc_channel:ADC ͨ
 *             valueADCֵ
 * @param[out] None
 * @retval     None
 * @details
 * @note
 ******************************************************************************
 */
extern status_t
get_adc_value_samp( uint16_t *value)
{
    memcpy(value, s_adc_value, sizeof(s_adc_value));
    return TEST_OK;
}
/**
 ******************************************************************************
 * @brief      ֵתΪʵ¶ֵ
 * @param[in]  res:תֵ
 * @param[out] None
 * @retval     None
 * @details
 * @note
 ******************************************************************************
 */
extern float32_t
res_to_temp(float32_t res)
{
    int32_t i = 0;

    if (res > s_rt_tab[0])
    {
        return -55;
    }

    if (res < s_rt_tab[ARRAY_SIZE(s_rt_tab) - 1])
    {
        return 125;
    }

    for (i = 0; i < (int32_t)ARRAY_SIZE(s_rt_tab) - 1; i++)
    {
        if ((res < s_rt_tab[i]) && (res >= s_rt_tab[i + 1]))
        {
            return (i - 55) + (s_rt_tab[i] - res) / (s_rt_tab[i] - s_rt_tab[i + 1]);
        }
    }

    return 0xffff;
}
/**
 ******************************************************************************
 * @brief      ADC DMAʼ
 * @param[in]  None
 * @param[out] None
 * @retval     None
 *
 * @details
 *
 * @note
 ******************************************************************************
 */
static status_t
adc_dma_init()
{
   DMA_InitTypeDef  DMA_InitStructure;
   NVIC_InitTypeDef NVIC_InitStructure;
   RCC_AHBPeriphClockCmd(RCC_AHBPeriph_DMA1, ENABLE);

   DMA_DeInit(DMA1_Channel1);
   DMA_InitStructure.DMA_PeripheralBaseAddr = (uint32_t)&ADC1->RDATAR;
   DMA_InitStructure.DMA_MemoryBaseAddr = (uint32_t)s_adc_value;
   DMA_InitStructure.DMA_DIR = DMA_DIR_PeripheralSRC;
   DMA_InitStructure.DMA_BufferSize = E_ADC_CHAN_NUM*ADC_DMA_DATA_POINT;
   DMA_InitStructure.DMA_PeripheralInc = DMA_PeripheralInc_Disable;
   DMA_InitStructure.DMA_MemoryInc = DMA_MemoryInc_Enable;
   DMA_InitStructure.DMA_PeripheralDataSize = DMA_PeripheralDataSize_HalfWord;
   DMA_InitStructure.DMA_MemoryDataSize = DMA_MemoryDataSize_HalfWord;
   DMA_InitStructure.DMA_Mode = DMA_Mode_Circular;
   DMA_InitStructure.DMA_Priority = DMA_Priority_High;
   DMA_InitStructure.DMA_M2M = DMA_M2M_Disable;
   DMA_Init(DMA1_Channel1, &DMA_InitStructure);

   //DMAжʹ
   DMA_ITConfig(DMA1_Channel1, DMA_IT_TC, ENABLE);

   NVIC_PriorityGroupConfig(NVIC_PriorityGroup_1);
   NVIC_InitStructure.NVIC_IRQChannel = DMA1_Channel1_IRQn;
   NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;
   NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
   NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
   NVIC_Init(&NVIC_InitStructure);

   return TEST_OK;
}
/**
 ******************************************************************************
 * @brief      DMAж
 * @param[in]  None
 * @param[out] None
 * @retval     None
 *
 * @details
 *
 * @note
 ******************************************************************************
 */
void DMA1_Channel1_IRQHandler()
{
//    u8 i=0;
    if (DMA_GetITStatus(DMA1_IT_TC1) != RESET)
    {
        DMA_ClearITPendingBit(DMA1_IT_TC1);
//        gpio_write(GPIO_OUT_LED_FAULT_STATE, 1);
    }
}
/*----------------------------adc.c--------------------------------*/
