/*
 * gpio.c
 *
 *  Created on: 2022517
 */
/*-----------------------------------------------------------------------------
 Section: Includes
 ----------------------------------------------------------------------------*/
#include <types.h>
#include <gpio.h>

/*-----------------------------------------------------------------------------
 Section: Type Definitions
 ----------------------------------------------------------------------------*/
#pragma pack(push,1)
/*IO_MAP */
typedef struct
{
    uint32  iono;          /**< IO */
    uint32  gpiobase;       /**< Ĵַ */
    uint32  pinno;          /**< ű */
    bool_e  state;          /**< ʼ״̬ */
}IO_MAP;
#pragma pack(pop)

/*-----------------------------------------------------------------------------
 Section: Local Variables
 ----------------------------------------------------------------------------*/
/*IOĶӦϵ*/
static const IO_MAP outputIoMap[] =
{
    {GPIO_OUT_LED_FAULT_STATE,GPIOB_BASE,GPIO_Pin_6,1},    //PB6
    {GPIO_OUT_LED_COMM_POWER,GPIOB_BASE,GPIO_Pin_5,1},    //PB5
    {GPIO_OUT_EN_F,GPIOB_BASE,GPIO_Pin_0,0},    //PB0
};

/*-----------------------------------------------------------------------------
 Section: Function Definitions
 ----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @brief      GPIOʼ
 * @param[in]  None
 * @param[out] None
 * @retval     None
 * @details
 * @note
 ******************************************************************************
 */
extern status_t
gpio_init()
{
    int32_t i=0;
    GPIO_InitTypeDef GPIO_InitStructure;
    RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA, ENABLE);
    RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB, ENABLE);
    for(i=0;i<sizeof(outputIoMap)/sizeof(IO_MAP);i++)
    {
       GPIO_InitStructure.GPIO_Pin = outputIoMap[i].pinno;
       GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
       GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
       GPIO_Init((GPIO_TypeDef*)(outputIoMap[i].gpiobase),
               &GPIO_InitStructure);
       if(1==outputIoMap[i].state)
       {
           GPIO_SetBits((GPIO_TypeDef*)outputIoMap[i].gpiobase,
                   outputIoMap[i].pinno);
       }
       else
       {
           GPIO_ResetBits((GPIO_TypeDef*)outputIoMap[i].gpiobase,
                              outputIoMap[i].pinno);
       }
    }
    GPIO_InitStructure.GPIO_Pin=GPIO_Pin_3;
    GPIO_InitStructure.GPIO_Mode=GPIO_Mode_IPU;
    GPIO_Init(GPIOB,&GPIO_InitStructure);
    return TEST_OK;
}
/**
 ******************************************************************************
 * @brief      GPIO
 * @param[in]  io_no:IO 
 *             value:״̬
 * @param[out] None
 * @retval     None
 *
 * @details
 *
 * @note
 ******************************************************************************
 */
extern status_t
gpio_write(int32_t io_no,int32_t value)
{
    uint32 i=0;
    for(i=0;i<sizeof(outputIoMap)/sizeof(IO_MAP);i++)
    {
        if(io_no==outputIoMap[i].iono)
        {
            //GPIO_WriteBit((GPIO_TypeDef*)outputIoMap[i].gpiobase,outputIoMap[i].pinno, value);
            if(1==value)
            {
                GPIO_SetBits((GPIO_TypeDef*)outputIoMap[i].gpiobase,
                                   outputIoMap[i].pinno);
            }
            else
            {
                GPIO_ResetBits((GPIO_TypeDef*)outputIoMap[i].gpiobase,
                                                  outputIoMap[i].pinno);
            }
            return TEST_OK;
        }
    }
    return TEST_ERROR;
}
/*----------------------------gpio.c--------------------------------*/
