/*
 * serial.c
 *
 *  Created on: 2022519
 *
 */

/*-----------------------------------------------------------------------------
 Section: Includes
 ----------------------------------------------------------------------------*/
#include  "serial.h"
#include  "systick.h"
#include  "types.h"

/*-----------------------------------------------------------------------------
 Section: Type Definitions
 ----------------------------------------------------------------------------*/
#define  SERIAL_BUF_SIZE         128

typedef struct
{
    uint16_t pToBuf;                /* offset from start of buffer where to write next */
    uint16_t pFromBuf;              /* offset from start of buffer where to read next */
    uint16_t bufSize;               /* size of ring in bytes */
    uint8_t buf[SERIAL_BUF_SIZE];   /* pointer to start of buffer */
}ring_t;

/*-----------------------------------------------------------------------------
 Section: Global Variables
 ----------------------------------------------------------------------------*/
void USART1_IRQHandler(void) __attribute__((interrupt("WCH-Interrupt-fast")));

/*-----------------------------------------------------------------------------
 Section: Local Variables
 ----------------------------------------------------------------------------*/
static ring_t s_serial_rcv;
/*-----------------------------------------------------------------------------
 Section: Function Definitions
 ----------------------------------------------------------------------------*/
/**
 ******************************************************************************
 * @brief      ڳʼ
 * @param[in]  None
 * @param[out] None
 * @retval     None
 * @details
 * @note
 ******************************************************************************
 */
extern status_t
serial_init()
{
    GPIO_InitTypeDef  GPIO_InitStructure = {0};
    USART_InitTypeDef USART_InitStructure = {0};
    NVIC_InitTypeDef  NVIC_InitStructure = {0};
    /* USART1 TX-->A.9   RX-->A.10 */
    RCC_APB2PeriphClockCmd(RCC_APB2Periph_USART1 | RCC_APB2Periph_GPIOA, ENABLE);

    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_9;
    GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
    GPIO_Init(GPIOA, &GPIO_InitStructure);

    GPIO_InitStructure.GPIO_Pin = GPIO_Pin_10;
    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
    GPIO_Init(GPIOA, &GPIO_InitStructure);

    GPIO_InitStructure.GPIO_Pin=GPIO_Pin_8;
    GPIO_InitStructure.GPIO_Mode=GPIO_Mode_Out_PP;
    GPIO_Init(GPIOA,&GPIO_InitStructure);
    //ĬϽ
    GPIO_ResetBits(GPIOA,GPIO_Pin_8);

    USART_InitStructure.USART_BaudRate = 9600;
    USART_InitStructure.USART_WordLength = USART_WordLength_8b;
    USART_InitStructure.USART_StopBits = USART_StopBits_1;
    USART_InitStructure.USART_Parity = USART_Parity_No;
    USART_InitStructure.USART_HardwareFlowControl = USART_HardwareFlowControl_None;
    USART_InitStructure.USART_Mode = USART_Mode_Tx | USART_Mode_Rx;

    USART_Init(USART1, &USART_InitStructure);
    //ʹܽжϣ÷ж
    USART_ITConfig(USART1,USART_IT_RXNE,ENABLE);
    USART_ITConfig(USART1, USART_IT_IDLE, DISABLE);
    USART_ITConfig(USART1, USART_IT_TXE, DISABLE);

    NVIC_InitStructure.NVIC_IRQChannel = USART1_IRQn;
    NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 1;
    NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
    NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
    NVIC_Init(&NVIC_InitStructure);

    USART_Cmd(USART1, ENABLE);
    USART_ClearFlag(USART1,USART_FLAG_TC);

    //ʼڽջ
    s_serial_rcv.pToBuf=0;
    s_serial_rcv.pFromBuf=0;
    s_serial_rcv.bufSize=SERIAL_BUF_SIZE;

    return TEST_OK;
}

/**
 ******************************************************************************
 * @brief      ݷ
 * @param[in]  buf:͵
 *             len:ݵĳ
 * @param[out] None
 * @retval     None
 * @details
 * @note
 ******************************************************************************
 */
extern status_t
serial_send(uint8_t *buf,uint32_t len)
{
    if (len == 0 || len > 0x0fff)
    {
        return TEST_ERROR;
    }

    //
    GPIO_SetBits(GPIOA, GPIO_Pin_8);

    delay_10us(1000);

    while(len--)
    {
        USART_SendData(USART1, *(buf++));
        while(USART_GetFlagStatus(USART1, USART_FLAG_TXE) == RESET);
    }

    //ʱ10,ֹݷͲ
    delay_10us(1000);
    GPIO_ResetBits(GPIOA, GPIO_Pin_8);
    return TEST_OK;
}
/**
 ******************************************************************************
 * @brief      ݽ
 * @param[in]  buf:յ
 *             len:ݵĳ
 * @param[out] ʵ ݳ
 * @retval     None
 * @details
 * @note
 ******************************************************************************
 */
extern uint16_t
serial_recv(uint8_t *buf,uint32_t len)
{
    uint16_t bytenum = 0 ;
    uint16_t i = 0;
    uint16_t tobuf = 0;

    tobuf = s_serial_rcv.pToBuf;
    //δβ
    if (s_serial_rcv.pFromBuf <= tobuf)
    {
        bytenum  = tobuf - s_serial_rcv.pFromBuf;
    }
    //β
    else
    {
        bytenum  = tobuf + s_serial_rcv.bufSize - s_serial_rcv.pFromBuf;
    }

    for (i = 0; i < MIN(bytenum, len); i++)
    {
        *buf = s_serial_rcv.buf[s_serial_rcv.pFromBuf];
        buf++;
        s_serial_rcv.pFromBuf++;
        if (s_serial_rcv.pFromBuf >= s_serial_rcv.bufSize)
        {
            s_serial_rcv.pFromBuf = 0;
        }
    }

    return MIN(bytenum, len);
}
/**
 ******************************************************************************
 * @brief      ʹܿ
 * @param[in]  is_enable  TRUE: ʹ  FALSE: ر
 * @param[out] None
 * @retval     None
 ******************************************************************************
 */
extern status_t
serial_enable(bool_e is_enable)
{
    if (TRUE==is_enable)
    {
        GPIO_ResetBits(GPIOA, GPIO_Pin_8); //
    }
    else
    {
        GPIO_SetBits(GPIOA,GPIO_Pin_8);    //
    }
    return TEST_OK;
}
/**
 ******************************************************************************
 * @brief      ڲ
 * @param[in]  None
 * @param[out] None
 * @retval     None
 ******************************************************************************
 */
extern status_t
serial_test()
{
    uint16_t rcvlen=0;
    uint8_t rcvbuf[100]={0x55};
    memset(rcvbuf,0x00,sizeof(rcvbuf));
    rcvbuf[0] = 0x11;
    rcvbuf[1] = 0x22;
    rcvbuf[2] = 0x33;
    rcvbuf[3] = 0x44;
    rcvbuf[4] = 0x55;
    rcvbuf[5] = 0x66;
    rcvbuf[6] = 0x77;
    rcvbuf[7] = 0x88;
    rcvbuf[8] = 0x99;
    rcvbuf[9] = 0x44;
    serial_send(rcvbuf, 11);
    while(1)
    {
        rcvlen=serial_recv(rcvbuf,sizeof(rcvbuf));
        if (rcvlen>0)
        {
            delay_10us(1000);
            serial_send(rcvbuf, rcvlen);
        }
//        Delay_Ms(5000);
//        serial_send(rcvbuf, 10);
    }
    return TEST_OK;
}
/**
 ******************************************************************************
 * @brief      ݽж
 * @param[in]  None
 * @param[out] None
 * @retval     None
 * @details
 * @note
 ******************************************************************************
 */
void USART1_IRQHandler()
{
    uint8_t s_rcv_char;
    s_rcv_char=USART_ReceiveData(USART1);
    s_serial_rcv.buf[s_serial_rcv.pToBuf]=s_rcv_char;
    s_serial_rcv.pToBuf++;
    if(s_serial_rcv.pToBuf>=s_serial_rcv.bufSize)
    {
        s_serial_rcv.pToBuf=0;
    }
    USART_ClearITPendingBit(USART1, USART_IT_RXNE);

}
/*----------------------------serial.c--------------------------------*/
