/*
 * systick.c
 *
 *  Created on: 202267
 *      Author: DELL
 */
/*-----------------------------------------------------------------------------
 Section: Includes
 ----------------------------------------------------------------------------*/
#include "systick.h"
/*-----------------------------------------------------------------------------
 Section: Global Variables
 ----------------------------------------------------------------------------*/
void SysTick_Handler(void) __attribute__((interrupt("WCH-Interrupt-fast")));

__IO uint32_t s_tick;

/**
 ******************************************************************************
 * @brief      SysTickʼ
 * @param[in]  None
 * @param[out] None
 * @retval     None
 * @details
 * @note
 ******************************************************************************
 */
static uint32_t SysTick_Config(uint32_t ticks)
{
    SysTick->CTLR = 0x00000000;             //ƼĴλ

    SysTick->SR = 0x00000000;               //״̬Ĵλ

    SysTick->CNT = 0x00000000;              //λóʼֵΪ0

    SysTick->CMP = ticks;

    NVIC_SetPriority(SysTicK_IRQn, 15);      //SysTickжȼ
    NVIC_EnableIRQ(SysTicK_IRQn);            //ʹܿSystickж

    SysTick->CTLR |= 0x0000000B;            //ϵͳSTKHCLK/8ʱ
    return (0);
}
/**
 ******************************************************************************
 * @brief      SysTickʼ
 * @param[in]  None
 * @param[out] None
 * @retval     None
 * @details
 * @note
 ******************************************************************************
 */
void Systick_Init(void)
{
    //˴ڽгʼʱñȽϼĴֵ
    SysTick_Config(SystemCoreClock / 800000);//8000-1ms,80000-100us,
}

/**
 ******************************************************************************
 * @brief      STKжϷSTKʱΪHCLK/8SysTickʼ
  *   ȽϼĴֵΪSystemCoreClock / 8000 = 9000ɴ˼ÿ1ms1жϷ
 * @param[in]  None
 * @param[out] None
 * @retval     None
 * @details
 * @note
 ******************************************************************************
 */
void SysTick_Handler(void)
{

    SysTick->SR = 0x00000000;               //״̬Ĵλ

    SysTick->CNT = 0x00000000;              //λóʼֵΪ0

    s_tick++;

//    if(s_tick >= 1000)
//    {
//        s_tick = 0;
//    }
}
/**
 ******************************************************************************
 * @brief      tick
 * @param[in]  None
 * @param[out] None
 * @retval     None
 * @details
 * @note
 ******************************************************************************
 */
extern void
delay_10us(uint32_t us10_cnt)
{
    uint64_t tick = s_tick;

    while((s_tick - tick) < us10_cnt)
    {

    }
}

/**
 ******************************************************************************
 * @brief      ϵͳtickֵȡ
 * @param[in]  None
 * @param[out] None
 * @retval     None
 * @details
 * @note
 ******************************************************************************
 */
extern uint64_t
tickGet(void)
{
    return s_tick;
}
/**
 ******************************************************************************
 * @brief      systickƵʻȡ10΢ڣƵΪ100000
 * @param[in]  None
 * @param[out] None
 * @retval     ƵΪ100000
 * @details
 * @note
 ******************************************************************************
 */
extern uint32_t
sysClkRateGet(void)
{
    return 100000;
}
