/**
 ******************************************************************************
 * @file       sysLib.h
 * @brief      API include file of sysLib.h.
 * @details    This file including all API functions's declare of sysLib.h.
 * @copyright  Copyright(C), 2015-2020,Sanxing Medical & Electric Co.,Ltd.
 ******************************************************************************
 */
#ifndef INC_SYSLIB_H_
#define INC_SYSLIB_H_ 

/*-----------------------------------------------------------------------------
 Section: Includes
 ----------------------------------------------------------------------------*/
#include "types.h"

/*-----------------------------------------------------------------------------
 Section: Macro Definitions
 ----------------------------------------------------------------------------*/
/* NONE */

/*-----------------------------------------------------------------------------
 Section: Type Definitions
 ----------------------------------------------------------------------------*/
/* NONE */

/*-----------------------------------------------------------------------------
 Section: Globals
 ----------------------------------------------------------------------------*/
/* NONE */

/*-----------------------------------------------------------------------------
 Section: Function Prototypes
 ----------------------------------------------------------------------------*/

extern uint16_t
get_crc16(const uint8_t *buf, uint16_t len);

extern void
binvert(void *pin, int32_t bytes);

extern int32_t
memequals(void * s1, uint8_t c, size_t n);

extern uint8_t
get_crc_sum(const uint8_t *buf, uint16_t count);

#endif /* INC_SYSLIB_H_ */
/*--------------------------End of sysLib.h-----------------------------*/
