/**
 ******************************************************************************
 * @file       ptl.h
 * @brief      API include file of ptl.h.
 * @details    This file including all API functions's declare of ptl.h.
 * @copyright  Copyright(C), 2015-2020,Sanxing Medical & Electric Co.,Ltd.
 ******************************************************************************
 */
#ifndef INC_PTL_H_
#define INC_PTL_H_ 

/*-----------------------------------------------------------------------------
 Section: Includes
 ----------------------------------------------------------------------------*/
#include <types.h>

/*-----------------------------------------------------------------------------
 Section: Type Definitions
 ----------------------------------------------------------------------------*/
#pragma pack(push, 1)

typedef struct
{
    uint8_t addr;                   /**< BIMģַ */
    uint16_t num;                   /**< 豸 */
    uint8_t pulse_intv;             /**< Ĭ3룬1-10 */
    float32_t res_init;             /**< ʼ */
    uint32_t batch;                 /**<  */
    float32_t volt_1800mv_samp;     /**< صѹ1.8Vֵ*/
    float32_t volt_2200mv_samp;     /**< صѹ2.2vֵ*/
    float32_t volt_2250mv_samp;     /**< صѹ2.25vֵ*/
    float32_t disvolt_1800mv_samp;  /**< ѹ1.8Vֵ */
    float32_t disvolt_2200mv_samp;  /**< ѹ2.2Vֵ */
    float32_t disvolt_2250mv_samp;  /**< ѹ2.25Vֵ */
    uint32_t magic;
} bim_param_t;

#pragma pack(pop)


/*-----------------------------------------------------------------------------
 Section: Function Prototypes
 ----------------------------------------------------------------------------*/


#endif /* INC_PTL_H_ */
/*--------------------------End of ptl.h-----------------------------*/
