/********************************** (C) COPYRIGHT *******************************
 * File Name          : main.c
 * Author             : WCH
 * Version            : V1.0.0
 * Date               : 2021/06/06
 * Description        : Main program body.
 * Copyright (c) 2021 Nanjing Qinheng Microelectronics Co., Ltd.
 * SPDX-License-Identifier: Apache-2.0
 *******************************************************************************/

/*
 *@Note
 串口打印调试例程：
 USART1_Tx(PA9)。
 本例程演示使用 USART1(PA9) 作打印调试口输出。

*/

#include "debug.h"
#include "serial.h"
#include "iwdg.h"
#include "systick.h"
#include "flash.h"
#include "string.h"
#include "ptl.h"


static bim_param_t s_bim_param;

#define FLASH_MAGIC 0xC1BA89A8
/*funciotn select*/
static status_t
param_init();

static status_t
bim_param_init();

int main(void)
{
    SystemCoreClockUpdate();
    Systick_Init();
    serial_init();

    param_init();
    //检测flash修改成功？
    memset(&s_bim_param, 0x00, sizeof(s_bim_param));
    flash_read((uint8_t *)&s_bim_param, E_PARAM_NORMAL, sizeof(s_bim_param));
    serial_send((uint8_t *)&s_bim_param, sizeof(s_bim_param));

    while(1);
}

static status_t
param_init()
{
    bim_param_t bak_param;

    //BIM参数初始化
    memset(&s_bim_param, 0x00, sizeof(s_bim_param));

    //参数区读取
    flash_read((uint8_t *)&s_bim_param, E_PARAM_NORMAL, sizeof(s_bim_param));

    //参数区不合法，从备份区读取
    if (FLASH_MAGIC != s_bim_param.magic)
    {
        memset(&s_bim_param, 0x00, sizeof(s_bim_param));

        //备份区是否合法
        flash_read((uint8_t *)&s_bim_param, E_PARAM_BAK, sizeof(s_bim_param));

        //备份区也不合法，参数初始化
        if (FLASH_MAGIC != s_bim_param.magic)
        {
            bim_param_init();
            memset(&s_bim_param, 0x00, sizeof(s_bim_param));
            flash_read((uint8_t *)&s_bim_param, E_PARAM_NORMAL, sizeof(s_bim_param));
            serial_send((uint8_t *)&s_bim_param, sizeof(s_bim_param));
            return TEST_ERROR;
        }
        else
        {
            //备份区合法，用备份区参数覆盖参数区
            flash_write((uint8_t *)&s_bim_param, E_PARAM_NORMAL, sizeof(s_bim_param));

        }
    }
    else
    {
        //参数区正常，检查下备份区是否正常,如不正常，用参数区覆盖
        memset(&bak_param, 0x00, sizeof(bim_param_t));

        flash_read((uint8_t *)&bak_param, E_PARAM_BAK, sizeof(bak_param));

        if (FLASH_MAGIC != bak_param.magic)
        {
            flash_write((uint8_t *)&s_bim_param, E_PARAM_BAK, sizeof(s_bim_param));
        }
    }
    //脉冲间隔合法性判断,不合法初始化为3秒
    if ((0 == s_bim_param.pulse_intv) || (s_bim_param.pulse_intv > 10))
    {
        s_bim_param.pulse_intv = 3;
    }

    return TEST_OK;
}
static status_t
bim_param_init()
{
    memset(&s_bim_param, 0x00, sizeof(s_bim_param));
    //魔术字
    s_bim_param.magic = FLASH_MAGIC;

    //脉冲间隔，默认3秒
    s_bim_param.pulse_intv = 3;

    //初始内阻
    s_bim_param.res_init = 0.5;

    //参数区初始化
    flash_write((uint8_t *)&s_bim_param, E_PARAM_NORMAL, sizeof(s_bim_param));
    memset(&s_bim_param, 0x00, sizeof(s_bim_param));
    if (TEST_ERROR == flash_read((uint8_t *)&s_bim_param, E_PARAM_NORMAL, sizeof(s_bim_param)))
    {
        return TEST_ERROR;
    }

    serial_send((uint8_t *)&s_bim_param, sizeof(s_bim_param));
    //备份区初始化
    flash_write((uint8_t *)&s_bim_param, E_PARAM_BAK, sizeof(s_bim_param));
//    memset(&s_bim_param, 0x00, sizeof(s_bim_param));
//    flash_read((uint8_t *)&s_bim_param, E_PARAM_BAK, sizeof(s_bim_param));
//    serial_send((uint8_t *)&s_bim_param, sizeof(s_bim_param));
    return TEST_OK;
}
