/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package autoStart;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.ui.IStartup;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import mrsdebugger.Debugger;
import mrsdebugger.MCU;
import mrsdebugger.MRSComponent;

@SuppressWarnings("restriction")
public class AutoStartAction implements IStartup {
	private static ArrayList<MRSComponent> mrsComponentList = new ArrayList<MRSComponent>();
	private static final String EMPTY_STR = "";

	// ļ
	@Override
	public void earlyStartup() {
		AutoStartLoop.getInstance().start();
		try {
			parseComponents();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private void parseComponents() throws Exception {
		mrsComponentList.clear();
		File fileManifest = new File(Platform.getInstallLocation().getURL().getFile() + "Manifest");
		if (fileManifest.exists()) {
			File[] fileVendors = fileManifest.listFiles();
			for (File fileVendor : fileVendors) {
				String vendorName = fileVendor.getName();

				File[] files = fileVendor.listFiles(new FilenameFilter() {

					@Override
					public boolean accept(File dir, String name) {
						return name.equals("manifest_dbg.xml"); // $NON-NLS-1$
					}
				});

				if (files.length == 1) {
					File fileXml = files[0];
					DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
					DocumentBuilder builder = factory.newDocumentBuilder();
					Document d = builder.parse(new InputSource(new FileInputStream(fileXml)));

					MRSComponent mrsComponent = new MRSComponent(vendorName, new ArrayList<MCU>());
					mrsComponentList.add(mrsComponent);

					// parse debuggerlist
					ArrayList<Debugger> debuggerList = new ArrayList<>();
					NodeList nodeDebuggerListList = d.getElementsByTagName("debuggerlist");
					if (nodeDebuggerListList.getLength() == 1) {
						Node nodeDebuggerList = nodeDebuggerListList.item(0);
						NodeList nodelist = nodeDebuggerList.getChildNodes();
						for (int i = 0; i < nodelist.getLength(); i++) {
							Node nodeDebugger = nodelist.item(i);
							NamedNodeMap namedNodeMap = nodeDebugger.getAttributes();
							if (namedNodeMap != null && namedNodeMap.getLength() == 1) {
								Node node = namedNodeMap.item(0);
								if (node.getNodeName().equals("name")) {
									String debuggerName = node.getNodeValue();
									Debugger debugger = new Debugger(debuggerName);
									debuggerList.add(debugger);

									NodeList nodeConfigList = nodeDebugger.getChildNodes();
									for (int j = 0; j < nodeConfigList.getLength(); j++) {
										Node nodeConfig = nodeConfigList.item(j);
										NamedNodeMap namedNodeMap2 = nodeConfig.getAttributes();
										if (namedNodeMap2 != null && namedNodeMap2.getLength() == 2) {
											String type = "", value = "";

											for (int count = 0; count < 2; count++) {
												Node n = namedNodeMap2.item(count);

												if (n.getNodeName().equals("type")) {
													type = n.getNodeValue();
												}

												if (n.getNodeName().equals("value")) {
													value = n.getNodeValue();
												}
											}

											switch (type) {
											case "riscv":
												debugger.setRvConfigName(value);
												break;
											case "arm":
												debugger.setArmConfigName(value);
												break;
											default:
												break;
											}

										}

									}
								}
							}
						}
					}

//					// bkpt
//					NodeList nodeBkptList = d.getElementsByTagName("bkpt");
//					if (nodeBkptList.getLength() == 1) {
//						Node nodeBkpt = nodeBkptList.item(0);
//						NamedNodeMap namedNodeMap = nodeBkpt.getAttributes();
//						if (namedNodeMap.getLength() == 1) {
//							Node node = namedNodeMap.item(0);
//							if (node.getNodeName().equals("name")) {
//								mrsComponent.setBkptSymbol(node.getNodeValue());
//							}
//						}
//					}

					// openocd
					NodeList nodeOpenocdList = d.getElementsByTagName("openocd");
					if (nodeOpenocdList != null && nodeOpenocdList.getLength() == 1) {
						Node nodeOpenocdExe = nodeOpenocdList.item(0);
						NamedNodeMap namedNodeMap = nodeOpenocdExe.getAttributes();
						if (namedNodeMap != null && namedNodeMap.getLength() == 2) {
							for (int count = 0; count < 2; count++) {
								Node node = namedNodeMap.item(count);
								if (node.getNodeName().equals("vendor")) {
									mrsComponent.setOpenocdVendor(node.getNodeValue());
								} else if (node.getNodeName().equals("name")) {
									mrsComponent.setOpenocdExeName(node.getNodeValue());
								}
							}
						}
					}

					// arm-gdb
					NodeList nodeArmGdbList = d.getElementsByTagName("arm-gdb");
					if (nodeArmGdbList != null && nodeArmGdbList.getLength() == 1) {
						Node nodeArmGdb = nodeArmGdbList.item(0);
						NamedNodeMap namedNodeMap = nodeArmGdb.getAttributes();
						if (namedNodeMap != null && namedNodeMap.getLength() == 2) {
							for (int count = 0; count < 2; count++) {
								Node node = namedNodeMap.item(count);
								if (node.getNodeName().equals("vendor")) {
									mrsComponent.setArmGdbVendor(node.getNodeValue());
								} else if (node.getNodeName().equals("name")) {
									mrsComponent.setArmGdbName(node.getNodeValue());
								}
							}
						}
					}

					// riscv-gdb
					NodeList nodeRiscvGdbList = d.getElementsByTagName("riscv-gdb");
					if (nodeRiscvGdbList != null && nodeRiscvGdbList.getLength() == 1) {
						Node nodeRiscvGdb = nodeRiscvGdbList.item(0);
						NamedNodeMap namedNodeMap = nodeRiscvGdb.getAttributes();
						if (namedNodeMap != null && namedNodeMap.getLength() == 2) {
							for (int count = 0; count < 2; count++) {
								Node node = namedNodeMap.item(count);
								if (node.getNodeName().equals("vendor")) {
									mrsComponent.setRiscvGdbVendor(node.getNodeValue());
								} else if (node.getNodeName().equals("name")) {
									mrsComponent.setRiscvGdbName(node.getNodeValue());
								}
							}
						}
					}

					// mculist
					NodeList nodeCommandListList = d.getElementsByTagName("mculist");
					if (nodeCommandListList != null && nodeCommandListList.getLength() == 1) {
						Node nodeCommandList = nodeCommandListList.item(0);
						NodeList childNodes = nodeCommandList.getChildNodes();
						for (int i = 0; i < childNodes.getLength(); i++) {
							Node nodeMcu = childNodes.item(i);
							NamedNodeMap namedNodeMap = nodeMcu.getAttributes();
							if (namedNodeMap != null && namedNodeMap.getLength() == 2) {
								String mcuName = null, mcuConfig = null;
								for (int count = 0; count < 2; count++) {
									Node n = namedNodeMap.item(count);
									if (n.getNodeName().equals("name")) {
										mcuName = n.getNodeValue();
									}
									if (n.getNodeName().equals("mcuconfig")) {
										mcuConfig = n.getNodeValue();
									}
								}

								MCU mcu = new MCU(mcuName, mcuConfig, new ArrayList<Debugger>());
								mrsComponent.getMcuList().add(mcu);

								NodeList childNodes2 = nodeMcu.getChildNodes();
								for (int j = 0; j < childNodes2.getLength(); j++) {
									Node nodeDebugger = childNodes2.item(j);
									NamedNodeMap namedNodeMap2 = nodeDebugger.getAttributes();
									if (namedNodeMap2 != null && namedNodeMap2.getLength() == 1) {
										Node node2 = namedNodeMap2.item(0);
										if (node2.getNodeName().equals("type")) {
											String debuggerName = node2.getNodeValue();
											Debugger debugger = new Debugger(debuggerName);
											mcu.getDebuggerList().add(debugger);

											NodeList childNodes3 = nodeDebugger.getChildNodes();
											for (int k = 0; k < childNodes3.getLength(); k++) {
												Node nodeCommand = childNodes3.item(k);
												NamedNodeMap namedNodeMap3 = nodeCommand.getAttributes();
												if (namedNodeMap3 != null && namedNodeMap3.getLength() == 2) {
													String type = EMPTY_STR, value = EMPTY_STR;
													for (int count = 0; count < 2; count++) {
														Node n = namedNodeMap3.item(count);
														if (n.getNodeName().equals("type")) {
															type = n.getNodeValue();
														}

														if (n.getNodeName().equals("value")) {
															value = n.getNodeValue();
														}

													}
													switch (type) {
													case "erase":
														debugger.setCmdErase(value);
														break;
													case "program":
														debugger.setCmdPrgram(value);
														break;
													case "verify":
														debugger.setCmdVerify(value);
														break;
													case "reset":
														debugger.setCmdReset(value);
														break;
													default:
														break;
													}

													for (Debugger element : debuggerList) {
														if (debugger.getName().equals(element.getName())) {
															debugger.setArmConfigName(element.getArmConfigName());
															debugger.setRvConfigName(element.getRvConfigName());
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	public static void updateLaunchContent(IProject project, String vendor, String linktype) throws Exception {
		if (vendor.equals("Others"))
			return;

		String prjMCU = null, prjSeries = null;
		String templatePath = project.getLocation().toOSString() + File.separator + ".template";
		File templateFile = new File(templatePath);
		if (templateFile.exists()) {
			BufferedReader br = null;
			try {
				br = new BufferedReader(new FileReader(templateFile));
				String line = null;
				while ((line = br.readLine()) != null) {
					if (line.startsWith("MCU=")) {
						prjMCU = line.substring("MCU=".length()).trim();
						continue;
					}
					if (line.startsWith("Series=")) {
						prjSeries = line.substring("Series=".length()).trim();
						continue;
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
			} finally {
				if (br != null) {
					try {
						br.close();
					} catch (IOException e) {
						e.printStackTrace();
					}
				}
			}
		}
		boolean isARM = false;
		org.w3c.dom.Document docCproject = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(
				new FileInputStream(new File(project.getLocation().toOSString() + File.separator + ".cproject")));
		if (docCproject.getChildNodes().getLength() == 0) {
			return;
		}
		NodeList nodeList = docCproject.getElementsByTagName("configuration");
		Node node = nodeList.item(0);
		NamedNodeMap namedNodeMap0 = node.getAttributes();
		for (int j = 0; j < namedNodeMap0.getLength(); j++) {
			if (namedNodeMap0.item(j).getNodeName().equals("id")) {
				isARM = namedNodeMap0.item(j).getNodeValue().startsWith("ilg.gnuarmeclipse");
				break;
			}
		}

		String mcuConfigPath = EMPTY_STR;
		String linkConfigPath = EMPTY_STR;

//		String bkptSymbol = EMPTY_STR;
		String openocdVendor = EMPTY_STR;
		String openocdName = EMPTY_STR;
		String armGdbVenor = EMPTY_STR;
		String armGdbName = EMPTY_STR;
		String riscvGdbVendor = EMPTY_STR;
		String riscvGdbName = EMPTY_STR;

		ArrayList<MRSComponent> list = AutoStartAction.getMrsComponentList();
		for (MRSComponent mrsComponent : list) {
			if (mrsComponent.getVendor().equals(vendor)) {
				openocdVendor = mrsComponent.getOpenocdVendor();
				openocdName = mrsComponent.getOpenocdExeName();
				armGdbVenor = mrsComponent.getArmGdbVendor();
				armGdbName = mrsComponent.getArmGdbName();
				riscvGdbVendor = mrsComponent.getRiscvGdbVendor();
				riscvGdbName = mrsComponent.getRiscvGdbName();

				ArrayList<MCU> mcuList = mrsComponent.getMcuList();
				for (MCU mcu : mcuList) {
					if (mcu.getName().equals(prjMCU)) {
						String mcuConfigName = mcu.getMcuConfig();
						if (mcuConfigName != null && !mcuConfigName.isEmpty()) {
							File fMcuConfigInPrj = new File(
									project.getLocation().toOSString() + File.separator + mcuConfigName);
							if (fMcuConfigInPrj.exists()) {
								mcuConfigPath = fMcuConfigInPrj.getAbsolutePath();
							} else {
								File fMcuCfgInTemplate = new File(Platform.getInstallLocation().getURL().getFile()
										+ "template" + File.separator + "wizard" + File.separator + vendor
										+ File.separator + (isARM ? "ARM" : "RISC-V") + File.separator + prjSeries
										+ File.separator + "NoneOS" + File.separator + mcuConfigName);
								if (fMcuCfgInTemplate.exists()) {
									mcuConfigPath = fMcuCfgInTemplate.getAbsolutePath();
								}
							}
						}

						ArrayList<Debugger> debuggerList = mcu.getDebuggerList();
						for (Debugger debugger : debuggerList) {
							if (debugger.getName().equals(linktype)) {
								String linkConfigName = null;
								if (isARM) {
									linkConfigName = debugger.getArmConfigName();

								} else {
									linkConfigName = debugger.getRvConfigName();
								}

								File fLinkCfg = new File(
										Platform.getInstallLocation().getURL().getFile() + "toolchain" + File.separator
												+ (openocdVendor.isEmpty() ? "OpenOCD" : "OpenOCD-" + openocdVendor)
												+ File.separator + "bin" + File.separator + linkConfigName);
								if (fLinkCfg.exists()) {
									linkConfigPath = fLinkCfg.getAbsolutePath();
								}

							}
						}
					}
				}
			}
		}

		File outsideObjLaunch = LaunchManager.LOCAL_LAUNCH_CONFIGURATION_CONTAINER_PATH
				.append(project.getName() + " obj.launch").toFile();
		File outsideElfLaunch = LaunchManager.LOCAL_LAUNCH_CONFIGURATION_CONTAINER_PATH
				.append(project.getName() + ".elf.launch").toFile();
		File builtinLaunch1 = new File(project.getLocation().toOSString() + File.separator + ".launch");
		File builtinLaunch2 = new File(
				project.getLocation().toOSString() + File.separator + project.getName() + ".launch");

		File[] fileArr = new File[] { outsideElfLaunch, outsideObjLaunch, builtinLaunch1, builtinLaunch2 };
		for (File afile : fileArr) {
			if (afile.exists()) {
				org.w3c.dom.Document docLaunch = DocumentBuilderFactory.newInstance().newDocumentBuilder()
						.parse(new FileInputStream(afile));

				Node projDsp = docLaunch.getChildNodes().item(0);
				NodeList childlist = projDsp.getChildNodes();
				for (int i = 0; i < childlist.getLength(); i++) {
					Node child = childlist.item(i);
					if (child.getNodeName().equals("stringAttribute")) {
						NamedNodeMap namedNodeMap = child.getAttributes();
						if (namedNodeMap.item(0).getNodeName().equals("key")
								&& namedNodeMap.item(1).getNodeName().equals("value")) {
							if (namedNodeMap.item(0).getNodeValue()
									.equals("com.mounriver.debug.gdbjtag.openocd.gdbServerExecutable")) {
								if (vendor.equals("WCH")) {
									namedNodeMap.item(1).setNodeValue("${eclipse_home}toolchain/OpenOCD/bin/openocd"
											+ (Platform.getOS().equals(Platform.OS_WIN32) ? ".exe" : ""));
								} else if (vendor.equals("GD")) {
									namedNodeMap.item(1).setNodeValue("${eclipse_home}toolchain/OpenOCD-GD/bin/openocd"
											+ (Platform.getOS().equals(Platform.OS_WIN32) ? ".exe" : ""));
								} else {
									if (openocdVendor.isEmpty()) {
										namedNodeMap.item(1).setNodeValue("${eclipse_home}toolchain/OpenOCD/bin/openocd"
												+ (Platform.getOS().equals(Platform.OS_WIN32) ? ".exe" : ""));
									} else {
										namedNodeMap.item(1).setNodeValue("${eclipse_home}toolchain/OpenOCD-"
												+ openocdVendor + "/bin/"
												+ (openocdName.isEmpty() ? ("openocd"
														+ (Platform.getOS().equals(Platform.OS_WIN32) ? ".exe" : ""))
														: openocdName));
									}
								}
							} else if (namedNodeMap.item(0).getNodeValue()
									.equals("com.mounriver.debug.gdbjtag.openocd.gdbServerOther")) {
								if (vendor.equals("WCH")) {
									if (isARM) {
										namedNodeMap.item(1).setNodeValue(
												"-f \"${eclipse_home}toolchain/OpenOCD/bin/wch-arm.cfg\"");
									} else {
										namedNodeMap.item(1).setNodeValue(
												"-f \"${eclipse_home}toolchain/OpenOCD/bin/wch-riscv.cfg\"");
									}
								} else if (vendor.equals("GD")) {
									if (isARM) {

									} else {
										if (linktype.equals("GDLink")) {
											namedNodeMap.item(1).setNodeValue(
													"-f \"${eclipse_home}toolchain/OpenOCD-GD/bin/openocd_gdlink_riscv.cfg\"");
										} else if (linktype.equals("JLink")) {
											namedNodeMap.item(1).setNodeValue(
													"-f \"${eclipse_home}toolchain/OpenOCD-GD/bin/openocd_jlink.cfg\"");
										}
									}
								} else {
									if (mcuConfigPath.isEmpty()) {
										namedNodeMap.item(1).setNodeValue("-f \"" + linkConfigPath + "\"");
									} else {
										namedNodeMap.item(1).setNodeValue(
												"-f \"" + linkConfigPath + "\" -f \"" + mcuConfigPath + "\"");
									}

								}
							} else if (namedNodeMap.item(0).getNodeValue()
									.equals("org.eclipse.cdt.dsf.gdb.DEBUG_NAME")) {
								if (vendor.equals("WCH")) {
									if (isARM) {
										namedNodeMap.item(1).setNodeValue(
												"${eclipse_home}toolchain/arm-none-eabi-gcc/bin/arm-none-eabi-gdb"
														+ (Platform.getOS().equals(Platform.OS_WIN32) ? ".exe" : ""));
									} else {
										namedNodeMap.item(1).setNodeValue(
												"${eclipse_home}toolchain/RISC-V Embedded GCC/bin/riscv-none-embed-gdb"
														+ (Platform.getOS().equals(Platform.OS_WIN32) ? ".exe" : ""));
									}
								} else if (vendor.equals("GD")) {
									if (isARM) {
										namedNodeMap.item(1).setNodeValue(
												"${eclipse_home}toolchain/arm-none-eabi-gcc/bin/arm-none-eabi-gdb"
														+ (Platform.getOS().equals(Platform.OS_WIN32) ? ".exe" : ""));
									} else {
										namedNodeMap.item(1).setNodeValue(
												"${eclipse_home}toolchain/RISC-V Embedded GCC/bin/riscv-none-embed-gdb"
														+ (Platform.getOS().equals(Platform.OS_WIN32) ? ".exe" : ""));
									}
								} else {

									if (isARM) {
										if (armGdbVenor.isEmpty()) {
											namedNodeMap.item(1).setNodeValue(
													"${eclipse_home}toolchain/arm-none-eabi-gcc/bin/arm-none-eabi-gdb"
															+ (Platform.getOS().equals(Platform.OS_WIN32) ? ".exe"
																	: ""));
										} else {
											namedNodeMap.item(1)
													.setNodeValue("${eclipse_home}toolchain/arm-none-eabi-gcc-"
															+ armGdbVenor + "/bin/"
															+ (armGdbName.isEmpty()
																	? ("arm-none-eabi-gdb" + (Platform.getOS()
																			.equals(Platform.OS_WIN32) ? ".exe" : ""))
																	: armGdbName));
										}

									} else {
										if (riscvGdbVendor.isEmpty()) {
											namedNodeMap.item(1).setNodeValue(
													"${eclipse_home}toolchain/RISC-V Embedded GCC/bin/riscv-none-embed-gdb"
															+ (Platform.getOS().equals(Platform.OS_WIN32) ? ".exe"
																	: ""));
										} else {
											namedNodeMap.item(1)
													.setNodeValue("${eclipse_home}toolchain/RISC-V Embedded GCC-"
															+ riscvGdbVendor + "/bin/"
															+ (riscvGdbName.isEmpty()
																	? ("riscv-none-embed-gdb" + (Platform.getOS()
																			.equals(Platform.OS_WIN32) ? ".exe" : ""))
																	: riscvGdbName));
										}
									}
								}
							}
						}
					}
				}

				// Transform the document to something we can save in a file
				ByteArrayOutputStream stream = new ByteArrayOutputStream();
				Transformer transformer = TransformerFactory.newInstance().newTransformer();
				transformer.setOutputProperty(OutputKeys.METHOD, "xml"); //$NON-NLS-1$
				transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8"); //$NON-NLS-1$
				transformer.setOutputProperty(OutputKeys.INDENT, "yes"); //$NON-NLS-1$
				DOMSource source = new DOMSource(docLaunch);
				StreamResult result = new StreamResult(stream);
				transformer.transform(source, result);

				// Save the document
				String utfString = stream.toString("UTF-8");

				FileOutputStream fos = new FileOutputStream(afile);
				fos.write(utfString.getBytes("UTF-8"));
				fos.close();
				stream.close();
//				LaunchManager launchManager = (LaunchManager) DebugPlugin.getDefault().getLaunchManager();
//				for (ILaunchConfiguration config : launchManager.getLaunchConfigurations()) {
//					launchManager.launchConfigurationChanged(config);
//				}
			}
			project.refreshLocal(IResource.DEPTH_INFINITE, new NullProgressMonitor());
		}
	}

	public static ArrayList<MRSComponent> getMrsComponentList() {
		Collections.sort(mrsComponentList, new Comparator<MRSComponent>() {

			@Override
			public int compare(MRSComponent arg0, MRSComponent arg1) {
				if (arg0.getVendor().equals("WCH")) {
					return -1;
				}

				if (arg1.getVendor().equals("WCH")) {
					return 1;
				}
				return arg0.getVendor().compareTo(arg1.getVendor());
			}

		});
		return mrsComponentList;
	}
}
