package autoStart;

import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.osgi.internal.location.EquinoxLocations;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.splash.AbstractSplashHandler;
import org.osgi.service.prefs.Preferences;


public class MRSSplashHandler extends AbstractSplashHandler {
	EclipseStarter starter = new EclipseStarter();
	private Composite loginComposite;
//	private Text usernameTextBox;
//	private Text passwordTextBox;
	private Button buttonSlnLast;
	private Button buttonSlnDefault;
	private boolean isAuthenticated;
 
	public MRSSplashHandler() {
		isAuthenticated = false;
	}
 
	public void init(final Shell splash) {
		splash.setMinimumSize(new Point(400, 165));
		super.init(splash);
 
		configureUISplash();
		createUI();
		createUIListeners();
 
		// ʾԪء
		splash.layout(true);
 
		/**
		 * Create the event loop for the splash to prevent the application load
		 * from completion, and hold it at the splash until the login event is
		 * successful.
		 */
		while (isAuthenticated == false) {
			if (splash.getDisplay().readAndDispatch() == false) {
				splash.getDisplay().sleep();
			}
		}
	}
 
	/**
	 * Create the UI listeners for all the form components.
	 */
	private void createUIListeners() {
		// Create the OK button listeners.
		buttonSlnLast.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				String slnLast = "G:\\test0614";
				handleButtonOKWidgetSelected(slnLast);
			}
		});
 
		// Create the cancel button listeners.
		buttonSlnDefault.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				String slnDefault = "C:\\MRS_DATA";
				handleButtonOKWidgetSelected(slnDefault);
//				/**
//				 * Abort the loading of the RCP application.
//				 */
//				getSplash().getDisplay().close();
//				System.exit(0);
			}
		});
	}
 
	/**
	 * Handles the OK button being pressed and the login attempted.
	 */
	private void handleButtonOKWidgetSelected(String slnPath) {
		Preferences node = ConfigurationScope.INSTANCE.getNode(IDEWorkbenchPlugin.IDE_WORKBENCH);
//		String recentWorkspace = "C://MRS_DATA";
//		String encodedRecentWorkspaces = encodeStoredWorkspacePaths(recentWorkspaces);
		
		System.setProperty(EquinoxLocations.PROP_INSTANCE_AREA, slnPath);
		isAuthenticated = true;
		// AuthenticationClient client = new AuthenticationClient();
	}
 
	/**
	 * Calls the individual UI component creation functions.
	 */
	private void createUI() {
		// Create the login panel.
		loginComposite = new Composite(getSplash(), SWT.BORDER);
		loginComposite.setLayout(null);
 
		// Create the OK button.
		buttonSlnLast = new Button(loginComposite, SWT.PUSH);
		buttonSlnLast.setBounds(220, 228, 100, 30);
		buttonSlnLast.setText("Last");
 
		// Create the cancel button.
		buttonSlnDefault = new Button(loginComposite, SWT.PUSH);
		buttonSlnDefault.setBounds(340, 228, 100, 30);
		buttonSlnDefault.setText("Default");
	}
 
	/**
	 * Configures the splash screen SWT/UI components.
	 */
	private void configureUISplash() {
		// Configure layout
		FillLayout layout = new FillLayout();
		getSplash().setLayout(layout);
 
		// Force shell to inherit the splash background
		getSplash().setBackgroundMode(SWT.INHERIT_DEFAULT);
	}
}
