/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package breakpoint;

import java.util.HashMap;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class MRSCDIDebugModel
  extends CDIDebugModel
{
  public static ICLineBreakpoint createLineBreakpoint(String sourceHandle, IResource resource, int type, int lineNumber, boolean enabled, int ignoreCount, String condition, boolean register)
    throws CoreException
  {
    HashMap<String, Object> attributes = new HashMap(10);
    setLineBreakpointAttributes(attributes, sourceHandle, Integer.valueOf(type), lineNumber, enabled, ignoreCount, condition);
    return new MRSCLineBreakpoint(resource, attributes, register);
  }
}
