/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package breakpoint;

import java.text.MessageFormat;
import java.util.HashMap;

import org.eclipse.cdt.debug.internal.core.breakpoints.BreakpointMessages;
import org.eclipse.cdt.debug.internal.core.breakpoints.CLineBreakpoint;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class MRSCLineBreakpoint extends CLineBreakpoint {
	public MRSCLineBreakpoint(IResource resource, HashMap<String, Object> attributes, boolean register)
			throws CoreException {
		super(resource, attributes, register);
	}

	protected String getMarkerMessage() throws CoreException {
		IMarker marker = getMarker();
		int bp_line = 0;
		int bp_request_line = 0;
		String bp_file = null;
		String bp_reqest_file = null;
		if (marker != null) {
			bp_line = marker.getAttribute("lineNumber", -1);
			bp_request_line = marker.getAttribute("requestedLine", -1);
			bp_file = marker.getAttribute("org.eclipse.cdt.debug.core.sourceHandle", null);
			bp_reqest_file = marker.getAttribute("requestedSourceHandle", null);
		}
		if ((bp_line != bp_request_line) || ((bp_file == null) && (bp_reqest_file != null))
				|| ((bp_file != null) && (!bp_file.equals(bp_reqest_file)))) {
			return MessageFormat.format(BreakpointMessages.getString("CLineBreakpoint.1"),
					new String[] { MRSCDebugUtils.getBreakpointText(this, false) });
		}
		return MessageFormat.format(BreakpointMessages.getString("CLineBreakpoint.0"),
				new String[] { MRSCDebugUtils.getBreakpointText(this, false) });
	}
}