/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package breakpoint;

import java.util.Iterator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class RulerAddSwBreakpointAction
  extends Action
  implements IUpdate
{
  private IBreakpoint fBreakpoint;
  private ITextEditor fEditor;
  private IVerticalRulerInfo fRulerInfo;
  
  public RulerAddSwBreakpointAction(ITextEditor editor, IVerticalRulerInfo info)
  {
    this.fEditor = editor;
    this.fRulerInfo = info;
  }
  
  public RulerAddSwBreakpointAction(IWorkbenchPart disassemblyPart, IDocument document, IVerticalRulerInfo rulerInfo) {}
  
  public void run()
  {
    IResource file = getResource(this.fEditor);
    if (file == null) {
      return;
    }
    int line = this.fRulerInfo.getLineOfLastMouseButtonActivity();
    if (line == -1) {
      return;
    }
    addSoftwareBreakpoint(file, line + 1);
  }
  
  protected void addSoftwareBreakpoint(IResource file, int line)
  {
    try
    {
    	MRSCDIDebugModel.createLineBreakpoint(file.getLocation().toOSString(), file, 4, 
        line, true, 0, "", true);
    }
    catch (CoreException localCoreException) {}
  }
  
  protected IBreakpoint getBreakpoint()
  {
    IAnnotationModel annotationModel = this.fEditor.getDocumentProvider().getAnnotationModel(this.fEditor.getEditorInput());
    IDocument document = this.fEditor.getDocumentProvider().getDocument(this.fEditor.getEditorInput());
    if (annotationModel != null)
    {
      Iterator<?> iterator = annotationModel.getAnnotationIterator();
      while (iterator.hasNext())
      {
        Object object = iterator.next();
        if ((object instanceof SimpleMarkerAnnotation))
        {
          SimpleMarkerAnnotation markerAnnotation = (SimpleMarkerAnnotation)object;
          IMarker marker = markerAnnotation.getMarker();
          try
          {
            if (marker.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER))
            {
              Position position = annotationModel.getPosition(markerAnnotation);
              int line = document.getLineOfOffset(position.getOffset());
              if (line == this.fRulerInfo.getLineOfLastMouseButtonActivity())
              {
                IBreakpoint breakpoint = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
                if (breakpoint != null) {
                  return breakpoint;
                }
              }
            }
          }
          catch (CoreException localCoreException) {}catch (BadLocationException localBadLocationException) {}
        }
      }
    }
    return null;
  }
  
  protected static IResource getResource(IWorkbenchPart part)
  {
    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
    if ((part instanceof IEditorPart))
    {
      IEditorInput editorInput = ((IEditorPart)part).getEditorInput();
      IResource resource = null;
      if ((editorInput instanceof IFileEditorInput)) {
        resource = ((IFileEditorInput)editorInput).getFile();
      }
      if (resource != null) {
        return resource;
      }
      ILocationProvider provider = (ILocationProvider)editorInput.getAdapter(ILocationProvider.class);
      if (provider != null)
      {
        IPath location = provider.getPath(editorInput);
        if (location != null)
        {
          IFile[] files = root.findFilesForLocation(location);
          if (files.length > 0) {
            return files[0];
          }
        }
      }
    }
    return root;
  }
  
  public void update()
  {
    this.fBreakpoint = getBreakpoint();
    setEnabled(this.fBreakpoint == null);
    setText("Toggle &Software Breakpoint");
  }
}
