/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package build;

import java.util.ArrayList;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.internal.ui.commands.BuildConfigurationsJob;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.ide.actions.BuildUtilities;

public abstract class AbstractBuildHandler extends AbstractHandler {
	protected ArrayList<IProject> projects = null;

	protected void setBaseEnabled(boolean state) {
		super.setBaseEnabled(state);
	}

	public void setEnabled(Object context) {
		ISelection selection = getSelection(context);
		this.projects = getSelectedCdtProjects(selection);
		setBaseEnabled(this.projects.size() > 0);
	}

	protected ISelection getSelection(Object context) {
		Object s = HandlerUtil.getVariable(context, "selection");
		if ((s instanceof ISelection)) {
			return (ISelection) s;
		}
		return null;
	}

	public static ArrayList<IProject> getSelectedCdtProjects(ISelection selection) {
		ArrayList<IProject> projects = new ArrayList();
		if ((selection != null) && (!selection.isEmpty()) && ((selection instanceof IStructuredSelection))) {
			Object[] selected = ((IStructuredSelection) selection).toArray();
			if (selected.length > 0) {
				Object[] arrayOfObject1;
				int j = (arrayOfObject1 = selected).length;
				for (int i = 0; i < j; i++) {
					Object sel = arrayOfObject1[i];
					IProject prj = null;
					if ((sel instanceof IProject)) {
						prj = (IProject) sel;
					} else if ((sel instanceof ICProject)) {
						prj = ((ICProject) sel).getProject();
					} else if ((sel instanceof ICContainer)) {
						IContainer resource = ((ICContainer) sel).getResource();
						if (resource != null) {
							prj = resource.getProject();
						}
					} else if ((sel instanceof ITranslationUnit)) {
						IResource resource = ((ITranslationUnit) sel).getResource();
						if (resource != null) {
							prj = resource.getProject();
						}
					} else if ((sel instanceof IFile)) {
						prj = ((IFile) sel).getProject();
					}
					if ((prj != null) && (prj.isOpen()) && (CoreModel.getDefault().isNewStyleProject(prj))
							&& (!projects.contains(prj))) {
						try {
							if ((prj.hasNature("org.eclipse.cdt.core.cnature"))
									|| (prj.hasNature("org.eclipse.cdt.core.ccnature"))) {
								projects.add(prj);
							}
						} catch (CoreException localCoreException) {
						}
					}
				}
			}
		}
		return projects;
	}

	protected void executeHandler(int cleanKind, int buildKind) throws ExecutionException {
		CUIPlugin.getDefault().startGlobalConsole();
		for (IProject project : this.projects) {
			ICProjectDescription prjd = CoreModel.getDefault().getProjectDescription(project, false);
			if (prjd != null) {
				ICConfigurationDescription[] cfgds = new ICConfigurationDescription[1];
				cfgds[0] = prjd.getActiveConfiguration();
				if ((cfgds != null) && (cfgds.length > 0)) {
					ArrayList<IProject> saveProjects = new ArrayList();
					saveProjects.add(project);
					BuildUtilities.saveEditors(saveProjects);

					Job cleanFilesJob = new BuildConfigurationsJob(cfgds, cleanKind, buildKind);
					cleanFilesJob.schedule();
				}
			}
		}
	}
}