/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package build;


import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class BuildUtil {
	public static void cleanProject(final String projectName) {
		Job job2 = new Job("Clean Project") {
			protected IStatus run(IProgressMonitor monitor) {
				try {
					IWorkspace workspace = ResourcesPlugin.getWorkspace();
					IProject project = workspace.getRoot().getProject(projectName);
					project.build(15, new NullProgressMonitor());
					project.refreshLocal(IResource.DEPTH_INFINITE, new NullProgressMonitor());
				} catch (CoreException e) {
					e.printStackTrace();
				}
				return Status.OK_STATUS;
			}
		};
		job2.schedule();
	}

	public static void buildProject(final String projectName) {
		Job job2 = new Job("Build Project") {
			protected IStatus run(IProgressMonitor monitor) {
				try {
					IWorkspace workspace = ResourcesPlugin.getWorkspace();

					IProject project = workspace.getRoot().getProject(projectName);
					project.build(6, new NullProgressMonitor());
					project.refreshLocal(IResource.DEPTH_INFINITE, new NullProgressMonitor());
				} catch (CoreException e) {
					e.printStackTrace();
				}
				return Status.OK_STATUS;
			}
		};
		job2.schedule();
	}

	public static void IncrementalBuildProject(final String projectName) {
		Job job2 = new Job("Incremental Build Project") {
			protected IStatus run(IProgressMonitor monitor) {
				try {
					IWorkspace workspace = ResourcesPlugin.getWorkspace();

					IProject project = workspace.getRoot().getProject(projectName);
					project.build(10, new NullProgressMonitor());
					project.refreshLocal(IResource.DEPTH_INFINITE, new NullProgressMonitor());
				} catch (CoreException e) {
					e.printStackTrace();
				}
				return Status.OK_STATUS;
			}
		};
		job2.schedule();
	}

	public static void rebuildProject(final String projectName) {
		saveContent();
		Job job2 = new Job("Rebuild Project") {
			protected IStatus run(IProgressMonitor monitor) {
				Display.getDefault().asyncExec(new Runnable() {
					public void run() {
						IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
						ProgressMonitorDialog dialog = new ProgressMonitorDialog(window.getShell());
						IRunnableWithProgress runnable = new IRunnableWithProgress() {
							public void run(IProgressMonitor progressMonitor)
									throws InvocationTargetException, InterruptedException {
								IWorkspace workspace = ResourcesPlugin.getWorkspace();
								try {
									IProject project = workspace.getRoot().getProject(projectName);
									progressMonitor.beginTask(NLS.bind("Rebuilding \"{0}\"", project.getName()), 5);

									IProgressMonitor subClean = Policy.subMonitorFor(progressMonitor, 1);
									project.build(15, subClean);

									IProgressMonitor subBuild = Policy.subMonitorFor(progressMonitor, 4);
									project.build(6, subBuild);
									project.refreshLocal(IResource.DEPTH_INFINITE, new NullProgressMonitor());
								} catch (CoreException e) {
									e.printStackTrace();
								}
								progressMonitor.done();
							}
						};
						try {
							dialog.run(true, true, runnable);
						} catch (InterruptedException localInterruptedException) {
						} catch (InvocationTargetException e) {
							MessageDialog.openError(null, "Error", e.getMessage());
						}
					}
				});
				return Status.OK_STATUS;
			}
		};
		job2.schedule();
	}

	private static void saveContent() {

		Display display = Display.getDefault();
		if (!display.isDisposed()) {
			Runnable runnable = new Runnable() {

				@Override
				public void run() {
					// TODO Auto-generated method stub
					PlatformUI.getWorkbench().saveAllEditors(false);
				}
			};
			display.syncExec(runnable);
		}
	}
}
