/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package build;

import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IServiceLocator;
import org.osgi.framework.Constants;

import autoStart.Messages;
import importOperation.ImportUtil;

public class RefreshUtil {
	public static void refreshWorkspace() {
		for(IProject project : ResourcesPlugin.getWorkspace().getRoot().getProjects()){
		    try {
				project.refreshLocal(IResource.DEPTH_INFINITE, new NullProgressMonitor());
			} catch (CoreException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}
	
	
	
	public static void refreshProject(IProject project) {
		Job j=new Job("Update Resource") {
			
			@Override
			protected IStatus run(IProgressMonitor monitor) {
				// TODO Auto-generated method stub
				
				Display display=Display.getDefault();
				if(!display.isDisposed()){
					Runnable runnable=new Runnable(){
						public void run(){
						//Ĵ
							PlatformUI.getWorkbench().saveAllEditors(false);
							try {
								
								project.close(new NullProgressMonitor());
								
								project.open(new NullProgressMonitor());
							} catch (CoreException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
						}
					};
					display.syncExec(runnable);
				}
				return Status.OK_STATUS;
			}
		};
		j.schedule(500);
		
		Job j1=new Job("Refresh") {
			
			@Override
			protected IStatus run(IProgressMonitor monitor) {
				// TODO Auto-generated method stub
				Display display=Display.getDefault();
				if(!display.isDisposed()){
					Runnable runnable=new Runnable(){
						public void run(){
						
							try {
								project.refreshLocal(IResource.DEPTH_INFINITE, new NullProgressMonitor());
								
							} catch (CoreException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
						}
					};
					display.syncExec(runnable);
				}
				
				return Status.OK_STATUS;
			}
		};
		j1.schedule(500);
		
	}
	
	
	
	
}
