package common;


import java.util.Locale;



public class DeviceUtil {
	
	public static final int OS_WINDOWS = 1;
	public static final int OS_LINUX = 2;
	public static final int OS_MAC = 3;
	public static final int OS_UNKNOW = 0;
	  
	
	public static void main(String[] args) {
		System.out.println(getWindowsArch());
	}

	public static int getOS(){
	    int type = 1;
	    String osName = System.getProperty("os.name").toLowerCase(Locale.US);
	    if (osName.indexOf("linux") >= 0) {
	      type = 2;
	    } else if (osName.indexOf("windows") >= 0) {
	      type = 1;
	    } else if ((osName.indexOf("mac") >= 0) && (osName.indexOf("os") >= 0)) {
	      type = 3;
	    } else {
	      type = 0;
	    }
	    return type;
	}
	
	public static boolean isWindowsOrLinux() {
		return getOS()==OS_WINDOWS || getOS()==OS_LINUX;
	}
	
	public static String getOsVersion() {
		return System.getProperty("os.version");
	}
	
	public static String getOsType() {
		int os=getOS();
		String oString=null;
		if(os==OS_WINDOWS) {
			oString="WINDOWS"; //$NON-NLS-1$
		}else if (os==OS_LINUX) {
			oString="LINUX"; //$NON-NLS-1$
		}else if (os==OS_MAC) {
			oString="MACOS"; //$NON-NLS-1$
		}
		return oString;
	}
	
	
	
	public static String getOsBitness() {
		int os=getOS();
		if(os==OS_WINDOWS) {
			return getWindowsArch();
		}else if(os==OS_LINUX){
			String s=getOsArch();
			if(s.endsWith("64")) {
				return "64";
			}else {
				return "32";
			}
		}
		return "32";
	}
	
	
	public static String getOsArch() {
		
		return System.getProperty("os.arch");
	}
	
	//https://stackoverflow.com/questions/4748673/how-can-i-check-the-bitness-of-my-os-using-java-j2se-not-os-arch
	private static String getWindowsArch() {
		String arch = System.getenv("PROCESSOR_ARCHITECTURE");
		String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");

		String realArch = arch != null && arch.endsWith("64")
		                  || wow64Arch != null && wow64Arch.endsWith("64")
		                      ? "64" : "32";
		return realArch;
	}
	
}
