package common;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import com.alibaba.fastjson.JSONReader;
import com.alibaba.fastjson.JSONWriter;

public class LocalTool {
public static <T> void writeJsonObject(File file,T t)throws IOException{
		
		if (file == null || !file.exists()) {
			return;
		}
		
		FileWriter writer;
		writer = new FileWriter(file);
		JSONWriter jsonWriter=new JSONWriter(writer);
		jsonWriter.writeValue(t);
		jsonWriter.close();
		writer.close();
	}
	
	public static <T> T readJsonObject(File file,Class<T> aClass) throws Exception {
		if (file == null || !file.exists()) {
			return null;
		}
		
		FileReader reader=new FileReader(file);
		JSONReader jsonReader=new JSONReader(reader);
		T t=jsonReader.readObject(aClass);
		jsonReader.close();
		reader.close();
		return t;
	}
}
