package common;

import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;

public class NetworkHardwareUtil {

    public static void main(String[] args) {
        
        System.out.println(getCombinedIDString());

    }
    
    public static String getCombinedIDString() {
    	
    	return sort(getNetworkMAC());
    }
    
    private static String sort(List<String> macs) {
    	if(macs==null || macs.size()==0) {
    		return null;
    	}
    	macs.sort(new Comparator<String>() {

			@Override
			public int compare(String o1, String o2) {
				// TODO Auto-generated method stub
				return o1.compareTo(o2);
			}
		});
    	
    	return macs.toString();
    }

    private static List<String> getNetworkMAC(){
        List<String> macs = new ArrayList<>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();

            while (networkInterfaces.hasMoreElements()){
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                List<InterfaceAddress> interfaceAddresses = networkInterface.getInterfaceAddresses();
                for (InterfaceAddress interfaceAddress : interfaceAddresses) {
                    InetAddress inetAddress = interfaceAddress.getAddress();
                    if(inetAddress==null){
                        continue;
                    }
                    NetworkInterface netInterface = NetworkInterface.getByInetAddress(inetAddress);
                    if(netInterface==null){
                        continue;
                    }

                    byte[] hardwareAddress = netInterface.getHardwareAddress();
                    if(hardwareAddress==null){
                        continue;
                    }
                    String s = arrayToHexString(hardwareAddress);
                    if(s==null){
                        continue;
                    }
                    
                    if(netInterface.isLoopback()) {
                    	continue;
                    }
                    macs.add(s);
                    System.out.println("*******************"+networkInterface.getDisplayName()+"("+networkInterface.getName()+")");
                    System.out.println("Virtual:"+netInterface.isVirtual());
                    System.out.println("Up:"+netInterface.isUp());
                    System.out.println("Loopback:"+netInterface.isLoopback());
                    System.out.println("IP:"+inetAddress.toString());
                    System.out.println("MAC:"+s);
                }

            }
        } catch (SocketException e) {
            e.printStackTrace();
        }
        return macs.stream().distinct().collect(Collectors.<String>toList());
    }


    private static String arrayToHexString(byte[] bytes) {
        if(bytes==null) {
            return null;
        }
        StringBuilder builder=new StringBuilder();
        for (int i = 0; i < bytes.length; i++) {
            byte b = bytes[i];
            String string=Integer.toHexString(b & 0xff);
            if(string.length()==1) {
                builder.append("0");
            }
            builder.append(string);
            if(i!=bytes.length-1) {
                builder.append(":");
            }
        }
        return builder.toString();
    }

}
