package common;

import java.io.File;
import java.io.IOException;
import java.util.UUID;

import com.alibaba.fastjson.annotation.JSONField;



public class UserIdentifyUtil {

	private static final String MRS_ID=".mrs-id";
	
	public static void main(String[] args) {
		System.out.println("Unique ID :"+getUniqueID());
	}
	
	
	
	public static String getUniqueID() {
		try {
			checkFile();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}
		
		Entity entity=null;
		try {
			entity = LocalTool.readJsonObject(getFile(), Entity.class);
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if(entity!=null) {
			return entity.getId();
		}
		return null;
	}
	
	private static File getFile() {
		String home=getCurrentUserHome();
		File target=new File(home,MRS_ID);
		return target;
	}
	
	private static void checkFile() throws Exception{

		File target=getFile();
		if(target.exists()) {
			Entity tEntity=null;
			
			tEntity=LocalTool.readJsonObject(target, Entity.class);
			
			if(tEntity!=null && tEntity.getId()!=null && !tEntity.getId().equals("")) {
				//correct format
				return;
			}
			target.delete();
		}
		//not found or incorrect format,create new file
		target.createNewFile();
		//get networkInterface id
		String local=NetworkHardwareUtil.getCombinedIDString();
		if(local==null || "".equals(local)) {
			LogUtil.d("Failed to get identity information");
			//create new id
			local=UUID.randomUUID().toString();
		}
		//MD5 encrypt
		String encryptString=MD5CheckUtil.MD5Encrypt(local);
		
		LocalTool.writeJsonObject(target, new Entity(encryptString));
	}
	
	
	private static String getCurrentUserHome() {
		return System.getProperty("user.home");
	}
	

	public static class Entity{
		@JSONField(name="id")
		String id;
		
		

		public Entity(String id) {
			super();
			this.id = id;
		}

		public String getId() {
			return id;
		}

		public void setId(String id) {
			this.id = id;
		}
		
	}
}
