/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package convert;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import convertProjectUtil.ResultFileUtil;
import convertProjectUtil.XmlParseUtil;
import importOperation.ImportUtil;

public class ConvertProjectImp {
	private static final String NEWLINE = System.getProperty("line.separator", "\n"); //$NON-NLS-1$ //$NON-NLS-2$
	private static String exePath = ""; //$NON-NLS-1$
	private static String templatePath = ""; //$NON-NLS-1$
	private static String tempFilePath = ""; //$NON-NLS-1$
	private static String projectFile = ""; //$NON-NLS-1$
//	private static String ldFile = ""; //$NON-NLS-1$
	private static String proLibPath = ""; //$NON-NLS-1$

	private static String keilProjectFile = ""; //$NON-NLS-1$
	public static String projectName = ""; //$NON-NLS-1$
	private static String projectPath = ""; //$NON-NLS-1$

	public static boolean autoImport = false;
	public static boolean needCompare = false;
	public static String suffix_compare_folder = "_temp"; //$NON-NLS-1$

	public static boolean RESULT = false;
	public static boolean SHOWLOG = false;

	public static String logFilePath = "";

	public static void ConvertKeilProject(String type, String srcKeilProjectPath, String dstProjectName,
			String dstProjectPath, boolean autoImport, boolean compare) throws Exception {
		// srcKeilProjectPath  .uvproj·
		// ӦdstProjectPath½Ŀ
		String installPath = Platform.getInstallLocation().getURL().getPath().replaceFirst("/", "").replace("/", "\\"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
		String workPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString().replace("/", "\\"); //$NON-NLS-1$ //$NON-NLS-2$

		keilProjectFile = srcKeilProjectPath;
		projectName = dstProjectName;
		projectPath = dstProjectPath;
		needCompare = compare;

		templatePath = installPath + "template"; //$NON-NLS-1$
		tempFilePath = installPath + "ExTool" + File.separator + "keil.ini"; //$NON-NLS-1$ //$NON-NLS-2$
		projectFile = dstProjectPath + File.separator + dstProjectName + File.separator + dstProjectName + ".wvproj"; //$NON-NLS-1$
//		ldFile = dstProjectPath + File.separator + dstProjectName + File.separator + ".ld"; //$NON-NLS-1$
		exePath = installPath + "ExTool" + File.separator + "ConvertProject.exe"; //$NON-NLS-1$ //$NON-NLS-2$
		proLibPath = installPath + "ProLib" + File.separator + type; //$NON-NLS-1$

		RESULT = false;
		SHOWLOG = false;
		logFilePath = installPath + "ExTool" + File.separator + "ImportKeilProj.log";
		////////
		preDeleteFile();
		checkValid(srcKeilProjectPath, dstProjectName, dstProjectPath);
		doSomething();
		callExe(exePath, projectPath + File.separator + projectName, proLibPath);
		showMonitorProgress(type, dstProjectName, dstProjectPath, autoImport);

	}

	private static void checkValid(String srcKeilProjectPath, String dstProjectName, String dstProjectPath)
			throws Exception {
		// TODO Auto-generated method stub
		File file1 = new File(srcKeilProjectPath);
		if (!file1.exists()) {
			throw new Exception(srcKeilProjectPath + " " + Messages.ConvertProjectImp_25); //$NON-NLS-1$
		}

		File file2 = new File(dstProjectPath + File.separator + dstProjectName);
		if (file2.exists()) {
			throw new Exception(dstProjectPath + File.separator + dstProjectName + " " + Messages.ConvertProjectImp_27); //$NON-NLS-1$
		}
		File file3 = new File(exePath);
		if (!file3.exists()) {
			throw new Exception(exePath + " " + Messages.ConvertProjectImp_29); //$NON-NLS-1$
		}

		File file4 = new File(proLibPath);
		if (!file4.exists()) {
			throw new Exception(proLibPath + " " + Messages.ConvertProjectImp_31); //$NON-NLS-1$
		}
	}

	private static void showMonitorProgress(String type, String dstProjectName, String dstProjectPath,
			boolean autoImport) throws Exception {

		IRunnableWithProgress runnable = new IRunnableWithProgress() {

			@Override
			public void run(IProgressMonitor arg0) throws InvocationTargetException, InterruptedException {
				// TODO Auto-generated method stub
				arg0.beginTask(Messages.ConvertProjectImp_32, IProgressMonitor.UNKNOWN);
				// ״̬
				boolean ok = false;
				int count = 0;
				while (count < 30 && !ok && !arg0.isCanceled()) {
					Thread.sleep(1000);
					ok = checkFinished();
					count++;
				}
				if (arg0.isCanceled()) {
					return;
				}
				RESULT = ok;
				if (ok && autoImport) {
					try {
						
						// Shield since V1.60 because encoding plugin can auto detect now.
//						addEncoding();// add encoding gbk
						ImportUtil.importProjectFromFolder(dstProjectPath + File.separator + dstProjectName,
								new NullProgressMonitor(), null);
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
						arg0.done();
					}
				} else if (!ok) {
					arg0.done();
					showMessage(Messages.ConvertProjectImp_33);
				}
				arg0.done();
			}
		};
		ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(null);
		progressMonitorDialog.setCancelable(false);
		progressMonitorDialog.run(true, true, runnable);
	}

	private static void doSomething() throws Exception {
		File file = new File(keilProjectFile);
		if (!file.exists()) {
			throw new Exception(keilProjectFile + " " + Messages.ConvertProjectImp_37); //$NON-NLS-1$
		}
		XmlParseUtil.getInstance().parseXml(file, projectName, projectPath, needCompare);
	}

	private static void addEncoding() throws Exception {
		// org.eclipse.core.resources.prefs, set project encoding utf-8
		File fileRes = new File(projectPath + File.separator + projectName + File.separator + ".settings"
				+ File.separator + "org.eclipse.core.resources.prefs");
		if (!fileRes.exists()) {
			fileRes.createNewFile();
		}
		BufferedWriter bw = new BufferedWriter(new FileWriter(fileRes));
		bw.write("eclipse.preferences.version=1" + NEWLINE + "encoding/<project>=UTF-8");
		bw.flush();
		bw.close();
	}
	
	private static boolean checkFinished() {
		File file = new File(tempFilePath);
		if (file.exists()) {
			try {
				SHOWLOG = ResultFileUtil.needShowLog(tempFilePath);
			} catch (Exception e) {
				e.printStackTrace();
			}
			file.delete();
			return true;
		}
		return false;
	}

	private static void preDeleteFile() {
		File file = new File(tempFilePath);
		if (file.exists()) {
			file.delete();
		}
	}

	private static void callExe(String exePath, String dstProjectPath, String prolibPath) {
		List<String> commandsList = new ArrayList<>();
		commandsList.add(exePath);
		commandsList.add(dstProjectPath);
		commandsList.add(prolibPath);
		ProcessBuilder pBuilder = new ProcessBuilder("k1"); //$NON-NLS-1$
		pBuilder.command(commandsList);
		try {
			pBuilder.start();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	private static void showMessage(String message) {
		Display display = Display.getDefault();
		if (!display.isDisposed()) {
			Runnable runnable = new Runnable() {
				public void run() {
					// Ĵ
					MessageDialog.openWarning(new Shell(), Messages.ConvertProjectImp_42, message);
				}
			};
			display.syncExec(runnable);
		}
	}
}
