/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package convert;

import java.util.HashMap;
import java.util.LinkedHashMap;

public class KeilProjectDefine {
	private static HashMap<String, String> templateMap=new LinkedHashMap<String, String>();
	private static HashMap<String, String> descpitionMap=new LinkedHashMap<String, String>();
	
	static {
		templateMap.put("CH32V103", "CH32V103.zip");
		descpitionMap.put("CH32V103", "CH32V103 chip description");
	}
	
	public static String getKeilTemplateName(String projectType) {
		if(templateMap==null || templateMap.isEmpty()) {
			return null;
		}
		if(templateMap.containsKey(projectType)) {
			return templateMap.getOrDefault(projectType, null);
		}
		return null;
	}
	
	public static String getChipDescrption(String projectType) {
		if(descpitionMap==null || descpitionMap.isEmpty()) {
			return "";
		}
		if(descpitionMap.containsKey(projectType)) {
			return descpitionMap.getOrDefault(projectType, "");
		}
		return "";
	}
	
	
	public static HashMap<String, String> getMap() {
		return templateMap;
	}
}
