/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package convert;

import java.util.Iterator;
import java.util.List;
import java.util.Map.Entry;

import org.jdom2.Document;

import convertProjectUtil.XmlMofidyUtil;
import xmlbean.EAdditionalInput;
import xmlbean.EAutoDiscovery;
import xmlbean.EBuilder;
import xmlbean.ECConfiguration;
import xmlbean.ECProject;
import xmlbean.EConfiguration;
import xmlbean.EExtension;
import xmlbean.EExtensions;
import xmlbean.EExternalSettings;
import xmlbean.EFolderInfo;
import xmlbean.EInputType;
import xmlbean.EListOptionValue;
import xmlbean.EOption;
import xmlbean.EProject;
import xmlbean.EResource;
import xmlbean.EScannerConfigBuildInfo;
import xmlbean.ESourceEntries;
import xmlbean.EStorageModule;
import xmlbean.ETargetPlatform;
import xmlbean.ETool;
import xmlbean.EToolChain;
import xmlbean.EclipseInfoEntry;
import xmlbean.Element;

public class NewCProjectFileCreator {
	
	private static NewCProjectFileCreator creator;
	
	public static NewCProjectFileCreator getInstance() {
		if(creator==null) {
			synchronized (NewCProjectFileCreator.class) {
				creator=new NewCProjectFileCreator();
			}
		}
		return creator;
	}
	
	
	//ch32v103_v1.1
	public Document createStanard(EclipseInfoEntry entry) {
		Document document=new Document();
		org.jdom2.Element element=getElementFromEElement(generate(entry));
		
		document.setRootElement(element);
		return document;
	}
	
	private ECProject generate(EclipseInfoEntry entry) {
		ECProject cProject=new ECProject();
		cProject.setAttribute("storage_type_id", "org.eclipse.cdt.core.XmlProjectDescriptionStorage");
		
		EStorageModule storageModule1;
		{
			storageModule1=new EStorageModule();
			storageModule1.setAttribute("moduleId", "org.eclipse.cdt.core.settings");
			
			ECConfiguration cconfiguration=new ECConfiguration();
			cconfiguration.setAttribute("id", "ilg.gnumcueclipse.managedbuild.cross.riscv.config.elf.release.1008047074");
			
			EStorageModule storageModule2;
			{
				storageModule2=new EStorageModule();
				storageModule2.setAttribute("buildSystemId", "org.eclipse.cdt.managedbuilder.core.configurationDataProvider");
				storageModule2.setAttribute("id", "ilg.gnumcueclipse.managedbuild.cross.riscv.config.elf.release.1008047074");
				storageModule2.setAttribute("moduleId", "org.eclipse.cdt.core.settings");
				storageModule2.setAttribute("name", "obj");
				
				EExternalSettings eExternalSettings=new EExternalSettings();
				
				EExtensions extensions=new EExtensions();
				
				EExtension extension1=new EExtension();
				extension1.setAttribute("id", "org.eclipse.cdt.core.ELF");
				extension1.setAttribute("point", "org.eclipse.cdt.core.BinaryParser");
				
				EExtension extension2=new EExtension();
				extension2.setAttribute("id", "org.eclipse.cdt.core.GASErrorParser");
				extension2.setAttribute("point", "org.eclipse.cdt.core.ErrorParser");
				
				EExtension extension3=new EExtension();
				extension3.setAttribute("id", "org.eclipse.cdt.core.GmakeErrorParser");
				extension3.setAttribute("point", "org.eclipse.cdt.core.ErrorParser");
				
				EExtension extension4=new EExtension();
				extension4.setAttribute("id", "org.eclipse.cdt.core.GLDErrorParser");
				extension4.setAttribute("point", "org.eclipse.cdt.core.ErrorParser");
				
				EExtension extension5=new EExtension();
				extension5.setAttribute("id", "org.eclipse.cdt.core.CWDLocator");
				extension5.setAttribute("point", "org.eclipse.cdt.core.ErrorParser");
				
				EExtension extension6=new EExtension();
				extension6.setAttribute("id", "org.eclipse.cdt.core.GCCErrorParser");
				extension6.setAttribute("point", "org.eclipse.cdt.core.ErrorParser");
				
				extensions.addChild(extension1);
				extensions.addChild(extension2);
				extensions.addChild(extension3);
				extensions.addChild(extension4);
				extensions.addChild(extension5);
				extensions.addChild(extension6);
				
				storageModule2.addChild(eExternalSettings);
				storageModule2.addChild(extensions);
			}
			
			EStorageModule storageModule3;
			
			{
				storageModule3=new EStorageModule();
				storageModule3.setAttribute("moduleId", "cdtBuildSystem");
				storageModule3.setAttribute("version", "4.0.0");
				
				EConfiguration configuration=new EConfiguration();
				configuration.setAttribute("artifactName", "${ProjName}");
				configuration.setAttribute("buildArtefactType", "org.eclipse.cdt.build.core.buildArtefactType.exe");
				configuration.setAttribute("buildProperties", "org.eclipse.cdt.build.core.buildArtefactType=org.eclipse.cdt.build.core.buildArtefactType.exe,org.eclipse.cdt.build.core.buildType=org.eclipse.cdt.build.core.buildType.release");
				configuration.setAttribute("cleanCommand", "${cross_rm} -rf");
				configuration.setAttribute("description", "");
				configuration.setAttribute("id", "ilg.gnumcueclipse.managedbuild.cross.riscv.config.elf.release.1008047074");
				configuration.setAttribute("name", "obj");
				configuration.setAttribute("parent", "ilg.gnumcueclipse.managedbuild.cross.riscv.config.elf.release");
				
				EFolderInfo folderInfo=new EFolderInfo();
				folderInfo.setAttribute("id", "ilg.gnumcueclipse.managedbuild.cross.riscv.config.elf.release.1008047074.");
				folderInfo.setAttribute("name", "/");
				folderInfo.setAttribute("resourcePath", "");
				
				EToolChain toolChain;
				{
					toolChain=new EToolChain();
					toolChain.setAttribute("id", "ilg.gnumcueclipse.managedbuild.cross.riscv.toolchain.elf.release.231146001");
					toolChain.setAttribute("name", "RISC-V Cross GCC");
					toolChain.setAttribute("superClass", "ilg.gnumcueclipse.managedbuild.cross.riscv.toolchain.elf.release");
					//option
					
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.addtools.createflash.1311852988","Create flash image","ilg.gnumcueclipse.managedbuild.cross.riscv.option.addtools.createflash","true","boolean"));
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.addtools.createlisting.1983282875", "Create extended listing", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.addtools.createlisting", "true", "boolean"));
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.addtools.printsize.1000761142", "Print size", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.addtools.printsize", "true", "boolean"));
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.level.514997414", "Optimization Level", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.level", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.level.size", "enumerated"));
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.messagelength.1008570639", "Message length (-fmessage-length=0)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.messagelength", "true", "boolean"));
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.signedchar.467272439", "'char' is signed (-fsigned-char)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.signedchar", "true", "boolean"));
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.functionsections.2047756949", "Function sections (-ffunction-sections)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.functionsections", "true", "boolean"));
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.datasections.207613650", "Data sections (-fdata-sections)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.optimization.datasections", "true", "boolean"));
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.debugging.level.1204865254", "Debug level", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.debugging.level", null, null));
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.debugging.format.867779652", "Debug format", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.debugging.format", null, null));
					
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.isa.base.1900297968", "Architecture", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.isa.base", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.arch.rv32i", "enumerated"));
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.abi.integer.387605487", "Integer ABI", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.abi.integer", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.abi.integer.ilp32", "enumerated"));
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.isa.multiply.1509705449", "Multiply extension (RVM)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.isa.multiply", "true", "boolean"));
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.isa.compressed.1038505275", "Compressed extension (RVC)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.target.isa.compressed", "true", "boolean"));
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.toolchain.name.1218760634", null, "ilg.gnumcueclipse.managedbuild.cross.riscv.option.toolchain.name", "GNU MCU RISC-V GCC", "string"));
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.prefix.103341323", "Prefix", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.prefix", "riscv-none-embed-", "string"));
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.c.487601824", "C compiler", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.c", "gcc", "string"));
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.cpp.1062130429", "C++ compiler", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.cpp", "g++", "string"));
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.ar.1194282993", "Archiver", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.ar", "ar", "string"));
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.objcopy.1529355265", "Hex/Bin converter", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.objcopy", "objcopy", "string"));
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.objdump.1053750745", "Listing generator", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.objdump", "objdump", "string"));
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.size.1441326233", "Size command", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.size", "size", "string"));
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.make.550105535", "Build command", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.make", "make", "string"));
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.rm.719280496", "Remove command", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.command.rm", "rm", "string"));
					toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.toolchain.id.226017994", null, "ilg.gnumcueclipse.managedbuild.cross.riscv.option.toolchain.id", "512258282", "string"));
					//toolChain.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.warnings.allwarn.2008556321", "Enable all common warnings (-Wall)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.warnings.allwarn", "false", "boolean"));
					
					ETargetPlatform targetPlatform=new ETargetPlatform();
					targetPlatform.setAttribute("archList", "all");
					targetPlatform.setAttribute("binaryParser", "org.eclipse.cdt.core.ELF");
					targetPlatform.setAttribute("id", "ilg.gnumcueclipse.managedbuild.cross.riscv.targetPlatform.1944008784");
					targetPlatform.setAttribute("isAbstract", "false");
					targetPlatform.setAttribute("osList", "all");
					targetPlatform.setAttribute("superClass", "ilg.gnumcueclipse.managedbuild.cross.riscv.targetPlatform");
					
					toolChain.addChild(targetPlatform);
					
					EBuilder builder=new EBuilder();
					
					//builder.setAttribute("buildPath", "${workspace_loc:/999}/Release");
					builder.setAttribute("buildPath", XmlMofidyUtil.getRightBuildPath(ConvertProjectImp.projectName));
					builder.setAttribute("id", "ilg.gnumcueclipse.managedbuild.cross.riscv.builder.1421508906");
					builder.setAttribute("keepEnvironmentInBuildfile", "false");
					builder.setAttribute("managedBuildOn", "true");
					builder.setAttribute("name", "Gnu Make Builder");
					if(entry!=null && entry.isParallelBuild()) {
						builder.setAttribute("parallelBuildOn", "true");
						builder.setAttribute("parallelizationNumber", "optimal");
					}
					builder.setAttribute("superClass", "ilg.gnumcueclipse.managedbuild.cross.riscv.builder");
					
					toolChain.addChild(builder);
					
					ETool tool1=getETool("ilg.gnumcueclipse.managedbuild.cross.riscv.tool.assembler.1244756189", "GNU RISC-V Cross Assembler", "ilg.gnumcueclipse.managedbuild.cross.riscv.tool.assembler");
					tool1.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.assembler.usepreprocessor.1692176068", "Use preprocessor", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.assembler.usepreprocessor", "false", "boolean"));
					
					EOption option1=getEOption("false", "false","ilg.gnumcueclipse.managedbuild.cross.riscv.option.assembler.include.paths.1034038285", "Include paths (-I)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.assembler.include.paths","true","includePath");
					/////////Assembler includes
					if(entry!=null) {
						List<String>pathsList=entry.getAssembleIncludePaths();
						for (int i = 0; i < pathsList.size(); i++) {
							option1.addChild(getEListOptionValue("false", pathsList.get(i)));
						}
					}
					
					//option1.addChild(getEListOptionValue("false", "\"../Startup\""));
					
					
					
					////////////////////////////
					
					
					tool1.addChild(option1);
					
					tool1.addChild(getEInputType("ilg.gnumcueclipse.managedbuild.cross.riscv.tool.assembler.input.126366858", "ilg.gnumcueclipse.managedbuild.cross.riscv.tool.assembler.input"));
					
					toolChain.addChild(tool1);
					
					ETool tool2=getETool("ilg.gnumcueclipse.managedbuild.cross.riscv.tool.c.compiler.1731377187", "GNU RISC-V Cross C Compiler", "ilg.gnumcueclipse.managedbuild.cross.riscv.tool.c.compiler");
					
					
					EOption option2=getEOption("false", "false", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.compiler.include.paths.1567947810", "Include paths (-I)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.compiler.include.paths","true","includePath");
					
					////////Compiler includes
					if(entry!=null) {
						List<String> CompilerList=entry.getCompilerIncludePaths();
						for (int i = 0; i < CompilerList.size(); i++) {
							option2.addChild(getEListOptionValue("false", CompilerList.get(i)));
						}
					}
					
					/*option2.addChild(getEListOptionValue("false", "\"../User\""));
					option2.addChild(getEListOptionValue("false", "\"../Peripheral/inc\""));
					option2.addChild(getEListOptionValue("false", "\"../Peripheral/src\""));
					option2.addChild(getEListOptionValue("false", "\"../Tune\""));
					option2.addChild(getEListOptionValue("false", "\"../Core\""));*/
					
					
					
					tool2.addChild(option2);
					
					tool2.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.compiler.std.2020844713", "Language standard", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.compiler.std", "true", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.compiler.std.gnu99","enumerated"));
					
					
					EOption option3=getEOption("false", "false", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.compiler.defs.177116515", "Defined symbols (-D)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.compiler.defs","true","definedSymbols");
					if(entry!=null) {
						List<String> DefineList=entry.getCompilerDefines();
						for (int i = 0; i < DefineList.size(); i++) {
							option3.addChild(getEListOptionValue("false", DefineList.get(i)));
						}
					}
					
					tool2.addChild(option3);
					
					tool2.addChild(getEInputType("ilg.gnumcueclipse.managedbuild.cross.riscv.tool.c.compiler.input.2036806839", "ilg.gnumcueclipse.managedbuild.cross.riscv.tool.c.compiler.input"));
					toolChain.addChild(tool2);
					
					toolChain.addChild(getETool("ilg.gnumcueclipse.managedbuild.cross.riscv.tool.cpp.compiler.1610882921", "GNU RISC-V Cross C++ Compiler", "ilg.gnumcueclipse.managedbuild.cross.riscv.tool.cpp.compiler"));
					//C Link
					ETool tool3=getETool("ilg.gnumcueclipse.managedbuild.cross.riscv.tool.c.linker.1620074387", "GNU RISC-V Cross C Linker", "ilg.gnumcueclipse.managedbuild.cross.riscv.tool.c.linker");
					tool3.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.linker.gcsections.194760422", "Remove unused sections (-Xlinker --gc-sections)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.linker.gcsections", "true", "boolean"));
					tool3.addChild(getEOption("false", "false", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.linker.paths.2057340378", "Library search path (-L)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.linker.paths","false","libPaths")
									.addChild(getEListOptionValue("false", "\"../\"")));
					tool3.addChild(getEOption("false", "false", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.linker.scriptfile.1390103472", "Script files (-T)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.linker.scriptfile","false","stringList")
							.addChild(getEListOptionValue("false", ".ld")));
					tool3.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.linker.nostart.913830613", "Do not use standard start files (-nostartfiles)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.linker.nostart", "true", "boolean"));
					tool3.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.linker.usenewlibnano.239404511", "Use newlib-nano (--specs=nano.specs)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.linker.usenewlibnano", "true", "boolean"));
					tool3.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.linker.usenewlibnosys.351964161", "Do not use syscalls (--specs=nosys.specs)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.linker.usenewlibnosys", "true", "boolean"));
					//2020/07/13 ޸.cprojectļ
					{
						
						/*tool3.addChild(getEOption("false","false","ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.linker.otherobjs.16994550"
													,"Other objects","ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.linker.otherobjs","false","userObjs")
								.addChild(getEListOptionValue("false", "\"${workspace_loc:/${ProjName}/User/CH32V103UFI.lib}\"")));*/
						
						tool3.addChild(getEOptionNoName("false","false","ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.linker.flags.1125808200","ilg.gnumcueclipse.managedbuild.cross.riscv.option.c.linker.flags",
								"false","stringList").addChild(getEListOptionValue("false", "--print-memory-usage")));
						
		
					}
					
					tool3.addChild(getEInputType("ilg.gnumcueclipse.managedbuild.cross.riscv.tool.c.linker.input.1859223768", "ilg.gnumcueclipse.managedbuild.cross.riscv.tool.c.linker.input")
									.addChildren(getEAdditionalInput("additionalinputdependency", "$(USER_OBJS)"),getEAdditionalInput("additionalinput", "$(LIBS)"))
									);
					toolChain.addChild(tool3);
					
					ETool tool4=getETool("ilg.gnumcueclipse.managedbuild.cross.riscv.tool.cpp.linker.1947503520", "GNU RISC-V Cross C++ Linker", "ilg.gnumcueclipse.managedbuild.cross.riscv.tool.cpp.linker");
					tool4.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.cpp.linker.gcsections.1689063433", "Remove unused sections (-Xlinker --gc-sections)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.cpp.linker.gcsections", "true", "boolean"));
					tool4.addChild(getEOptionNoValue("false", "false", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.cpp.linker.paths.1029177148", "Library search path (-L)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.cpp.linker.paths","libPaths")
									.addChild(getEListOptionValue("false", "\"../LD\"")));
					tool4.addChild(getEOptionNoValue("false", "false", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.cpp.linker.scriptfile.1751226764", "Script files (-T)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.cpp.linker.scriptfile","stringList")
							.addChild(getEListOptionValue("false", "Link.ld")));
					tool4.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.cpp.linker.nostart.642896175", "Do not use standard start files (-nostartfiles)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.cpp.linker.nostart",  "true", "boolean"));
					tool4.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.cpp.linker.usenewlibnano.1540675679", "Use newlib-nano (--specs=nano.specs)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.cpp.linker.usenewlibnano","true", "boolean"));
					
					toolChain.addChild(tool4);
					
					toolChain.addChild(getETool("ilg.gnumcueclipse.managedbuild.cross.riscv.tool.archiver.1292785366", "GNU RISC-V Cross Archiver", "ilg.gnumcueclipse.managedbuild.cross.riscv.tool.archiver"));
					toolChain.addChild(getETool("ilg.gnumcueclipse.managedbuild.cross.riscv.tool.createflash.1801165667", "GNU RISC-V Cross Create Flash Image", "ilg.gnumcueclipse.managedbuild.cross.riscv.tool.createflash"));
					toolChain.addChild(getETool("ilg.gnumcueclipse.managedbuild.cross.riscv.tool.createlisting.1356766765", "GNU RISC-V Cross Create Listing", "ilg.gnumcueclipse.managedbuild.cross.riscv.tool.createlisting")
										.addChildren(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.createlisting.source.2052761852", "Display source (--source|-S)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.createlisting.source", "true", "boolean")
													,getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.createlisting.allheaders.439659821", "Display all headers (--all-headers|-x)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.createlisting.allheaders", "true", "boolean")
													,getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.createlisting.demangle.67111865", "Demangle names (--demangle|-C)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.createlisting.demangle","true", "boolean")
													,getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.createlisting.linenumbers.1549373929", "Display line numbers (--line-numbers|-l)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.createlisting.linenumbers", "true", "boolean")
													,getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.createlisting.wide.1298918921", "Wide lines (--wide|-w)", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.createlisting.wide", "true", "boolean")));
					toolChain.addChild(getETool("ilg.gnumcueclipse.managedbuild.cross.riscv.tool.printsize.712424314", "GNU RISC-V Cross Print Size", "ilg.gnumcueclipse.managedbuild.cross.riscv.tool.printsize")
										.addChild(getEOption("ilg.gnumcueclipse.managedbuild.cross.riscv.option.printsize.format.1404031980", "Size format", "ilg.gnumcueclipse.managedbuild.cross.riscv.option.printsize.format")));
				}
				folderInfo.addChild(toolChain);
				ESourceEntries sourceEntries=new ESourceEntries();
				
				/*EEntry eEntry=new EEntry();
				eEntry.setAttribute("flags", "VALUE_WORKSPACE_PATH|RESOLVED");
				eEntry.setAttribute("kind", "sourcePath");
				eEntry.setAttribute("name", "");
				sourceEntries.addChild(eEntry);*/
				
				configuration.addChild(folderInfo);
				configuration.addChild(sourceEntries);
				storageModule3.addChild(configuration);
			}
			
			EStorageModule storageModule4=new EStorageModule();
			storageModule4.setAttribute("moduleId", "org.eclipse.cdt.core.externalSettings");
			
			EStorageModule storageModule5=new EStorageModule();
			storageModule5.setAttribute("moduleId", "ilg.gnumcueclipse.managedbuild.packs");
			
			cconfiguration.addChild(storageModule2);
			cconfiguration.addChild(storageModule3);
			cconfiguration.addChild(storageModule4);
			cconfiguration.addChild(storageModule5);
			
			storageModule1.addChild(cconfiguration);
			
		}
		
		EStorageModule storageModule2;
		{
			storageModule2=new EStorageModule();
			storageModule2.setAttribute("moduleId", "cdtBuildSystem");
			storageModule2.setAttribute("version", "4.0.0");
			
			EProject project1=new EProject();
			project1.setAttribute("id", "999.ilg.gnumcueclipse.managedbuild.cross.riscv.target.elf.275846018");
			//2020/06/10 
			project1.setAttribute("name","Executable file");
			project1.setAttribute("projectType","ilg.gnumcueclipse.managedbuild.cross.riscv.target.elf");
			
			storageModule2.addChild(project1);
		}
		
		EStorageModule storageModule3;
		{
			storageModule3=new EStorageModule();
			storageModule3.setAttribute("moduleId", "scannerConfiguration");
			
			EAutoDiscovery autoDiscovery1=new EAutoDiscovery();
			autoDiscovery1.setAttribute("enabled", "true");
			autoDiscovery1.setAttribute("problemReportingEnabled", "true");
			autoDiscovery1.setAttribute("selectedProfileId", "");
			
			storageModule3.addChild(autoDiscovery1);
			
			EScannerConfigBuildInfo scannerConfigBuildInfo1=new EScannerConfigBuildInfo();
			scannerConfigBuildInfo1.setAttribute("instanceId", "ilg.gnumcueclipse.managedbuild.cross.riscv.config.elf.debug.767917625;ilg.gnumcueclipse.managedbuild.cross.riscv.config.elf.debug.767917625.;ilg.gnumcueclipse.managedbuild.cross.riscv.tool.c.compiler.1375371130;ilg.gnumcueclipse.managedbuild.cross.riscv.tool.c.compiler.input.1473381709");
			
			EAutoDiscovery autoDiscovery2=new EAutoDiscovery();
			autoDiscovery2.setAttribute("enabled", "true");
			autoDiscovery2.setAttribute("problemReportingEnabled", "true");
			autoDiscovery2.setAttribute("selectedProfileId", "");
			
			scannerConfigBuildInfo1.addChild(autoDiscovery2);
			storageModule3.addChild(scannerConfigBuildInfo1);
			
			EScannerConfigBuildInfo scannerConfigBuildInfo2=new EScannerConfigBuildInfo();
			scannerConfigBuildInfo2.setAttribute("instanceId", "ilg.gnumcueclipse.managedbuild.cross.riscv.config.elf.release.1008047074;ilg.gnumcueclipse.managedbuild.cross.riscv.config.elf.release.1008047074.;ilg.gnumcueclipse.managedbuild.cross.riscv.tool.c.compiler.1731377187;ilg.gnumcueclipse.managedbuild.cross.riscv.tool.c.compiler.input.2036806839");
			
			EAutoDiscovery autoDiscovery3=new EAutoDiscovery();
			autoDiscovery3.setAttribute("enabled", "true");
			autoDiscovery3.setAttribute("problemReportingEnabled", "true");
			autoDiscovery3.setAttribute("selectedProfileId", "");
			
			scannerConfigBuildInfo2.addChild(autoDiscovery3);
			storageModule3.addChild(scannerConfigBuildInfo2);
			
		}
		
		
		EStorageModule storageModule4=new EStorageModule();
		storageModule4.setAttribute("moduleId", "org.eclipse.cdt.core.LanguageSettingsProviders");
		
		EStorageModule storageModule5=new EStorageModule();
		storageModule5.setAttribute("moduleId", "org.eclipse.cdt.make.core.buildtargets");
		
		////storageModule 6
//		EStorageModule storageModule6;
//		{
//			storageModule6=new EStorageModule();
//			storageModule6.setAttribute("moduleId", "refreshScope");
//			storageModule6.setAttribute("versionNumber", "2");
//			
//			EConfiguration configuration1=new EConfiguration();
//			configuration1.setAttribute("configurationName", "obj");
//			
//			EResource resource1=new EResource();
//			resource1.setAttribute("resourceType", "PROJECT");
//			resource1.setAttribute("workspacePath",  XmlMofidyUtil.getRightRefreshPolicy(ConvertProjectImp.ProjectName));
//			
//			configuration1.addChild(resource1);
//			
//			/*EConfiguration configuration2=new EConfiguration();
//			configuration2.setAttribute("configurationName", "Debug");
//			
//			EResource resource2=new EResource();
//			resource2.setAttribute("resourceType", "PROJECT");
//			resource2.setAttribute("workspacePath", "/000");
//			
//			configuration2.addChild(resource2);*/
//			
//			/*EConfiguration configuration3=new EConfiguration();
//			configuration3.setAttribute("configurationName", "Release");
//			
//			EResource resource3=new EResource();
//			resource3.setAttribute("resourceType", "PROJECT");
//			resource3.setAttribute("workspacePath", "/000");
//			
//			configuration3.addChild(resource3);*/
//			
//			storageModule6.addChild(configuration1);
//			//storageModule6.addChild(configuration2);
//			//storageModule6.addChild(configuration3);
//		}
		
		
		
		
		cProject.addChild(storageModule1);
		cProject.addChild(storageModule2);
		cProject.addChild(storageModule3);
		cProject.addChild(storageModule4);
		cProject.addChild(storageModule5);
//		cProject.addChild(storageModule6);
		return cProject;
	}
	
	public org.jdom2.Element getElementFromEElement(Element e) {
		org.jdom2.Element element=new org.jdom2.Element(e.getName());
		//attribute
		Iterator<Entry<String, String>> iteratorAttribute=e.getAttributes().entrySet().iterator();
		while(iteratorAttribute.hasNext()) {
			Entry<String, String> entry=iteratorAttribute.next();
			element.setAttribute(entry.getKey(), entry.getValue());
		}
		//child
		List<Element> cList=e.getChildren();
		if(cList!=null) {
			for (Element e1 : cList) {
				element.addContent(getElementFromEElement(e1));
			}
		}
		//value
		String value=e.getValue();
		if(value!=null) {
			element.setText(value);
		}
		return element;
		
	}
	
	//3
	private EOption getEOption(String id,String name,String superclass) {
		EOption option1=new EOption();
		
		option1.setAttribute("id", id);
		if(name!=null) {
			option1.setAttribute("name", name);
		}
		option1.setAttribute("superClass",superclass);
		
		
		return option1;
	}
	//5
	private EOption getEOption(String id,String name,String superclass,String value,String valueType) {
		EOption option1=new EOption();
		
		option1.setAttribute("id", id);
		if(name!=null) {
			option1.setAttribute("name", name);
		}
		option1.setAttribute("superClass",superclass);
		if(value!=null) {
			option1.setAttribute("value", value);
		}
		if(valueType!=null) {
			option1.setAttribute("valueType", valueType);
		}
		
		
		return option1;
	}
	
	//6
	private EOption getEOption(String id,String name,String superclass,String useByScannerDiscovery,String value,String valueType) {
		EOption option1=new EOption();
		
		option1.setAttribute("id", id);
		if(name!=null) {
			option1.setAttribute("name", name);
		}
		option1.setAttribute("superClass",superclass);
		if(useByScannerDiscovery!=null) {
			option1.setAttribute("useByScannerDiscovery", useByScannerDiscovery);
		}
		if(value!=null) {
			option1.setAttribute("value", value);
		}
		if(valueType!=null) {
			option1.setAttribute("valueType", valueType);
		}
		
		
		return option1;
	}
	private EOption getEOptionNoName(String IS_BUILTIN_EMPTY,String IS_VALUE_EMPTY,String id,String superclass,String useByScannerDiscovery,String valueType) {
		EOption option1=new EOption();
		if(IS_BUILTIN_EMPTY!=null) {
			option1.setAttribute("IS_BUILTIN_EMPTY", IS_BUILTIN_EMPTY);
		}
		if(IS_VALUE_EMPTY!=null) {
			option1.setAttribute("IS_VALUE_EMPTY", IS_VALUE_EMPTY);
		}
		option1.setAttribute("id", id);
		
		option1.setAttribute("superClass",superclass);
		if(useByScannerDiscovery!=null) {
			option1.setAttribute("useByScannerDiscovery", useByScannerDiscovery);
		}
		if(valueType!=null) {
			option1.setAttribute("valueType", valueType);
		}
		
		
		return option1;
	}
	
	//6
		private EOption getEOptionNoValue(String IS_BUILTIN_EMPTY,String IS_VALUE_EMPTY,String id,String name,String superclass,String valueType) {
			EOption option1=new EOption();
			if(IS_BUILTIN_EMPTY!=null) {
				option1.setAttribute("IS_BUILTIN_EMPTY", IS_BUILTIN_EMPTY);
			}
			if(IS_VALUE_EMPTY!=null) {
				option1.setAttribute("IS_VALUE_EMPTY", IS_VALUE_EMPTY);
			}
			option1.setAttribute("id", id);
			if(name!=null) {
				option1.setAttribute("name", name);
			}
			option1.setAttribute("superClass",superclass);
			if(valueType!=null) {
				option1.setAttribute("valueType", valueType);
			}
			
			
			return option1;
		}
		
	//7
	private EOption getEOption(String IS_BUILTIN_EMPTY,String IS_VALUE_EMPTY,String id,String name,String superclass,String useByScannerDiscovery,String valueType) {
		EOption option1=new EOption();
		if(IS_BUILTIN_EMPTY!=null) {
			option1.setAttribute("IS_BUILTIN_EMPTY", IS_BUILTIN_EMPTY);
		}
		if(IS_VALUE_EMPTY!=null) {
			option1.setAttribute("IS_VALUE_EMPTY", IS_VALUE_EMPTY);
		}
		option1.setAttribute("id", id);
		if(name!=null) {
			option1.setAttribute("name", name);
		}
		option1.setAttribute("superClass",superclass);
		if(useByScannerDiscovery!=null) {
			option1.setAttribute("useByScannerDiscovery", useByScannerDiscovery);
		}
		if(valueType!=null) {
			option1.setAttribute("valueType", valueType);
		}
		
		
		return option1;
	}
	
	
	private ETool getETool(String id,String name,String superclass) {
		ETool tool=new ETool();
		
		tool.setAttribute("id", id);
		if(name!=null) {
			tool.setAttribute("name", name);
		}
		tool.setAttribute("superClass",superclass);
		
		return tool;
	}
	
	private EListOptionValue getEListOptionValue(String builtIn,String value) {
		EListOptionValue  listOptionValue=new EListOptionValue();
		
		listOptionValue.setAttribute("builtIn", builtIn);
		listOptionValue.setAttribute("value", value);
		return listOptionValue;
	}
	
	private EInputType getEInputType(String id,String superClass) {
		EInputType  inputType=new EInputType();
		inputType.setAttribute("id", id);
		inputType.setAttribute("superClass", superClass);
		return inputType;
	}
	
	private EAdditionalInput getEAdditionalInput(String kind,String paths) {
		EAdditionalInput  inputType=new EAdditionalInput();
		inputType.setAttribute("kind", kind);
		inputType.setAttribute("paths", paths);
		return inputType;
	}
	
}
