/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package convert;

import org.jdom2.Document;
import org.jdom2.Element;

public class NewLanguageSettingFileCreator {
	
	private static NewLanguageSettingFileCreator creator;
	
	public static NewLanguageSettingFileCreator getInstance() {
		if(creator==null) {
			synchronized (NewLanguageSettingFileCreator.class) {
				creator=new NewLanguageSettingFileCreator();
			}
		}
		return creator;
	}
	
	public Document createStanard() {
		Document document=new Document();
		org.jdom2.Element element=generate();
		document.setRootElement(element);
		return document;
	}

	private Element generate() {
		// TODO Auto-generated method stub
		Element root=new Element("project");
		
		Element element1=new Element("configuration");
		element1.setAttribute("id", "ilg.gnumcueclipse.managedbuild.cross.riscv.config.elf.release.1008047074");
		element1.setAttribute("name", "obj");
		
		Element element2=new Element("extension");
		element2.setAttribute("point","org.eclipse.cdt.core.LanguageSettingsProvider");
		
		element2.addContent(new Element("provider").setAttribute("copy-of", "extension").setAttribute("id", "org.eclipse.cdt.ui.UserLanguageSettingsProvider"));
		element2.addContent(new Element("provider-reference").setAttribute("id", "org.eclipse.cdt.core.ReferencedProjectsLanguageSettingsProvider").setAttribute("ref", "shared-provider"));
		element2.addContent(new Element("provider-reference").setAttribute("id", "org.eclipse.cdt.managedbuilder.core.MBSLanguageSettingsProvider").setAttribute("ref", "shared-provider"));
		
		Element e2=new Element("provider"); 
		e2.setAttribute("class", "org.eclipse.cdt.managedbuilder.language.settings.providers.GCCBuiltinSpecsDetector");
		e2.setAttribute("console", "false");
		e2.setAttribute("env-hash", "944441291189765149");
		e2.setAttribute("id", "ilg.gnumcueclipse.managedbuild.cross.riscv.GCCBuiltinSpecsDetector");
		e2.setAttribute("keep-relative-paths", "false");
		e2.setAttribute("name", "CDT RISC-V Cross GCC Built-in Compiler Settings");
		e2.setAttribute("parameter", "${COMMAND} ${FLAGS} ${cross_toolchain_flags} -E -P -v -dD \"${INPUTS}\"");
		e2.setAttribute("prefer-non-shared", "true");
		e2.addContent(new Element("language-scope").setAttribute("id", "org.eclipse.cdt.core.gcc"));
		e2.addContent(new Element("language-scope").setAttribute("id", "org.eclipse.cdt.core.g++"));
		element2.addContent(e2);
		element1.addContent(element2);
		root.addContent(element1);
		
		return root;
	}
}
