/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package convert;

import org.jdom2.Document;
import org.jdom2.Element;

public class NewProjectFileCreator {
	
	private static NewProjectFileCreator creator;
	
	public static NewProjectFileCreator getInstance() {
		if(creator==null) {
			synchronized (NewProjectFileCreator.class) {
				creator=new NewProjectFileCreator();
			}
		}
		return creator;
	}
	
	public Document createStanard(String name) {
		Document document=new Document();
		org.jdom2.Element element=generate(name);
		document.setRootElement(element);
		return document;
	}

	private Element generate(String name) {
		// TODO Auto-generated method stub
		Element root=new Element("projectDescription");
		
		Element nameElement=new Element("name");
		nameElement.setText(name);
		
		root.addContent(nameElement);
		
		Element commentElement=new Element("comment");
		
		root.addContent(commentElement);
		
		Element projectElement=new Element("projects");
		
		root.addContent(projectElement);
		
		Element buildElement;
		
		{
			buildElement=new Element("buildSpec");
			
			Element element1=new Element("buildCommand");
			element1.addContent(new Element("name").setText("org.eclipse.cdt.managedbuilder.core.genmakebuilder"));
			
			element1.addContent(new Element("triggers").setText("clean,full,incremental,"));
			element1.addContent(new Element("arguments"));
			
			Element element2=new Element("buildCommand");
			element2.addContent(new Element("name").setText("org.eclipse.cdt.managedbuilder.core.ScannerConfigBuilder"));
			
			element2.addContent(new Element("triggers").setText("full,incremental,"));
			element2.addContent(new Element("arguments"));
			
			buildElement.addContent(element1);
			buildElement.addContent(element2);
		}
		
		root.addContent(buildElement);
		
		Element natureElement;
		{
			natureElement=new Element("natures");
			natureElement.addContent(new Element("nature").setText("org.eclipse.cdt.core.cnature"));
			natureElement.addContent(new Element("nature").setText("org.eclipse.cdt.managedbuilder.core.managedBuildNature"));
			natureElement.addContent(new Element("nature").setText("org.eclipse.cdt.managedbuilder.core.ScannerConfigNature"));
		}

		root.addContent(natureElement);

		Element filteredResourcesElement = new Element("filteredResources");

		Element filterElement = new Element("filter");
		filteredResourcesElement.addContent(filterElement);

		{
			filterElement.addContent(new Element("id").setText("1595986042669"));
			filterElement.addContent(new Element("name").setText(""));
			filterElement.addContent(new Element("type").setText("22"));

			Element matcherElement = new Element("matcher");
			matcherElement.addContent(new Element("id").setText("org.eclipse.ui.ide.multiFilter"));
			matcherElement.addContent(new Element("arguments").setText("1.0-name-matches-false-false-*.wvproj"));
			filterElement.addContent(matcherElement);
		}

		root.addContent(filteredResourcesElement);
		
		
		return root;
	}
}
