/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package convertProjectUtil;

import java.io.File;
import java.util.List;

import xmlbean.EclipseInfoEntry;
import xmlbean.KeilInfoEntry;

public class ConvertChannel {
	
	/**
	 * 
	 * @param entry
	 * @param newProjecrLocation Ŀ
	 * @return
	 */
	public static EclipseInfoEntry parseFromKeEclipseInfoEntry(KeilInfoEntry entry,String newProjecrLocation) {
		if(entry==null){
			return null;
		}
		EclipseInfoEntry eclipseInfoEntry=new EclipseInfoEntry();
		// .s file
		List<String> pList=entry.getsFilePath();
		for(String path : pList) {
			String sParentString=new File(path).getParentFile().getAbsolutePath();
			eclipseInfoEntry.setAssembleIncludePaths(modifyPath(newProjecrLocation, sParentString));
		}
		//compiler defines
		String defineString=entry.getkCads().getDefine();
		String[] defines=defineString.split(",");
		if(defines!=null && defines.length!=0){
			for (int i = 0; i < defines.length; i++) {
				eclipseInfoEntry.setCompilerDefines(defines[i]);
			}
		}
		
		//compiler include
		String pathsString=entry.getkCads().getIncludePaths();//ԣӦΪͳһΪXmlParseUtil.includeFolderName
		String rightPath=newProjecrLocation+File.separator+XmlParseUtil.includeFolderName;
		eclipseInfoEntry.setCompilerIncludePaths(modifyPath(newProjecrLocation,rightPath));
		
		//linker now fixed
		eclipseInfoEntry.setLinkerGeneral(".ld");
		eclipseInfoEntry.setLinkerLibraries("\"../\"");
		
		return eclipseInfoEntry;
	}
	
	//Ĭ\"
	private static String modifyPath(String base,String target) {
		if(target.contains(base)) {
			target=target.replace(base, "..").replace("\\", "/");
			target="\""+target+"\"";
		}
		return target;
	}
}
