/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package convertProjectUtil;

import java.util.ArrayList;
import java.util.List;

public class EFolder {
	private String name;
	private String path;
	private List<EFile> childrenFiles;

	List<EFolder> childrenFolders;
	public EFolder(String name) {
		super();
		this.name = name;
		this.childrenFiles=new ArrayList<EFile>();
		this.childrenFolders=new ArrayList<EFolder>();
	}
	public String getPath() {
		return path;
	}
	public void setPath(String path) {
		this.path = path;
	}
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
	}
	public List<EFile> getChildrenFiles() {
		return childrenFiles;
	}
	public void addChildrenFiles(EFile file) {
		this.childrenFiles.add(file);
	}
	public List<EFolder> getChildrenFolders() {
		return childrenFolders;
	}
	public void addChildrenFolders(EFolder folder) {
		this.childrenFolders.add(folder);
	}
	
	public EFolder getChildFolder(String name) {
		for(EFolder f:childrenFolders) {
			if(f.getName().equalsIgnoreCase(name)) {
				return f;
			}
		}
		return null;
	}
	
	public EFile getChildFile(String name) {
		for(EFile f:childrenFiles) {
			if(f.getName().equalsIgnoreCase(name)) {
				return f;
			}
		}
		return null;
	}
	
}
