/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package convertProjectUtil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import xmlbean.KFileIncludeHead;


public class FileIncludeRegexParseUtil {
	
	private static FileIncludeRegexParseUtil xmlUtil;
	private ArrayList<KFileIncludeHead> pathsList;
	
	private HashMap<String, KFileIncludeHead> map;
	
	FileIncludeRegexParseUtil(){
		pathsList=new ArrayList<KFileIncludeHead>();
		map=new HashMap<>();
	}
	
	public static FileIncludeRegexParseUtil getInstance() {
		if(xmlUtil==null) {
			synchronized (FileIncludeRegexParseUtil.class) {
				xmlUtil=new FileIncludeRegexParseUtil();
			}
		}
		return xmlUtil;
	}
	
	
	public ArrayList<KFileIncludeHead> getPathsList() {
		return pathsList;
	}
	
	public void clear() {
		pathsList.clear();
	}

	public void parseFile(String filePath) {
		//System.out.println("parseFile "+filePath);
		 String encoding = "UTF-8";
		 File file=new File(filePath);
		 if(!file.isFile() || !file.exists()) {
			 return;
		 }
		 KFileIncludeHead kIncludeHead;
		 if(getByFileName(filePath)!=null) {
			 kIncludeHead=getByFileName(filePath);
			 pathsList.add(kIncludeHead);
			 return;
		 }
		 kIncludeHead=new KFileIncludeHead();
		 kIncludeHead.setSrcFilePath(filePath);
		 
		 try {
			InputStreamReader reader=new InputStreamReader(new FileInputStream(file), encoding);
			BufferedReader bufferedReader = new BufferedReader(reader);
			 String lineTxt = null;
             //ȡһ
             while ((lineTxt = bufferedReader.readLine()) != null)
             {
                 //ƥʽ
            	 ArrayList<String> list=parseString(lineTxt);
            	 if(list!=null && list.size()!=0) {
            		 for(String h:list) {
            			 System.out.println(filePath+"  include -->"+h);
            			 kIncludeHead.addHead(h);
            		 }
            	 }
            	 
             }
             reader.close();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		 map.put(filePath, kIncludeHead);
		 pathsList.add(kIncludeHead);
		 
	}
	
	private ArrayList<String> parseString(String s) {
		//System.out.println("parseString-->"+s);
		if(s==null) {
			return null;
		}
		return matchRegex(s,"#include\\s+\"\\s*?.+\\.[h | H]\\s*?\"");
		//
	}
	
	private ArrayList<String> matchRegex(String s,String regex) {
		ArrayList<String> list=new ArrayList<>();
		Pattern pattern=Pattern.compile(regex);
		Matcher m = pattern.matcher(s);
		boolean result=m.find();
		if(result) {
			int c=m.groupCount();
			for (int i = 0; i <= c; i++) {
				String gString=m.group(c);
				//System.out.println("group-->"+gString);
				String nString=getRealName(gString);
				if(nString!=null) {
					list.add(nString);
				}
				
			}
		}
		return list;
	}
	
	private String getRealName(String s) {
		Pattern pattern=Pattern.compile("\\s*?\\w+\\.[h | H]\\s*?");
		Matcher m = pattern.matcher(s);
		boolean result=m.find();
		if(result) {
			int c=m.groupCount();
			for (int i = 0; i <= c; i++) {
				String gString=m.group(c);
				
				return gString;
			}
		}
		return null;
	}
	
	public KFileIncludeHead getByFileName(String name) {
		return map.get(name);
	}
	
}
