/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package convertProjectUtil;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class ResultFileUtil {
	public static boolean needShowLog(String filePath) throws Exception {
		File file=new File(filePath);
        if(!file.exists()){
            return false;
        }
        FileInputStream is=null;
        is=new FileInputStream(file);

        FileChannel fileChannel=is.getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        byte[] buf=null;
        int eof=0;
        while (true){
            try {
                eof = fileChannel.read(byteBuffer);
            } catch (IOException e) {
                e.printStackTrace();
            }
            if (eof == -1) break;
            buf=new byte[eof];
            byteBuffer.flip();
            byteBuffer.get(buf, 0, eof);
            byteBuffer.compact();
            byteBuffer.clear();
        }
        fileChannel.close();
        is.close();
        String js=new String(buf);
        return js!=null && js.contains("TRUE");
	}
}
