/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package convertProjectUtil;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Random;

import org.eclipse.core.runtime.Platform;
import org.jdom2.output.Format;
import org.jdom2.output.Format.TextMode;
import org.jdom2.output.XMLOutputter;
import org.jdom2.output.support.AbstractXMLOutputProcessor;
import org.jdom2.output.support.FormatStack;
import org.jdom2.output.support.XMLOutputProcessor;

import convert.NewCProjectFileCreator;
import convert.NewLanguageSettingFileCreator;
import convert.NewProjectFileCreator;
import xmlbean.EclipseInfoEntry;

public class XmlBuildUtil {

	private static XmlBuildUtil xmlUtil;

	public static XmlBuildUtil getInstance() {
		if (xmlUtil == null) {
			synchronized (XmlBuildUtil.class) {
				xmlUtil = new XmlBuildUtil();
			}
		}
		return xmlUtil;
	}

	public static XMLOutputProcessor XMLOUTPUT_CPROJECT = new AbstractXMLOutputProcessor() {
		@Override
		protected void printDeclaration(final Writer out, final FormatStack fstack) throws IOException {
			write(out, "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?> " + "\r\n");
			write(out, "<?fileVersion 4.0.0?>");
			write(out, fstack.getLineSeparator());
		}

	};

	public static XMLOutputProcessor XMLOUTPUT_CPROJECT_1 = new AbstractXMLOutputProcessor() {
		@Override
		protected void printDeclaration(final Writer out, final FormatStack fstack) throws IOException {
			write(out, "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?> ");
			write(out, fstack.getLineSeparator());
		}

	};

	public static XMLOutputProcessor XMLOUTPUT_PROJECT = new AbstractXMLOutputProcessor() {
		@Override
		protected void printDeclaration(final Writer out, final FormatStack fstack) throws IOException {
			write(out, "<?xml version=\"1.0\" encoding=\"UTF-8\" ?> ");
			write(out, fstack.getLineSeparator());
		}

	};
	public static XMLOutputProcessor XMLOUTPUT_Setting = new AbstractXMLOutputProcessor() {
		@Override
		protected void printDeclaration(final Writer out, final FormatStack fstack) throws IOException {
			write(out, "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?> ");
			write(out, fstack.getLineSeparator());
		}

	};

	// By ch32v103_v1.1 evt
	public void createCProjectFile(File file, EclipseInfoEntry eclipseInfoEntry) throws Exception {
		// output
		Format f = Format.getRawFormat();
		f.setIndent("  ");
		f.setTextMode(TextMode.TRIM_FULL_WHITE);
		XMLOutputter xmlOutput = new XMLOutputter(f, XMLOUTPUT_CPROJECT);

		xmlOutput.output(NewCProjectFileCreator.getInstance().createStanard(eclipseInfoEntry),
				new FileOutputStream(file));
	}

	public void createProjectFile(File file, String projectName) throws Exception {
		// output
		Format f = Format.getRawFormat();
		f.setIndent("  ");
		f.setTextMode(TextMode.TRIM_FULL_WHITE);
		XMLOutputter xmlOutput = new XMLOutputter(f, XMLOUTPUT_PROJECT);

		xmlOutput.output(NewProjectFileCreator.getInstance().createStanard(projectName), new FileOutputStream(file));
	}

	public void createLanguageSettingFile(File file) throws Exception {
		// output
		Format f = Format.getRawFormat();
		f.setIndent("  ");
		f.setTextMode(TextMode.TRIM_FULL_WHITE);
		XMLOutputter xmlOutput = new XMLOutputter(f, XMLOUTPUT_Setting);

		xmlOutput.output(NewLanguageSettingFileCreator.getInstance().createStanard(), new FileOutputStream(file));
	}

	public void createLinkFile(String filepath) throws Exception {
		File file = new File(filepath);
		if (file.exists()) {
			file.delete();
		}
		file.createNewFile();
		FileOutputStream outputStream = new FileOutputStream(file);
		Random random = new Random();
		for (int i = 0; i < 202; i++) {
			outputStream.write(new byte[] { (byte) random.nextInt(200) });
		}
		outputStream.close();
	}

	public void createLDFile(String filepath) throws Exception {
		File file = new File(filepath);
		if (file.exists()) {
			file.delete();
		}
		// Ŀǰ ģļиļ
		// ȡtemplate/convert/.ld
		String installPath;
		URL installUrl = Platform.getInstallLocation().getURL();
		installPath = installUrl.getPath().replaceFirst("/", "");

		//

		// ѰģĿ¼Template
		String srcPath = installPath + "template/convert/CH32V103/.ld";

		File f = new File(srcPath);
		if (!f.exists()) {
			throw new Exception(".ld file not found");
		}
		Files.copy(f.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
	}
}
