/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package convertProjectUtil;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.util.Util;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.Format.TextMode;
import org.jdom2.output.XMLOutputter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlMofidyUtil {
	private static XmlMofidyUtil xmlUtil;

	public static XmlMofidyUtil getInstance() {
		if (xmlUtil == null) {
			synchronized (XmlMofidyUtil.class) {
				xmlUtil = new XmlMofidyUtil();
			}
		}
		return xmlUtil;
	}

	public String getChipContent(File zip) throws Exception {
		StringBuffer stringBuffer = new StringBuffer();
		ZipFile zipFile = new ZipFile(zip.getAbsolutePath()); // 
		Enumeration<?> entries = zipFile.entries();
		while (entries.hasMoreElements()) {
			ZipEntry entry = (ZipEntry) entries.nextElement();
			String filename = entry.getName();
			if (filename.equals(".template")) {
				InputStream is = zipFile.getInputStream(entry);
				byte buf[] = new byte[1024];
				int count = -1;
				while ((count = is.read(buf)) > -1) {
					String str = new String(buf, 0, count);
					stringBuffer.append(str);
				}
			}
		}
		zipFile.close();
		return stringBuffer.toString();
	}

	/**
	 * Copy a specific zip file while modifying inner content.
	 * 
	 * @param origin
	 * @param target
	 * @param oldVendor
	 * @param oldTc
	 * @param oldSeries
	 * @param newVendor
	 * @param newTc
	 * @param newSeries
	 * @throws Exception
	 */
	public void modifyChipContent(File origin, File target, String oldVendor, String oldTc, String oldSeries,
			String newVendor, String newTc, String newSeries) throws Exception {
		ZipFile zipFile = new ZipFile(origin.getAbsolutePath());
		Enumeration<?> entries = zipFile.entries();
		ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(target));
		while (entries.hasMoreElements()) {
			ZipEntry zipEntry = (ZipEntry) entries.nextElement();
			String filename = zipEntry.getName();
			if (filename.equals(".template")) {
				zos.putNextEntry(new ZipEntry(".template"));
				InputStream is = zipFile.getInputStream(zipEntry);
				byte buf[] = new byte[1024];
				int len;
				while ((len = is.read(buf)) > 0) {
					String str = new String(buf);
					if (str.contains("Vendor=" + oldVendor)) {
						buf = str.replaceAll("Vendor=" + oldVendor, "Vendor=" + newVendor)
								.replaceAll("Toolchain=" + oldTc, "Toolchain=" + newTc)
								.replaceAll("Series=" + oldSeries, "Series=" + newSeries).getBytes();
					}
					zos.write(buf, 0, (len < buf.length) ? len : buf.length);
				}
			} else {
				zos.putNextEntry(new ZipEntry(zipEntry.getName()));
				InputStream is = zipFile.getInputStream(zipEntry);
				byte buf[] = new byte[1024];
				int len;
				while ((len = is.read(buf)) > 0) {
					zos.write(buf, 0, (len < buf.length) ? len : buf.length);
				}
			}
		}
		zos.closeEntry();
		zos.close();
		zipFile.close();
	}

	public void onlyModifyProjectName(IProject project, String newName) throws Exception {
		String dspPath = project.getLocation().toOSString() + File.separator
				+ IProjectDescription.DESCRIPTION_FILE_NAME;
		org.w3c.dom.Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder()
				.parse(new FileInputStream(dspPath));
		if (doc.getChildNodes().getLength() == 0) {
			return;
		}
		Node projDsp = doc.getChildNodes().item(0);
		NodeList childlist = projDsp.getChildNodes();
		for (int i = 0; i < childlist.getLength(); i++) {
			Node child = childlist.item(i);
			if (child.getNodeName().equals("name")) {
				child.setTextContent(newName);
				break;
			}
		}

		// hide .wvproj in the project explorer
//		if (doc.getElementsByTagName("filteredResources").getLength() == 0) {
//			// set filter to hide .wvproj file
//			org.w3c.dom.Element eleFilteredResources = doc.createElement("filteredResources");
//
//			org.w3c.dom.Element eleFilter = doc.createElement("filter");
//
//			org.w3c.dom.Element eleID = doc.createElement("id");
//			eleID.appendChild(doc.createTextNode("1595986042669"));
//
//			org.w3c.dom.Element eleName = doc.createElement("name");
//			eleName.appendChild(doc.createTextNode(""));
//
//			org.w3c.dom.Element eleType = doc.createElement("type");
//			eleType.appendChild(doc.createTextNode("22"));
//
//			org.w3c.dom.Element eleMatcher = doc.createElement("matcher");
//
//			org.w3c.dom.Element eleMatcherID = doc.createElement("id");
//			eleMatcherID.appendChild(doc.createTextNode("org.eclipse.ui.ide.multiFilter"));
//
//			org.w3c.dom.Element eleMatcherArguments = doc.createElement("arguments");
//			eleMatcherArguments.appendChild(doc.createTextNode("1.0-name-matches-false-false-*.wvproj"));
//
//			eleMatcher.appendChild(eleMatcherID);
//			eleMatcher.appendChild(eleMatcherArguments);
//
//			eleFilter.appendChild(eleID);
//			eleFilter.appendChild(eleName);
//			eleFilter.appendChild(eleType);
//			eleFilter.appendChild(eleMatcher);
//
//			eleFilteredResources.appendChild(eleFilter);
//			projDsp.appendChild(eleFilteredResources);
//		}

		// Transform the document to something we can save in a file
		ByteArrayOutputStream stream = new ByteArrayOutputStream();
		Transformer transformer = TransformerFactory.newInstance().newTransformer();
		transformer.setOutputProperty(OutputKeys.METHOD, "xml"); //$NON-NLS-1$
		transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8"); //$NON-NLS-1$
		transformer.setOutputProperty(OutputKeys.INDENT, "yes"); //$NON-NLS-1$
		DOMSource source = new DOMSource(doc);
		StreamResult result = new StreamResult(stream);
		transformer.transform(source, result);

		// Save the document
		String utfString = stream.toString("UTF-8");
		IFile projectFile = project.getFile(IProjectDescription.DESCRIPTION_FILE_NAME);
		projectFile.setContents(new ByteArrayInputStream(utfString.getBytes("UTF-8")), IResource.FORCE, //$NON-NLS-1$
				new NullProgressMonitor());
		stream.close();
	}

	public void onlyModifyProjectName(File targetFile, String newName) throws Exception {
		String dspPath = targetFile.getAbsolutePath();
		org.w3c.dom.Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder()
				.parse(new FileInputStream(dspPath));
		if (doc.getChildNodes().getLength() == 0) {
			return;
		}
		Node projDsp = doc.getChildNodes().item(0);
		NodeList childlist = projDsp.getChildNodes();
		for (int i = 0; i < childlist.getLength(); i++) {
			Node child = childlist.item(i);
			if (child.getNodeName().equals("name")) {
				child.setTextContent(newName);
				break;
			}
		}

		// hide .wvproj in the project explorer
//		if (doc.getElementsByTagName("filteredResources").getLength() == 0) {
//			// set filter to hide .wvproj file
//			org.w3c.dom.Element eleFilteredResources = doc.createElement("filteredResources");
//
//			org.w3c.dom.Element eleFilter = doc.createElement("filter");
//
//			org.w3c.dom.Element eleID = doc.createElement("id");
//			eleID.appendChild(doc.createTextNode("1595986042669"));
//
//			org.w3c.dom.Element eleName = doc.createElement("name");
//			eleName.appendChild(doc.createTextNode(""));
//
//			org.w3c.dom.Element eleType = doc.createElement("type");
//			eleType.appendChild(doc.createTextNode("22"));
//
//			org.w3c.dom.Element eleMatcher = doc.createElement("matcher");
//
//			org.w3c.dom.Element eleMatcherID = doc.createElement("id");
//			eleMatcherID.appendChild(doc.createTextNode("org.eclipse.ui.ide.multiFilter"));
//
//			org.w3c.dom.Element eleMatcherArguments = doc.createElement("arguments");
//			eleMatcherArguments.appendChild(doc.createTextNode("1.0-name-matches-false-false-*.wvproj"));
//
//			eleMatcher.appendChild(eleMatcherID);
//			eleMatcher.appendChild(eleMatcherArguments);
//
//			eleFilter.appendChild(eleID);
//			eleFilter.appendChild(eleName);
//			eleFilter.appendChild(eleType);
//			eleFilter.appendChild(eleMatcher);
//
//			eleFilteredResources.appendChild(eleFilter);
//			projDsp.appendChild(eleFilteredResources);
//		}

		// Transform the document to something we can save in a file
		ByteArrayOutputStream stream = new ByteArrayOutputStream();
		Transformer transformer = TransformerFactory.newInstance().newTransformer();
		transformer.setOutputProperty(OutputKeys.METHOD, "xml"); //$NON-NLS-1$
		transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8"); //$NON-NLS-1$
		transformer.setOutputProperty(OutputKeys.INDENT, "yes"); //$NON-NLS-1$
		DOMSource source = new DOMSource(doc);
		StreamResult result = new StreamResult(stream);
		transformer.transform(source, result);

		// Save the document
		String utfString = stream.toString("UTF-8");
		FileOutputStream fos = new FileOutputStream(targetFile);
		fos.write(utfString.getBytes("UTF-8"));
		fos.flush();
		stream.close();
		fos.close();
	}

	public static String getRightBuildPath(String name) {
		return "${workspace_loc:/" + name + "}/obj"; //$NON-NLS-1$ //$NON-NLS-2$
	}

	public static String getRightRefreshPolicy(String name) {
		return "/" + name; //$NON-NLS-1$
	}

//	public void modifyNewCProjectWithProject(IProject project, String name) throws Exception {
//		SAXBuilder sb = new SAXBuilder();
//		Document myDoc = null;
//		String path = project.getLocation().toOSString() + File.separator + ".cproject";
//		myDoc = sb.build(new FileInputStream(path));
//		// Ԫ
//		Element root = myDoc.getRootElement();
//
//		// 1.modify buildPath
//		Element d1 = getBuilderElement(root);
//		if (d1 == null) {
//			throw new Exception(Messages.XmlMofidyUtil_6);
//		}
//		d1.setAttribute("buildPath", getRightBuildPath(name));
//		// 2.modify refresh policy
//		Element d2 = getRefreshElement(root);
////		if (d2 == null) {
////			throw new Exception(Messages.XmlMofidyUtil_8);
////		}
////		d2.setAttribute("workspacePath", getRightRefreshPolicy(name)); //$NON-NLS-1$
//		if (d2 != null) {
//			d2.setAttribute("workspacePath", getRightRefreshPolicy(name)); //$NON-NLS-1$
//		}
//		Format f = Format.getRawFormat();
//		f.setIndent("  "); //$NON-NLS-1$
//		f.setTextMode(TextMode.TRIM_FULL_WHITE);
//		XMLOutputter xmlOutput = new XMLOutputter(f, XmlBuildUtil.XMLOUTPUT_PROJECT);
//
//		OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(path), "UTF-8"); //$NON-NLS-1$
//		xmlOutput.output(myDoc, writer);
//		writer.close();
//	}

	public void modifyNewCProjectWithProject(File targetFile, String newName) throws Exception {
		SAXBuilder sb = new SAXBuilder();
		Document myDoc = null;
		String path = targetFile.getAbsolutePath();
		myDoc = sb.build(new FileInputStream(path));
		// Ԫ
		Element root = myDoc.getRootElement();

		// 1.modify buildPath
		Element d1 = getBuilderElement(root);
		if (d1 == null) {
			throw new Exception(Messages.XmlMofidyUtil_6);
		}
		d1.setAttribute("buildPath", getRightBuildPath(newName));
		// 2.modify refresh policy
		Element d2 = getRefreshElement(root);
		if (d2 != null) {
//			throw new Exception(Messages.XmlMofidyUtil_8);
			d2.setAttribute("workspacePath", getRightRefreshPolicy(newName)); //$NON-NLS-1$
		}

		Format f = Format.getRawFormat();
		f.setIndent("  "); //$NON-NLS-1$
		f.setTextMode(TextMode.TRIM_FULL_WHITE);
		XMLOutputter xmlOutput = new XMLOutputter(f, XmlBuildUtil.XMLOUTPUT_PROJECT);

		OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(path), "UTF-8"); //$NON-NLS-1$
		xmlOutput.output(myDoc, writer);
		writer.close();
	}

	public void modifyLaunchContent(IProject project, String launchFilePath) throws Exception {
		File launchFile = new File(launchFilePath);
		if (!launchFile.exists())
			return;
		Document myDoc = null;
		SAXBuilder sb = new SAXBuilder();
//		int pos = launchFile.getName().indexOf(" obj.launch");
//		String name = launchFile.getName().substring(0, pos);
		myDoc = sb.build(new FileInputStream(launchFilePath));
		// Ԫ
		Element root = myDoc.getRootElement();

		List<Element> listStringAttribute = root.getChildren("stringAttribute");
		for (Element ele : listStringAttribute) {
			if (ele.getAttributeValue("key").equals("org.eclipse.cdt.launch.PROGRAM_NAME")) {
//				String value = ele.getAttributeValue("value");
//				ele.setAttribute("value", value.replace(name, project.getName()));
				ele.setAttribute("value", "obj" + File.separator + project.getName() + ".elf");
			}

			if (ele.getAttributeValue("key").equals("org.eclipse.cdt.launch.PROJECT_ATTR")) {
//				String value = ele.getAttributeValue("value");
//				ele.setAttribute("value", value.replace(name, project.getName()));
				ele.setAttribute("value", project.getName());
			}

			if (ele.getAttributeValue("key").equals("org.eclipse.cdt.dsf.gdb.DEBUG_NAME")) {
				String value = ele.getAttributeValue("value");
				if(value != null && !value.isEmpty())
				if(!Util.isWindows() && value.endsWith(".exe")) {
					ele.setAttribute("value", value.replace(".exe", ""));
				} 
			}
		}

		List<Element> listListAttribute = root.getChildren("listAttribute");
		for (Element ele : listListAttribute) {
			if (ele.getAttributeValue("key").equals("org.eclipse.debug.core.MAPPED_RESOURCE_PATHS")) {
				List<Element> listEntry = ele.getChildren("listEntry");
				for (Element eleEntry : listEntry) {
					Attribute attr = eleEntry.getAttribute("value");
					if (attr != null) {
//						String value = attr.getValue();
						// attr.setValue(value.replace(name, project.getName()));
						attr.setValue("/" + project.getName());
					}
				}
			}
		}

		Format f = Format.getRawFormat();
		f.setIndent("  "); //$NON-NLS-1$
		f.setTextMode(TextMode.TRIM_FULL_WHITE);
		XMLOutputter xmlOutput = new XMLOutputter(f, XmlBuildUtil.XMLOUTPUT_PROJECT);

		OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(launchFilePath), "UTF-8"); //$NON-NLS-1$
		xmlOutput.output(myDoc, writer);
		writer.close();

//		File file1 = new File(launchFilePath);
//		int lastIndex = launchFilePath.lastIndexOf(File.separator);
//		String before = launchFilePath.substring(0, lastIndex + 1);
//		String after = launchFilePath.substring(lastIndex + 1);
//		File file2 = new File(before + after.replace(name, project.getName()));
//		file1.renameTo(file2);

		// Add for prototype e-mrs
		File newLaunchFile = new File(
				launchFile.getParentFile().getAbsolutePath() + File.separator + project.getName() + ".launch");
		if (!newLaunchFile.exists()) {
			Files.copy(launchFile.toPath(), newLaunchFile.toPath());
			launchFile.delete();
		}
	}

	public void modifyLaunchContent(File targetFile, String newName) throws Exception {
		Document myDoc = null;
		SAXBuilder sb = new SAXBuilder();
		int pos = targetFile.getName().indexOf(" obj.launch");
		String name = targetFile.getName().substring(0, pos);
		myDoc = sb.build(new FileInputStream(targetFile));
		// Ԫ
		Element root = myDoc.getRootElement();

		List<Element> listStringAttribute = root.getChildren("stringAttribute");
		for (Element ele : listStringAttribute) {
			if (ele.getAttributeValue("key").equals("org.eclipse.cdt.launch.PROGRAM_NAME")) {
				String value = ele.getAttributeValue("value");
				ele.setAttribute("value", value.replace(name, newName));
			}

			if (ele.getAttributeValue("key").equals("org.eclipse.cdt.launch.PROJECT_ATTR")) {
				String value = ele.getAttributeValue("value");
				ele.setAttribute("value", value.replace(name, newName));
			}
		}

		List<Element> listListAttribute = root.getChildren("listAttribute");
		for (Element ele : listListAttribute) {
			if (ele.getAttributeValue("key").equals("org.eclipse.debug.core.MAPPED_RESOURCE_PATHS")) {
				List<Element> listEntry = ele.getChildren("listEntry");
				for (Element eleEntry : listEntry) {
					Attribute attr = eleEntry.getAttribute("value");
					if (attr != null) {
						String value = attr.getValue();
						attr.setValue(value.replace(name, newName));
					}
				}
			}
		}

		Format f = Format.getRawFormat();
		f.setIndent("  "); //$NON-NLS-1$
		f.setTextMode(TextMode.TRIM_FULL_WHITE);
		XMLOutputter xmlOutput = new XMLOutputter(f, XmlBuildUtil.XMLOUTPUT_PROJECT);

		OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(targetFile), "UTF-8"); //$NON-NLS-1$
		xmlOutput.output(myDoc, writer);
		writer.close();

//		IResource resource1 = project.findMember(file1.getName());
//		if (resource1 != null) {
//			RenameResourceProcessor rp = new RenameResourceProcessor(resource1);
//			rp.setNewResourceName(project.getName() + " obj.launch");
//			rp.createChange(new NullProgressMonitor());
//			resource1.setHidden(true);
//		}
		String launchFilePath = targetFile.getAbsolutePath();
		int lastIndex = launchFilePath.lastIndexOf(File.separator);
		String before = launchFilePath.substring(0, lastIndex + 1);
		String after = launchFilePath.substring(lastIndex + 1);
		File file2 = new File(before + after.replace(name, newName));
		targetFile.renameTo(file2);
	}

	private Element getBuilderElement(Element root) {
		Element element1 = getChild(root, "storageModule", "moduleId", "org.eclipse.cdt.core.settings"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		if (element1 == null) {
			return null;
		}

		Element element2 = getChild(element1, "cconfiguration", "id", //$NON-NLS-1$ //$NON-NLS-2$
				"ilg.gnumcueclipse.managedbuild.cross.riscv.config.elf.release"); //$NON-NLS-1$
		if (element2 == null) {
			return null;
		}

		Element element3 = getChild(element2, "storageModule", "moduleId", "cdtBuildSystem"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		if (element3 == null) {
			return null;
		}

		Element element4 = getChild(element3, "configuration", "parent", //$NON-NLS-1$ //$NON-NLS-2$
				"ilg.gnumcueclipse.managedbuild.cross.riscv.config.elf.release"); //$NON-NLS-1$
		if (element4 == null) {
			return null;
		}
		Element element5 = getChild(element4, "folderInfo", "name", "/"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		if (element5 == null) {
			return null;
		}
		Element element6 = getChild(element5, "toolChain", "name", "RISC-V Cross GCC"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		if (element6 == null) {
			return null;
		}
		Element element7 = getChild(element6, "builder", "superClass", //$NON-NLS-1$ //$NON-NLS-2$
				"ilg.gnumcueclipse.managedbuild.cross.riscv.builder"); //$NON-NLS-1$
		if (element7 == null) {
			return null;
		}
		return element7;
	}

	private Element getRefreshElement(Element root) {
		Element element1 = getChild(root, "storageModule", "moduleId", "refreshScope"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		if (element1 == null) {
			return null;
		}
		Element element2 = getChild(element1, "configuration", "configurationName", "obj"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		if (element2 == null) {
			return null;
		}

		Element element3 = getChild(element2, "resource", "resourceType", "PROJECT"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		if (element3 == null) {
			return null;
		}

		return element3;
	}

	private Element getChild(Element parent, String tag, String attribute, String value) {
		List<Element> elements = parent.getChildren(tag);
		if (elements == null || elements.size() == 0) {
			return null;
		}
		if (elements.size() == 1) {
			return elements.get(0);
		}
		for (Element e : elements) {
			Attribute a = e.getAttribute(attribute);
			if (a == null) {
				continue;
			}
			if (a.getValue().startsWith(value)) {
				return e;
			}
		}
		return null;
	}

}
