/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package convertProjectUtil;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;

import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

import convert.ConvertProjectImp;
import xmlbean.KAads;
import xmlbean.KCads;
import xmlbean.KFileIncludeHead;
import xmlbean.KRAM;
import xmlbean.KROM;
import xmlbean.KeilInfoEntry;

public class XmlParseUtil {
	private static XmlParseUtil xmlUtil;
	private String projectName;
	private String projectLocation;
	private String keilPath;

	private KeilInfoEntry entry;

	public static String includeFolderName = "incs";

	// ѡ
	private boolean enableSelectIncludePath = false;

	public static XmlParseUtil getInstance() {
		if (xmlUtil == null) {
			synchronized (XmlParseUtil.class) {
				xmlUtil = new XmlParseUtil();
			}
		}
		return xmlUtil;
	}

	public void parseXml(File srcFile, String newProjectName, String newProjectLocation, boolean compare)
			throws Exception {
		projectName = newProjectName;
		projectLocation = newProjectLocation;
		keilPath = srcFile.getAbsolutePath();
		entry = new KeilInfoEntry();

		SAXBuilder saxBuilder = new SAXBuilder();
		InputStream iStream = new FileInputStream(srcFile);
		Document document = saxBuilder.build(iStream);
		Element rootElement = document.getRootElement();
		System.out.println("get root-->" + rootElement.getName() + "\r\n");
		List<Element> children = rootElement.getChildren();
		//
		// 
		FileIncludeRegexParseUtil.getInstance().clear();
		// ȡļGroupsһȡ.cļõ.hͷļ
		EFolder folder = null;
		for (Element element : children) {
			EFolder f = parseElement1(element);
			if (f != null) {
				folder = f;
				break;
			}
		}
		if (folder == null) {
			throw new Exception("parseXml fail");
		}
		//
		ArrayList<KFileIncludeHead> nameStrings = FileIncludeRegexParseUtil.getInstance().getPathsList();
		System.out.println("======================print used include paths");
		for (KFileIncludeHead name : nameStrings) {
			System.out.println(name.getSrcFilePath() + " (contains head file)----->" + name.getHeads().toString());
		}

		// ļеincludeϲEFolder
		EFolder folder2;
		if (enableSelectIncludePath) {
			folder2 = mergeCadsIncludeFilesToFolder2(folder, nameStrings);
		} else {
			folder2 = mergeCadsIncludeFilesToFolder(folder);
		}

		// ·
		EFolder folder3 = caculatePath(folder2);
		createFileByEFolder(folder3);

		createCProjectFile(newProjectLocation + File.separator + newProjectName + File.separator + ".cproject");
		createProjectFile(newProjectLocation + File.separator + newProjectName + File.separator + ".project",
				newProjectName);
		createLanguageSettingFile(newProjectLocation + File.separator + newProjectName + File.separator + ".settings"
				+ File.separator + "language.settings.xml");
		createLinkFile(
				newProjectLocation + File.separator + newProjectName + File.separator + newProjectName + ".wvproj");
		createLDFile(newProjectLocation + File.separator + newProjectName + File.separator + ".ld");

		if (compare) {
			createTempFilesForCompare(folder2);
		}
	}

	private void createCProjectFile(String filePath) throws Exception {
		// TODO Auto-generated method stub
		File file = new File(filePath);
		if (!file.exists()) {
			file.createNewFile();
		}
		XmlBuildUtil.getInstance().createCProjectFile(file,
				ConvertChannel.parseFromKeEclipseInfoEntry(entry, projectLocation + File.separator + projectName));
	}

	private void createProjectFile(String filePath, String projectName) throws Exception {
		// TODO Auto-generated method stub
		File file = new File(filePath);
		if (!file.exists()) {
			file.createNewFile();
		}
		XmlBuildUtil.getInstance().createProjectFile(file, projectName);
	}

	private void createLanguageSettingFile(String filePath) throws Exception {
		// TODO Auto-generated method stub
		File file = new File(filePath);
		if (!file.exists()) {
			file.getParentFile().mkdirs();
			file.createNewFile();
		}
		XmlBuildUtil.getInstance().createLanguageSettingFile(file);
	}

	private void createLinkFile(String filePath) throws Exception {
		// TODO Auto-generated method stub

		XmlBuildUtil.getInstance().createLinkFile(filePath);
	}

	private void createLDFile(String filePath) throws Exception {
		// TODO Auto-generated method stub

		XmlBuildUtil.getInstance().createLDFile(filePath);
	}

	private EFolder caculatePath(EFolder folder) {
		System.out.println("=================================caculate path==================================");
		String basePath = projectLocation;
		// top level
		folder.setPath(basePath + File.separator + folder.getName());
		//
		return loopSetPath(folder);
	}

	private EFolder loopSetPath(EFolder folder) {
		List<EFile> files = folder.getChildrenFiles();
		List<EFolder> folders = folder.getChildrenFolders();

		for (EFile file : files) {
			file.setDstEclipsePath(folder.getPath() + File.separator + file.getName());
			if (file.getName().endsWith(".s") || file.getName().endsWith(".S")) {
				// find .s file
				// assume only one file
				if (entry != null) {
					entry.setsFilePath(file.getDstEclipsePath());
					System.out.println("sFIle:-->" + file.getDstEclipsePath());
				}
			}
			System.out.println("file setEclipsePath-->" + file.getDstEclipsePath());
			String temp = caculatePath(keilPath, file.getSrcKeilPath());
			if (temp != null) {
				file.setSrcKeilPath(caculatePath(keilPath, file.getSrcKeilPath()));
				System.out.println("file setKeilPath-->" + file.getSrcKeilPath());

			} else {
				file.setSrcKeilPath(null);
			}
		}
		for (int i = 0; i < folders.size(); i++) {
			EFolder f = folders.get(i);
			f.setPath(folder.getPath() + File.separator + f.getName());
			f = loopSetPath(f);
			folders.set(i, f);
			System.out.println("folder setPath-->" + f.getPath());
		}
		System.out.println("\r\n");
		return folder;
	}

	/**
	 * 
	 * @param base         uvproject file path
	 * @param relativePath
	 * @return
	 */
	public String caculatePath(String base, String relativePath) {
		// System.out.println("caculatePath-->"+base+" "+relativePath);

		File file = new File(base);
		if (!file.exists()) {
			return null;
		}
		// ..\
		base = file.getParentFile().getAbsolutePath();
		file = new File(base);

		// System.out.println("current path-->"+base);
		String retString = null;
		if (relativePath.contains("..\\") || relativePath.contains(".\\")) {
			while (relativePath.contains("..\\") || relativePath.contains(".\\")) {
				if (relativePath.startsWith("..\\")) {
					relativePath = relativePath.replaceFirst("..\\\\", "");
					File file2 = file.getParentFile();
					if (file == null || !file.exists()) {
						return null;
					}
					file = file2;
				} else if (relativePath.startsWith(".\\")) {
					relativePath = relativePath.replaceFirst(".\\\\", "");
					// ǰĿ¼
				}

			}
			retString = file.getAbsolutePath() + File.separator + relativePath;
			// ǰsrcKeilPath

		} else if (relativePath.contains("../") || relativePath.contains("./")) {
			while (relativePath.contains("../") || relativePath.contains("./")) {
				if (relativePath.startsWith("../")) {
					relativePath = relativePath.replaceFirst("../", "");
					File file2 = file.getParentFile();
					if (file == null || !file.exists()) {
						return null;
					}
					file = file2;
				} else if (relativePath.startsWith("./")) {
					relativePath = relativePath.replaceFirst("./", "");
					// ǰĿ¼
				}

			}
			retString = file.getAbsolutePath() + File.separator + relativePath;
		} else {
			retString = relativePath;
		}
		// System.out.println("caculate path-->"+relativePath);

		// System.out.println("result path-->"+retString);
		return retString;
	}

	private EFolder mergeCadsIncludeFilesToFolder2(EFolder folder, ArrayList<KFileIncludeHead> heads) throws Exception {
		System.out.println("===========merge Cads IncludeFiles To Folder2===========");
		EFolder includEFolder = new EFolder(includeFolderName);
		if (entry == null) {
			return folder;
		}
		String includePaths = entry.getkCads().getIncludePaths();

		if ((includePaths == null || includePaths.equalsIgnoreCase("")) && (heads == null && heads.size() == 0)) {
			return folder;
		}
		// includePathsµĸļ
		ArrayList<File> tempIncludeFiles = new ArrayList<>();
		ArrayList<String> temp1 = new ArrayList<>();// ʱԱ

		String[] paths = includePaths.split(";");
		if (paths != null && paths.length != 0) {
			for (int i = 0; i < paths.length; i++) {
				String path = caculatePath(keilPath, paths[i]);
				File file = new File(path);
				if (!file.exists()) {
					System.out.println(path + " don't exist");

					continue;
				}
				if (!file.isDirectory()) {
					System.out.println(path + " isn't directory");
					continue;
				}

				File[] files = file.listFiles(new FileFilter() {

					@Override
					public boolean accept(File pathname) {
						// TODO Auto-generated method stub
						return pathname.getName().endsWith(".h") || pathname.getName().endsWith(".H");
					}
				});
				if (files == null) {
					continue;
				}
				for (int j = 0; j < files.length; j++) {
					tempIncludeFiles.add(files[j]);
					temp1.add(files[j].getName());
				}
			}

		}
		System.out.println(">>>>>>>>>>>>>get cads include --->" + temp1.toString());

		ArrayList<String> tempFileIncludeFiles = new ArrayList<>();
		// ʼҪhead
		for (KFileIncludeHead head : heads) {
			String src = head.getSrcFilePath();
			ArrayList<String> headNames = head.getHeads();

			for (String headName : headNames) {
				// ˴ʣ·ָʲô·,Ŀǰԭļ·
				// ··ؾ·򱣳ԭ
				System.out.println("--->try add --->" + headName);
				String realName = caculatePath(src, headName);
				File file = new File(realName);

				if (!file.exists() || !file.isFile()) {
					// realNameһ·һ򵥵·"debug.h"
					// ƥincsµ.hļ
					if (temp1.contains(realName)) {
						int index = temp1.indexOf(realName);
						String absoulteName = tempIncludeFiles.get(index).getAbsolutePath();
						// ֤ظ
						if (!tempFileIncludeFiles.contains(absoulteName)) {
							System.out.println("add include head file---->" + absoulteName);
							tempFileIncludeFiles.add(absoulteName);
						} else {
							System.out.println(headName + " has exist");
						}
						continue;
					}
					// ûincsҵԴļͬĿ¼Ѱ
					File srcf = new File(src);
					if (srcf.exists() && srcf.isFile()) {
						String parent = srcf.getParentFile().getAbsolutePath();
						File target = new File(parent + File.separator + realName);
						if (target != null && target.exists() && target.isFile()
								&& !tempFileIncludeFiles.contains(target.getAbsolutePath())) {
							System.out.println("add include head file---->" + target.getAbsolutePath());
							tempFileIncludeFiles.add(target.getAbsolutePath());
						} else if (tempFileIncludeFiles.contains(target.getAbsolutePath())) {
							System.out.println(headName + " has exist");
						}
						continue;
					}
					System.out.println("^^^^^~~~~~~~~^^^^^^^^^^not found " + realName);

				} else {
					// realNameһ·,Ӧֱ
					if (!tempFileIncludeFiles.contains(realName)) {
						System.out.println("add include head file---->" + realName);
						tempFileIncludeFiles.add(realName);
					}
				}
			}

		}
		///////// print tempFileIncludeFiles//////////////

		System.out.println(">>>>>>>>>>>>>print  tempFileIncludeFiles");
		for (String s : tempFileIncludeFiles) {
			System.out.println("--->" + s);
		}
		// copy
		ArrayList<String> tempCopy = new ArrayList<>();
		for (int i = 0; i < tempFileIncludeFiles.size(); i++) {
			String f = tempFileIncludeFiles.get(i);
			tempCopy.add(f);
		}
		////////// loop //////////////
		System.out.println(">>>>>>>>>>>>>loop  mergeFileIncludeToCurrent");
		for (int i = 0; i < tempCopy.size(); i++) {
			String f = tempCopy.get(i);
			tempFileIncludeFiles = mergeFileIncludeToCurrent(tempIncludeFiles, f, tempFileIncludeFiles);
		}
		/*
		 * for(String f:tempFileIncludeFiles) {
		 * tempFileIncludeFiles=mergeFileIncludeToCurrent(tempIncludeFiles,f,
		 * tempFileIncludeFiles); }
		 */

		for (String t : tempFileIncludeFiles) {
			File file = new File(t);
			if (file.exists() && file.isFile()) {
				EFile file2 = new EFile(file.getName());
				file2.setSrcKeilPath(t);
				includEFolder.addChildrenFiles(file2);
			}
		}

		folder.addChildrenFolders(includEFolder);
		return folder;
	}

	private ArrayList<String> mergeFileIncludeToCurrent(ArrayList<File> tempIncludeFiles, String srcFile,
			ArrayList<String> current) {
		System.out.println(">>>>>>>>>>>>>mergeFileIncludeToCurrent --->" + srcFile);
		ArrayList<String> temp1 = new ArrayList<>();
		for (int i = 0; i < tempIncludeFiles.size(); i++) {
			temp1.add(tempIncludeFiles.get(i).getName());
		}

		KFileIncludeHead head = FileIncludeRegexParseUtil.getInstance().getByFileName(srcFile);
		if (head != null) {
			// 
			return current;
		}
		// 
		FileIncludeRegexParseUtil.getInstance().parseFile(srcFile);
		head = FileIncludeRegexParseUtil.getInstance().getByFileName(srcFile);
		if (head == null) {
			System.out.println("parseFile fail");
			return current;
		}
		// merge

		// KFileIncludeHead,ԪӦǾ·
		ArrayList<String> tempFileIncludeFiles = new ArrayList<>();

		String src = head.getSrcFilePath();
		ArrayList<String> headNames = head.getHeads();
		if (headNames == null || headNames.size() == 0) {
			System.out.println("this file dont has header!");

		}
		for (String headName : headNames) {
			// ˴ʣ·ָʲô·,Ŀǰԭļ·
			// ··ؾ·򱣳ԭ
			// System.out.println("handle header-->"+headName);
			String realName = caculatePath(src, headName);
			File file = new File(realName);
			System.out.println("realName-->" + realName);
			if (!file.exists() || !file.isFile()) {
				// realNameһ·һ򵥵·"debug.h"
				// ƥincsµ.hļ
				System.out.println("pattern-->incs");
				if (temp1.contains(realName)) {
					int index = temp1.indexOf(realName);
					String absoulteName = tempIncludeFiles.get(index).getAbsolutePath();
					// ֤ظ
					if (!tempFileIncludeFiles.contains(absoulteName)) {
						System.out.println("add include head file---->" + absoulteName);
						tempFileIncludeFiles.add(absoulteName);
					}
					continue;
				}
				System.out.println("pattern-->next directory");
				// ûincsҵԴļͬĿ¼Ѱ
				File srcf = new File(src);
				if (srcf.exists() && srcf.isFile()) {
					String parent = srcf.getParentFile().getAbsolutePath();
					File target = new File(parent + File.separator + realName);
					if (target != null && target.exists() && target.isFile()) {
						if (!tempFileIncludeFiles.contains(target.getAbsolutePath())) {
							System.out.println("add include head file---->" + target.getAbsolutePath());
						} else {
							System.out.println(
									"add include head file (NO)---->" + target.getAbsolutePath() + " has exist");
						}
						continue;
					} else {
						System.out.println(target.getAbsolutePath() + " don't exist");
					}

				}
				System.out.println("^^realName^^^~~~~~~~~^^^^^^^^^^not found " + realName);

			} else {
				// realNameһ·,Ӧֱ
				if (!tempFileIncludeFiles.contains(realName)) {
					System.out.println("add include head file---->" + realName);
					tempFileIncludeFiles.add(realName);
				}
			}
		}

		for (String t : tempFileIncludeFiles) {
			if (current.contains(t)) {
				System.out.println("current has contain---->" + t + " so don't loop");
				continue;
			} else {
				current.add(t);
				System.out.println("current has not contain---->" + t + " so  loop");
				current = mergeFileIncludeToCurrent(tempIncludeFiles, t, current);
			}
		}

		return current;
	}

	private EFolder mergeCadsIncludeFilesToFolder(EFolder folder) throws Exception {
		System.out.println("===========merge Cads IncludeFiles To Folder===========");
		EFolder includEFolder = new EFolder(includeFolderName);
		if (entry == null) {
			return folder;
		}
		String includePaths = entry.getkCads().getIncludePaths();
		if (includePaths == null || includePaths.equalsIgnoreCase("")) {

		} else {
			String[] paths = includePaths.split(";");
			if (paths != null && paths.length != 0) {
				for (int i = 0; i < paths.length; i++) {
					String path = caculatePath(keilPath, paths[i]);
					System.out.println("IncludePath---->" + path);
					File file = new File(path);
					if (!file.exists()) {
						System.out.println(path + " don't exist");
						LogUtil.add(path + " don't exist");
						continue;
					}
					if (!file.isDirectory()) {
						System.out.println(path + " isn't directory");
						LogUtil.add(path + " don't exist");
						continue;
					}

					File[] files = file.listFiles(new FileFilter() {

						@Override
						public boolean accept(File pathname) {
							// TODO Auto-generated method stub
							return pathname.getName().endsWith(".h") || pathname.getName().endsWith(".H");
						}
					});
					if (files == null) {
						continue;
					}
					for (int j = 0; j < files.length; j++) {
						EFile f = new EFile(files[j].getName());
						// f.setSrcKeilPath(files[j].getAbsolutePath());
						f.setSrcKeilPath(paths[i] + File.separator + files[j].getName());
						includEFolder.addChildrenFiles(f);
						System.out.println("includeFolder add file " + f.getName());
					}

				}

			}
			folder.addChildrenFolders(includEFolder);
		}
		return folder;
	}

	private void createTempFilesForCompare(EFolder folder) throws Exception {
		String newNameString = folder.getName() + ConvertProjectImp.suffix_compare_folder;
		folder.setName(newNameString);
		folder.setPath(projectLocation + File.separator + newNameString);

		EFolder folder3 = caculatePath(folder);
		createFileByEFolder(folder3);
	}

	private void createFileByEFolder(EFolder folder) throws Exception {
		System.out.println("======================================create File By EFolder===================");
		List<EFile> files = folder.getChildrenFiles();
		List<EFolder> folders = folder.getChildrenFolders();
		for (EFile f : files) {
			System.out.println("Efile: " + f.getSrcKeilPath() + " to " + f.getDstEclipsePath());
			String path = f.getDstEclipsePath();
			File file = new File(path);
			if (!file.exists()) {
				file.getParentFile().mkdirs();
				// file.createNewFile();
			} else {
				file.delete();
			}
			File f1 = new File(f.getSrcKeilPath());
			if (!f1.exists()) {
				throw new Exception(f1.getAbsolutePath() + " " + "don't exist!");
			}
			copy(f1, file);

		}
		for (EFolder fd : folders) {
			System.out.println("Efolder: " + fd.getPath());
			String path = fd.getPath();
			File file = new File(path);
			if (!file.exists()) {
				file.mkdirs();
			}
			createFileByEFolder(fd);
		}
	}

	private void copy(File source, File dest) throws Exception {
		Files.copy(source.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING,
				StandardCopyOption.COPY_ATTRIBUTES);

	}

	public void getArmAdsMisc(Element element) {
		if (!element.getName().equalsIgnoreCase("ArmAdsMisc")) {
			return;
		}
		System.out.println("=======================getArmAdsMisc");
		KROM ROM1;
		KROM ROM2;
		KROM ROM3;
		KROM IROM1;
		KROM IROM2;

		KRAM RAM1;
		KRAM RAM2;
		KRAM RAM3;
		KRAM IRAM1;
		KRAM IRAM2;

		{
			ROM1 = new KROM("ROM1");
			ROM1.setDefault("1".equalsIgnoreCase(getValue(element, "Ro1Chk")));
			ROM1.setStartUp("1".equalsIgnoreCase(getValue(element, "StupSel")));
			ROM1.setStartAddress(getValue(element, "OnChipMemories", "OCR_RVCT1", "StartAddress"));
			ROM1.setSize(getValue(element, "OnChipMemories", "OCR_RVCT1", "Size"));

			ROM2 = new KROM("ROM2");
			ROM2.setDefault("1".equalsIgnoreCase(getValue(element, "Ro2Chk")));
			ROM2.setStartUp("2".equalsIgnoreCase(getValue(element, "StupSel")));
			ROM2.setStartAddress(getValue(element, "OnChipMemories", "OCR_RVCT2", "StartAddress"));
			ROM2.setSize(getValue(element, "OnChipMemories", "OCR_RVCT2", "Size"));

			ROM3 = new KROM("ROM3");
			ROM3.setDefault("1".equalsIgnoreCase(getValue(element, "Ro3Chk")));
			ROM3.setStartUp("4".equalsIgnoreCase(getValue(element, "StupSel")));
			ROM3.setStartAddress(getValue(element, "OnChipMemories", "OCR_RVCT3", "StartAddress"));
			ROM3.setSize(getValue(element, "OnChipMemories", "OCR_RVCT3", "Size"));

			IROM1 = new KROM("IROM1");
			IROM1.setDefault("1".equalsIgnoreCase(getValue(element, "Ir1Chk")));
			IROM1.setStartUp("8".equalsIgnoreCase(getValue(element, "StupSel")));
			IROM1.setStartAddress(getValue(element, "OnChipMemories", "OCR_RVCT4", "StartAddress"));
			IROM1.setSize(getValue(element, "OnChipMemories", "OCR_RVCT4", "Size"));

			IROM2 = new KROM("IROM2");
			IROM2.setDefault("1".equalsIgnoreCase(getValue(element, "Ir2Chk")));
			IROM2.setStartUp("16".equalsIgnoreCase(getValue(element, "StupSel")));
			IROM2.setStartAddress(getValue(element, "OnChipMemories", "OCR_RVCT5", "StartAddress"));
			IROM2.setSize(getValue(element, "OnChipMemories", "OCR_RVCT5", "Size"));

			RAM1 = new KRAM("RAM1");
			RAM1.setDefault("1".equalsIgnoreCase(getValue(element, "Ra1Chk")));
			RAM1.setNoInit("1".equalsIgnoreCase(getValue(element, "NoZi1")));
			RAM1.setStartAddress(getValue(element, "OnChipMemories", "OCR_RVCT6", "StartAddress"));
			RAM1.setSize(getValue(element, "OnChipMemories", "OCR_RVCT6", "Size"));

			RAM2 = new KRAM("RAM2");
			RAM2.setDefault("1".equalsIgnoreCase(getValue(element, "Ra2Chk")));
			RAM2.setNoInit("1".equalsIgnoreCase(getValue(element, "NoZi2")));
			RAM2.setStartAddress(getValue(element, "OnChipMemories", "OCR_RVCT7", "StartAddress"));
			RAM2.setSize(getValue(element, "OnChipMemories", "OCR_RVCT7", "Size"));

			RAM3 = new KRAM("RAM3");
			RAM3.setDefault("1".equalsIgnoreCase(getValue(element, "Ra3Chk")));
			RAM3.setNoInit("1".equalsIgnoreCase(getValue(element, "NoZi3")));
			RAM3.setStartAddress(getValue(element, "OnChipMemories", "OCR_RVCT8", "StartAddress"));
			RAM3.setSize(getValue(element, "OnChipMemories", "OCR_RVCT8", "Size"));

			IRAM1 = new KRAM("IRAM1");
			IRAM1.setDefault("1".equalsIgnoreCase(getValue(element, "Im1Chk")));
			IRAM1.setNoInit("1".equalsIgnoreCase(getValue(element, "NoZi4")));
			IRAM1.setStartAddress(getValue(element, "OnChipMemories", "OCR_RVCT9", "StartAddress"));
			IRAM1.setSize(getValue(element, "OnChipMemories", "OCR_RVCT9", "Size"));

			IRAM2 = new KRAM("IRAM2");
			IRAM2.setDefault("1".equalsIgnoreCase(getValue(element, "Im2Chk")));
			IRAM2.setNoInit("1".equalsIgnoreCase(getValue(element, "NoZi5")));
			IRAM2.setStartAddress(getValue(element, "OnChipMemories", "OCR_RVCT10", "StartAddress"));
			IRAM2.setSize(getValue(element, "OnChipMemories", "OCR_RVCT10", "Size"));

		}

	}

	private String getValue(Element element, String childName) {
		Element element2 = element.getChild(childName);
		if (element2 == null) {
			return null;
		} else {
			return element2.getValue();
		}
	}

	private String getValue(Element element, String father, String child) {
		Element element2 = element.getChild(father);
		if (element2 == null) {
			return null;
		} else {
			return getValue(element2, child);
		}
	}

	private String getValue(Element element, String father, String child, String next) {
		Element element2 = element.getChild(father);
		if (element2 == null) {
			return null;
		} else {
			return getValue(element2, child, next);
		}
	}

	public void getCads(Element element) {
		if (!element.getName().equalsIgnoreCase("Cads")) {
			return;
		}
		System.out.println("=======================getCads");
		Element element2 = element.getChild("VariousControls");
		if (element2 == null) {
			return;
		}
		KCads cads = new KCads();
		Element element3 = element2.getChild("Define");
		if (element3 != null) {
			cads.setDefine(element3.getValue());
			System.out.println("------->Cads Define---->" + element3.getValue());
		}
		Element element4 = element2.getChild("IncludePath");
		if (element3 != null) {
			cads.setIncludePaths(element4.getValue());
			System.out.println("------->Cads IncludePaths---->" + element4.getValue());
		}
		if (entry != null) {
			entry.setkCads(cads);
		}
	}

	public void getAads(Element element) {
		if (!element.getName().equalsIgnoreCase("Aads")) {
			return;
		}
		System.out.println("=======================getAads");
		Element element2 = element.getChild("VariousControls");
		if (element2 == null) {
			return;
		}
		KAads ads = new KAads();
		Element element3 = element2.getChild("Define");
		if (element3 != null) {
			ads.setDefine(element3.getValue());
			System.out.println("------->Aads Define---->" + element3.getValue());
		}
		Element element4 = element2.getChild("IncludePath");
		if (element3 != null) {
			ads.setIncludePaths(element4.getValue());
			System.out.println("------->Aads IncludePaths---->" + element4.getValue());
		}
		if (entry != null) {
			entry.setkAads(ads);
		}
	}

	public EFolder parseGroups(Element element) {
		if (!element.getName().equalsIgnoreCase("Groups")) {
			return null;
		}
		System.out.println("find node Groups");
		EFolder folder = new EFolder(projectName);
		List<Element> childrenList = element.getChildren();
		for (Element o : childrenList) {
			EFolder f = parseGroup(o);
			if (f != null) {
				folder.addChildrenFolders(f);
				System.out.println("folder " + folder.getName() + " add addChildrenFolder " + f.getName());
			}
		}
		return folder;
	}

	private EFolder parseGroup(Element element) {
		if (!element.getName().equalsIgnoreCase("Group")) {
			return null;
		}
		System.out.println("find node Group");
		EFolder folder = null;
		List<Element> childrenList = element.getChildren();
		for (Element o : childrenList) {
			if (o.getName().equalsIgnoreCase("GroupName")) {
				folder = new EFolder(o.getValue());
			} else if (o.getName().equalsIgnoreCase("Files")) {
				//
				List<Element> fs = o.getChildren();
				for (Element f : fs) {
					if (f.getName().equalsIgnoreCase("File")) {
						if (folder != null) {
							Element n = f.getChild("FileName");
							Element p = f.getChild("FilePath");
							if (n != null && p != null) {
								EFile file = new EFile(n.getValue());
								file.setSrcKeilPath(p.getValue());
								folder.addChildrenFiles(file);
								System.out.println(
										"folder " + folder.getName() + " add addChildrenFile " + file.getName());
								////////////////////////////////////////////////////////////////// \
								if (enableSelectIncludePath) {
									FileIncludeRegexParseUtil.getInstance()
											.parseFile(caculatePath(keilPath, p.getValue()));
								}
								//////////////////////////////////////////////////////////////////
							}
						}

					}
				}
			}

		}
		return folder;
	}

	public EFolder parseElement1(Element element) {
		// System.out.println(">>>>>>>>>ȡڵstart>>>>>>parseElement1");
		EFolder folder = parseGroups(element);
		if (folder != null) {
			return folder;
		}
		getCads(element);
		getAads(element);
		List<Element> childrenList = element.getChildren();
		if (childrenList.size() == 0) {
			// System.out.println("ȡֵ-->"+element.getName()+":"+element.getValue());
		} else {
			for (Element o : childrenList) {
				EFolder f = parseElement1(o);
				if (f != null) {
					return f;
				}
			}
		}
		// System.out.println("retuen null");
		return null;
	}

	public void parseElement(Element element) {
		System.out.println(">>>>>>>>>get node start>>>>>>" + element.getName());
		List<Attribute> attributes = element.getAttributes();
		for (Attribute attr : attributes) {
			System.out.println("get attrbute-->" + attr.getName() + ":" + attr.getValue());
		}
		List<Element> childrenList = element.getChildren();
		if (childrenList.size() == 0) {
			System.out.println("get value-->" + element.getName() + ":" + element.getValue());
		} else {
			for (Element o : childrenList) {

				parseElement(o);

			}
		}
		// System.out.println(">>>>>>>>ȡڵend>>>>>>>>>>"+"\r\n");
	}

}
